/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.filter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.graphic.XGraphic;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.UnsupportedEncodingException;
import writer2latex.api.GraphicConverter;
import writer2latex.filter.ByteArrayXStream;

public class GraphicConverterImpl
implements GraphicConverter {
    private byte[] psStart;
    private byte[] psEnd;
    private XGraphicProvider xGraphicProvider;
    static /* synthetic */ Class class$com$sun$star$graphic$XGraphicProvider;

    public GraphicConverterImpl(XComponentContext xComponentContext) {
        try {
            XMultiComponentFactory xMCF = xComponentContext.getServiceManager();
            Object graphicProviderObject = xMCF.createInstanceWithContext("com.sun.star.graphic.GraphicProvider", xComponentContext);
            this.xGraphicProvider = (XGraphicProvider)UnoRuntime.queryInterface((Class)(class$com$sun$star$graphic$XGraphicProvider == null ? (class$com$sun$star$graphic$XGraphicProvider = GraphicConverterImpl.class$("com.sun.star.graphic.XGraphicProvider")) : class$com$sun$star$graphic$XGraphicProvider), (Object)graphicProviderObject);
        }
        catch (Exception ex) {
            System.err.println("Failed to get XGraphicProvider object");
            this.xGraphicProvider = null;
        }
        try {
            this.psStart = "%!PS-Adobe".getBytes("US-ASCII");
            this.psEnd = "%%EOF".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public boolean supportsFormat(String sMime) {
        return "image/png".equals(sMime) || "image/jpeg".equals(sMime) || "image/gif".equals(sMime) || "image/tiff".equals(sMime) || "image/bmp".equals(sMime) || "image/x-wmf".equals(sMime) || "image/x-svm".equals(sMime) || "image/x-eps".equals(sMime);
    }

    public byte[] convert(byte[] source, String sSourceMime, String sTargetMime) {
        if ("image/x-eps".equals(sTargetMime) && !"image/x-wmf".equals(sSourceMime) && !"image/x-svm".equals(sSourceMime)) {
            return null;
        }
        ByteArrayToXInputStreamAdapter xSource = new ByteArrayToXInputStreamAdapter(source);
        ByteArrayXStream xTarget = new ByteArrayXStream();
        try {
            PropertyValue[] sourceProps = new PropertyValue[]{new PropertyValue()};
            sourceProps[0].Name = "InputStream";
            sourceProps[0].Value = xSource;
            XGraphic result = this.xGraphicProvider.queryGraphic(sourceProps);
            PropertyValue[] targetProps = new PropertyValue[2];
            targetProps[0] = new PropertyValue();
            targetProps[0].Name = "MimeType";
            targetProps[0].Value = sTargetMime;
            targetProps[1] = new PropertyValue();
            targetProps[1].Name = "OutputStream";
            targetProps[1].Value = xTarget;
            this.xGraphicProvider.storeGraphic(result, targetProps);
            xTarget.closeOutput();
            xTarget.flush();
            if ("image/x-eps".equals(sTargetMime)) {
                return this.cleanEps(xTarget.getBuffer());
            }
            return xTarget.getBuffer();
        }
        catch (IOException e) {}
        catch (IllegalArgumentException e) {}
        catch (WrappedTargetException e) {}
        finally {
            return null;
        }
    }

    private byte[] cleanEps(byte[] blob) {
        int n = blob.length;
        int nStart = 0;
        int i = 0;
        while (i < n) {
            if (this.match(blob, this.psStart, i)) {
                nStart = i;
                break;
            }
            ++i;
        }
        int nEnd = n;
        int i2 = nStart;
        while (i2 < n) {
            if (this.match(blob, this.psEnd, i2)) {
                nEnd = i2 + this.psEnd.length;
                break;
            }
            ++i2;
        }
        byte[] newBlob = new byte[nEnd - nStart];
        System.arraycopy(blob, nStart, newBlob, 0, nEnd - nStart);
        return newBlob;
    }

    private boolean match(byte[] blob, byte[] sig, int nStart) {
        int n = sig.length;
        if (nStart + n >= blob.length) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (blob[nStart + i] != sig[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

