#include "ModelSelector.h"
#include "UIGtk.h"
#include "interface.h"
#include "support.h"

#include <gtk/gtksignal.h>

ModelSelector::ModelSelector ()
{
   m_RModel = NULL;
}

ModelSelector::~ModelSelector()
{}

void 
ModelSelector::Load()
{
   Ark::AutoStream f("{models}/models.lst");
   std::ifstream &stream = f.Get();

   do
   {
      Model mdl;
      // FIXME: remove those hardcoded limits
      char mdlname[256], decorname[256], size[50];
      
      stream.getline (mdlname, 256, ':');
      stream.getline (decorname, 256, ':');
      stream.getline (size, 50, '\n');
      Ark::StringToScalar(std::string(size), mdl.m_Size);

      if (!stream)
	 break;

      //std::cerr << mdlname << "//" << decorname << endl;
      mdl.m_ModelName = mdlname;
      mdl.m_DecoratedName = decorname;

      m_Models.push_back (mdl);
   } while (1);
   m_Selector = create_ModelSelectorWindow ();

   GtkWidget *list = lookup_widget (m_Selector, "ModelSelectorList");
   ModelList::iterator it;
   for (it = m_Models.begin(); it != m_Models.end(); it++)
   {
      GtkWidget *item = gtk_list_item_new_with_label
	 (it->m_DecoratedName.c_str());
      
      gtk_object_set_data(GTK_OBJECT(item),"name",
			  const_cast<char*>(it->m_ModelName.c_str()));
      gtk_widget_show (item);
      gtk_container_add (GTK_CONTAINER(list), item);
   }
}

Ark::String
ModelSelector::SelectModel (const Ark::String &prev)
{
   m_Result = RES_NONE;

   if (m_Selector == NULL)
      Load();

   //std::cerr << "rmodelname " << (void*) &m_RModel << endl;
   gtk_object_set_data(GTK_OBJECT(m_Selector), "modelname", &m_RModel);
   gtk_object_set_data(GTK_OBJECT(m_Selector), "result", &m_Result);

   gtk_widget_show (m_Selector);

   while (m_Result == RES_NONE)
      gtk_main_iteration();
   std::cerr << m_RModel<<" (rmodel)\n";
   if (m_RModel == NULL || m_Result != RES_OK)
      return prev;
   else
      return m_RModel;
}

ModelSelector g_ModelSelector;
