/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.ds.DataSheet;
import WIMSchem.ds.DataSheetStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Stack;

public class DataSheetCache {
    private final int MAX_UNDO = 10;
    private Stack<String> undo = new Stack();
    private Stack<String> redo = new Stack();

    public boolean CanUndo() {
        return !this.undo.empty();
    }

    public boolean CanRedo() {
        return !this.redo.empty();
    }

    public void CacheUndo(DataSheet DS) {
        String str = this.ToString(DS);
        this.undo.push(str);
        while (this.undo.size() > 10) {
            this.undo.remove(0);
        }
        this.redo.clear();
    }

    public DataSheet PerformUndo(DataSheet Cur) {
        if (this.undo.empty()) {
            return null;
        }
        this.redo.push(this.ToString(Cur));
        return this.FromString(this.undo.pop());
    }

    public DataSheet PerformRedo(DataSheet Cur) {
        if (this.redo.empty()) {
            return null;
        }
        this.undo.push(this.ToString(Cur));
        return this.FromString(this.redo.pop());
    }

    private String ToString(DataSheet DS) {
        StringWriter sw = new StringWriter();
        try {
            DataSheetStream.WriteXML(new BufferedWriter(sw), DS);
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    private DataSheet FromString(String StrDS) {
        DataSheet ds = null;
        try {
            if (DataSheetStream.ExamineIsXMLDS(new BufferedReader(new StringReader(StrDS)))) {
                ds = DataSheetStream.ReadXML(new BufferedReader(new StringReader(StrDS)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ds;
    }
}

