(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.

Lemma mean1 : forall x y:Z, (x <= y)%Z -> (x <= (x + y) / 2)%Z.
Proof.
intros.
assert ((x + y) / 2 >= (x + x) / 2)%Z.
apply Z_div_ge; omega.
assert (((x + x) / 2)%Z = x); auto with *.
replace (x + x)%Z with (0 + x * 2)%Z; auto with *.
rewrite (Z_div_plus 0 x 2); auto with *.
Qed.

Lemma mean2 : forall x y:Z, (x < y)%Z -> ((x + y) / 2 < y)%Z.
Proof.
intros.
apply (Zmult_lt_reg_r ((x + y) / 2) y) with (p:=2).
auto with *.
replace ((x + y) / 2 * 2)%Z with (2 * ((x + y) / 2))%Z; auto with *.
assert (2 * ((x + y) / 2) <= x + y)%Z.
apply (Z_mult_div_ge (x + y) 2).
auto with *.
omega.
Qed.

Hint Resolve mean1 mean2 .

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma sqrt_po_1 : 
  forall (x: Z),
  forall (HW_1: x >= 0),
  (0 * 0) <= x /\ x < ((x + 1) * (x + 1)) /\ 0 < (x + 1).
Proof.
intuition.
ring ((x+1)*(x+1)).
assert (0 <= x*x); auto with *.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma sqrt_po_2 : 
  forall (x: Z),
  forall (HW_1: x >= 0),
  forall (HW_2: (0 * 0) <= x /\ x < ((x + 1) * (x + 1)) /\ 0 < (x + 1)),
  forall (inf: Z),
  forall (sup: Z),
  forall (HW_3: (inf * inf) <= x /\ x < (sup * sup) /\ inf < sup),
  forall (HW_4: (inf + 1) <> sup),
  2 <> 0.
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma sqrt_po_3 : 
  forall (x: Z),
  forall (HW_1: x >= 0),
  forall (HW_2: (0 * 0) <= x /\ x < ((x + 1) * (x + 1)) /\ 0 < (x + 1)),
  forall (inf: Z),
  forall (sup: Z),
  forall (HW_3: (inf * inf) <= x /\ x < (sup * sup) /\ inf < sup),
  forall (HW_4: (inf + 1) <> sup),
  forall (HW_5: 2 <> 0),
  forall (result: Z),
  forall (HW_6: result = ((Zdiv (inf + sup + 1) 2))),
  forall (mil: Z),
  forall (HW_7: mil = result),
  forall (HW_8: x < (mil * mil)),
  forall (sup0: Z),
  forall (HW_9: sup0 = mil),
  ((inf * inf) <= x /\ x < (sup0 * sup0) /\ inf < sup0) /\
  (Zwf 0 (sup0 - inf) (sup - inf)).
Proof.
intuition.
subst sup0; trivial.
subst.
replace (inf + sup + 1)%Z with (inf + (sup - 1) + 1 * 2)%Z;
 try omega.
rewrite Z_div_plus; try omega.
assert (inf <= (inf + (sup - 1)) / 2)%Z.
apply mean1; omega.
omega.
unfold Zwf.
split; try omega.
subst.
 replace (inf + sup + 1)%Z with (inf + 1 + sup)%Z; try omega.
assert ((inf + 1 + sup) / 2 < sup)%Z.
apply mean2; omega.
omega.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma sqrt_po_4 : 
  forall (x: Z),
  forall (HW_1: x >= 0),
  forall (HW_2: (0 * 0) <= x /\ x < ((x + 1) * (x + 1)) /\ 0 < (x + 1)),
  forall (inf: Z),
  forall (sup: Z),
  forall (HW_3: (inf * inf) <= x /\ x < (sup * sup) /\ inf < sup),
  forall (HW_4: (inf + 1) <> sup),
  forall (HW_5: 2 <> 0),
  forall (result: Z),
  forall (HW_6: result = ((Zdiv (inf + sup + 1) 2))),
  forall (mil: Z),
  forall (HW_7: mil = result),
  forall (HW_10: x >= (mil * mil)),
  forall (inf0: Z),
  forall (HW_11: inf0 = mil),
  ((inf0 * inf0) <= x /\ x < (sup * sup) /\ inf0 < sup) /\
  (Zwf 0 (sup - inf0) (sup - inf)).
Proof.
intuition.
subst; omega.
subst.
replace (inf + sup + 1)%Z with (inf + 1 + sup)%Z; try omega.
assert ((inf + 1 + sup) / 2 < sup)%Z.
apply mean2; omega.
omega.
unfold Zwf; split; try omega.
subst.
replace (inf + sup + 1)%Z with (inf + 1 + sup)%Z; try omega.
assert (inf + 1 <= (inf + 1 + sup) / 2)%Z.
apply mean1; omega.
omega.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma sqrt_po_5 : 
  forall (x: Z),
  forall (HW_1: x >= 0),
  forall (HW_2: (0 * 0) <= x /\ x < ((x + 1) * (x + 1)) /\ 0 < (x + 1)),
  forall (inf: Z),
  forall (sup: Z),
  forall (HW_3: (inf * inf) <= x /\ x < (sup * sup) /\ inf < sup),
  forall (HW_12: (inf + 1) = sup),
  (inf * inf) <= x /\ x < ((inf + 1) * (inf + 1)).
Proof.
intuition.
subst sup; omega.
Qed.


