/*
 * SFImage.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFIMAGE_H
#define _SFIMAGE_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif
#ifndef _ARRAY_H
#include "Array.h"
#endif

class SFImage : public FieldValue {
public:
			SFImage(int width, int height, int depth, const int *pixels);
			SFImage(void); // silly default

    virtual int         getType() const { return SFIMAGE; }
    virtual const char *getTypeName() const { return "SFImage"; }
    virtual int	        write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual FieldValue *copy() { return new SFImage(*this); }

    int			getWidth() const { return _width; }
    int			getHeight() const { return _height; }
    int			getDepth() const { return _depth; }
    const int	       *getPixels() const { return _pixels.getData(); }

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return true; }
    bool                hasAnimationSupport() { return false; }

private:
    int			_width;
    int			_height;
    int			_depth;
    Array<int>		_pixels;
};

#endif // _SFIMAGE_H
