/* valatokentype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatokentype.h>







const char* vala_token_type_to_string (ValaTokenType self) {
	ValaTokenType _tmp112;
	_tmp112 = self;
	if (_tmp112 == VALA_TOKEN_TYPE_ABSTRACT)
	do {
		return "`abstract'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_AS)
	do {
		return "`as'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN)
	do {
		return "`='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_ADD)
	do {
		return "`+='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND)
	do {
		return "`&='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR)
	do {
		return "`|='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR)
	do {
		return "`^='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_DIV)
	do {
		return "`/='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_MUL)
	do {
		return "`*='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_PERCENT)
	do {
		return "`%='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT)
	do {
		return "`<<='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ASSIGN_SUB)
	do {
		return "`-='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_BASE)
	do {
		return "`base'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_BITWISE_AND)
	do {
		return "`&'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_BITWISE_OR)
	do {
		return "`|'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_BREAK)
	do {
		return "`break'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CARRET)
	do {
		return "`^'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CASE)
	do {
		return "`case'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CATCH)
	do {
		return "`catch'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CHARACTER_LITERAL)
	do {
		return "character literal";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CLASS)
	do {
		return "`class'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CLOSE_BRACE)
	do {
		return "`}'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CLOSE_BRACKET)
	do {
		return "`]'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CLOSE_PARENS)
	do {
		return "`)'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_COLON)
	do {
		return "`:'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_COMMA)
	do {
		return "`,'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CONST)
	do {
		return "`const'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CONSTRUCT)
	do {
		return "`construct'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_CONTINUE)
	do {
		return "`continue'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_DEFAULT)
	do {
		return "`default'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_DELEGATE)
	do {
		return "`delegate'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_DELETE)
	do {
		return "`delete'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_DIV)
	do {
		return "`/'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_DO)
	do {
		return "`do'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_DOT)
	do {
		return "`.'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ELLIPSIS)
	do {
		return "`...'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ELSE)
	do {
		return "`else'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ENUM)
	do {
		return "`enum'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ENSURES)
	do {
		return "`ensures'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_ERRORDOMAIN)
	do {
		return "`errordomain'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_EOF)
	do {
		return "end of file";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_FALSE)
	do {
		return "`false'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_FINALLY)
	do {
		return "`finally'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_FOR)
	do {
		return "`for'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_FOREACH)
	do {
		return "`foreach'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_GET)
	do {
		return "`get'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_HASH)
	do {
		return "`hash'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_IDENTIFIER)
	do {
		return "identifier";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_IF)
	do {
		return "`if'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_IN)
	do {
		return "`in'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_INLINE)
	do {
		return "`inline'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_INTEGER_LITERAL)
	do {
		return "integer literal";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_INTERFACE)
	do {
		return "`interface'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_INTERR)
	do {
		return "`?'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_IS)
	do {
		return "`is'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_LAMBDA)
	do {
		return "`=>'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_LOCK)
	do {
		return "`lock'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_MINUS)
	do {
		return "`-'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_NAMESPACE)
	do {
		return "`namespace'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_NEW)
	do {
		return "`new'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_NULL)
	do {
		return "`null'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OUT)
	do {
		return "`out'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_AND)
	do {
		return "`&&'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_DEC)
	do {
		return "`--'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_EQ)
	do {
		return "`=='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_GE)
	do {
		return "`>='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_GT)
	do {
		return "`>'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_INC)
	do {
		return "`++'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_LE)
	do {
		return "`<='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_LT)
	do {
		return "`<'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_NE)
	do {
		return "`!='";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_NEG)
	do {
		return "`!'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_OR)
	do {
		return "`||'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_PTR)
	do {
		return "`->'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OP_SHIFT_LEFT)
	do {
		return "`<<'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OPEN_BRACE)
	do {
		return "`{'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OPEN_BRACKET)
	do {
		return "`['";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OPEN_PARENS)
	do {
		return "`('";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_OVERRIDE)
	do {
		return "`override'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_PERCENT)
	do {
		return "`%'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_PLUS)
	do {
		return "`+'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_PRIVATE)
	do {
		return "`private'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_PROTECTED)
	do {
		return "`protected'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_PUBLIC)
	do {
		return "`public'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_REAL_LITERAL)
	do {
		return "real literal";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_REF)
	do {
		return "`ref'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_REQUIRES)
	do {
		return "`requires'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_RETURN)
	do {
		return "`return'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_SEMICOLON)
	do {
		return "`;'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_SET)
	do {
		return "`set'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_SIGNAL)
	do {
		return "`signal'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_SIZEOF)
	do {
		return "`sizeof'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_STAR)
	do {
		return "`*'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_STATIC)
	do {
		return "`static'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_STRING_LITERAL)
	do {
		return "string literal";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_STRUCT)
	do {
		return "`struct'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_SWITCH)
	do {
		return "`switch'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_THIS)
	do {
		return "`this'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_THROW)
	do {
		return "`throw'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_THROWS)
	do {
		return "`throws'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_TILDE)
	do {
		return "`~'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_TRUE)
	do {
		return "`true'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_TRY)
	do {
		return "`try'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_TYPEOF)
	do {
		return "`typeof'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_USING)
	do {
		return "`using'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_VAR)
	do {
		return "`var'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_VIRTUAL)
	do {
		return "`virtual'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_VOID)
	do {
		return "`void'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_VOLATILE)
	do {
		return "`volatile'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_WEAK)
	do {
		return "`weak'";
	} while (0); else if (_tmp112 == VALA_TOKEN_TYPE_WHILE)
	do {
		return "`while'";
	} while (0); else
	do {
		return "unknown token";
	} while (0);
}



GType vala_token_type_get_type (void) {
	static GType vala_token_type_type_id = 0;
	if (G_UNLIKELY (vala_token_type_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_TOKEN_TYPE_NONE, "VALA_TOKEN_TYPE_NONE", "none"}, {VALA_TOKEN_TYPE_ABSTRACT, "VALA_TOKEN_TYPE_ABSTRACT", "abstract"}, {VALA_TOKEN_TYPE_AS, "VALA_TOKEN_TYPE_AS", "as"}, {VALA_TOKEN_TYPE_ASSIGN, "VALA_TOKEN_TYPE_ASSIGN", "assign"}, {VALA_TOKEN_TYPE_ASSIGN_ADD, "VALA_TOKEN_TYPE_ASSIGN_ADD", "assign-add"}, {VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND, "VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND", "assign-bitwise-and"}, {VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR, "VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR", "assign-bitwise-or"}, {VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR, "VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR", "assign-bitwise-xor"}, {VALA_TOKEN_TYPE_ASSIGN_DIV, "VALA_TOKEN_TYPE_ASSIGN_DIV", "assign-div"}, {VALA_TOKEN_TYPE_ASSIGN_MUL, "VALA_TOKEN_TYPE_ASSIGN_MUL", "assign-mul"}, {VALA_TOKEN_TYPE_ASSIGN_PERCENT, "VALA_TOKEN_TYPE_ASSIGN_PERCENT", "assign-percent"}, {VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT, "VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT", "assign-shift-left"}, {VALA_TOKEN_TYPE_ASSIGN_SUB, "VALA_TOKEN_TYPE_ASSIGN_SUB", "assign-sub"}, {VALA_TOKEN_TYPE_BASE, "VALA_TOKEN_TYPE_BASE", "base"}, {VALA_TOKEN_TYPE_BITWISE_AND, "VALA_TOKEN_TYPE_BITWISE_AND", "bitwise-and"}, {VALA_TOKEN_TYPE_BITWISE_OR, "VALA_TOKEN_TYPE_BITWISE_OR", "bitwise-or"}, {VALA_TOKEN_TYPE_BREAK, "VALA_TOKEN_TYPE_BREAK", "break"}, {VALA_TOKEN_TYPE_CARRET, "VALA_TOKEN_TYPE_CARRET", "carret"}, {VALA_TOKEN_TYPE_CASE, "VALA_TOKEN_TYPE_CASE", "case"}, {VALA_TOKEN_TYPE_CATCH, "VALA_TOKEN_TYPE_CATCH", "catch"}, {VALA_TOKEN_TYPE_CHARACTER_LITERAL, "VALA_TOKEN_TYPE_CHARACTER_LITERAL", "character-literal"}, {VALA_TOKEN_TYPE_CLASS, "VALA_TOKEN_TYPE_CLASS", "class"}, {VALA_TOKEN_TYPE_CLOSE_BRACE, "VALA_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {VALA_TOKEN_TYPE_CLOSE_BRACKET, "VALA_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {VALA_TOKEN_TYPE_CLOSE_PARENS, "VALA_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {VALA_TOKEN_TYPE_COLON, "VALA_TOKEN_TYPE_COLON", "colon"}, {VALA_TOKEN_TYPE_COMMA, "VALA_TOKEN_TYPE_COMMA", "comma"}, {VALA_TOKEN_TYPE_CONST, "VALA_TOKEN_TYPE_CONST", "const"}, {VALA_TOKEN_TYPE_CONSTRUCT, "VALA_TOKEN_TYPE_CONSTRUCT", "construct"}, {VALA_TOKEN_TYPE_CONTINUE, "VALA_TOKEN_TYPE_CONTINUE", "continue"}, {VALA_TOKEN_TYPE_DEFAULT, "VALA_TOKEN_TYPE_DEFAULT", "default"}, {VALA_TOKEN_TYPE_DELEGATE, "VALA_TOKEN_TYPE_DELEGATE", "delegate"}, {VALA_TOKEN_TYPE_DELETE, "VALA_TOKEN_TYPE_DELETE", "delete"}, {VALA_TOKEN_TYPE_DIV, "VALA_TOKEN_TYPE_DIV", "div"}, {VALA_TOKEN_TYPE_DO, "VALA_TOKEN_TYPE_DO", "do"}, {VALA_TOKEN_TYPE_DOUBLE_COLON, "VALA_TOKEN_TYPE_DOUBLE_COLON", "double-colon"}, {VALA_TOKEN_TYPE_DOT, "VALA_TOKEN_TYPE_DOT", "dot"}, {VALA_TOKEN_TYPE_DYNAMIC, "VALA_TOKEN_TYPE_DYNAMIC", "dynamic"}, {VALA_TOKEN_TYPE_ELLIPSIS, "VALA_TOKEN_TYPE_ELLIPSIS", "ellipsis"}, {VALA_TOKEN_TYPE_ELSE, "VALA_TOKEN_TYPE_ELSE", "else"}, {VALA_TOKEN_TYPE_ENUM, "VALA_TOKEN_TYPE_ENUM", "enum"}, {VALA_TOKEN_TYPE_ENSURES, "VALA_TOKEN_TYPE_ENSURES", "ensures"}, {VALA_TOKEN_TYPE_ERRORDOMAIN, "VALA_TOKEN_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_TOKEN_TYPE_EOF, "VALA_TOKEN_TYPE_EOF", "eof"}, {VALA_TOKEN_TYPE_EXTERN, "VALA_TOKEN_TYPE_EXTERN", "extern"}, {VALA_TOKEN_TYPE_FALSE, "VALA_TOKEN_TYPE_FALSE", "false"}, {VALA_TOKEN_TYPE_FINALLY, "VALA_TOKEN_TYPE_FINALLY", "finally"}, {VALA_TOKEN_TYPE_FOR, "VALA_TOKEN_TYPE_FOR", "for"}, {VALA_TOKEN_TYPE_FOREACH, "VALA_TOKEN_TYPE_FOREACH", "foreach"}, {VALA_TOKEN_TYPE_GET, "VALA_TOKEN_TYPE_GET", "get"}, {VALA_TOKEN_TYPE_HASH, "VALA_TOKEN_TYPE_HASH", "hash"}, {VALA_TOKEN_TYPE_IDENTIFIER, "VALA_TOKEN_TYPE_IDENTIFIER", "identifier"}, {VALA_TOKEN_TYPE_IF, "VALA_TOKEN_TYPE_IF", "if"}, {VALA_TOKEN_TYPE_IN, "VALA_TOKEN_TYPE_IN", "in"}, {VALA_TOKEN_TYPE_INLINE, "VALA_TOKEN_TYPE_INLINE", "inline"}, {VALA_TOKEN_TYPE_INTEGER_LITERAL, "VALA_TOKEN_TYPE_INTEGER_LITERAL", "integer-literal"}, {VALA_TOKEN_TYPE_INTERFACE, "VALA_TOKEN_TYPE_INTERFACE", "interface"}, {VALA_TOKEN_TYPE_INTERR, "VALA_TOKEN_TYPE_INTERR", "interr"}, {VALA_TOKEN_TYPE_IS, "VALA_TOKEN_TYPE_IS", "is"}, {VALA_TOKEN_TYPE_LAMBDA, "VALA_TOKEN_TYPE_LAMBDA", "lambda"}, {VALA_TOKEN_TYPE_LOCK, "VALA_TOKEN_TYPE_LOCK", "lock"}, {VALA_TOKEN_TYPE_MINUS, "VALA_TOKEN_TYPE_MINUS", "minus"}, {VALA_TOKEN_TYPE_NAMESPACE, "VALA_TOKEN_TYPE_NAMESPACE", "namespace"}, {VALA_TOKEN_TYPE_NEW, "VALA_TOKEN_TYPE_NEW", "new"}, {VALA_TOKEN_TYPE_NULL, "VALA_TOKEN_TYPE_NULL", "null"}, {VALA_TOKEN_TYPE_OUT, "VALA_TOKEN_TYPE_OUT", "out"}, {VALA_TOKEN_TYPE_OP_AND, "VALA_TOKEN_TYPE_OP_AND", "op-and"}, {VALA_TOKEN_TYPE_OP_DEC, "VALA_TOKEN_TYPE_OP_DEC", "op-dec"}, {VALA_TOKEN_TYPE_OP_EQ, "VALA_TOKEN_TYPE_OP_EQ", "op-eq"}, {VALA_TOKEN_TYPE_OP_GE, "VALA_TOKEN_TYPE_OP_GE", "op-ge"}, {VALA_TOKEN_TYPE_OP_GT, "VALA_TOKEN_TYPE_OP_GT", "op-gt"}, {VALA_TOKEN_TYPE_OP_INC, "VALA_TOKEN_TYPE_OP_INC", "op-inc"}, {VALA_TOKEN_TYPE_OP_LE, "VALA_TOKEN_TYPE_OP_LE", "op-le"}, {VALA_TOKEN_TYPE_OP_LT, "VALA_TOKEN_TYPE_OP_LT", "op-lt"}, {VALA_TOKEN_TYPE_OP_NE, "VALA_TOKEN_TYPE_OP_NE", "op-ne"}, {VALA_TOKEN_TYPE_OP_NEG, "VALA_TOKEN_TYPE_OP_NEG", "op-neg"}, {VALA_TOKEN_TYPE_OP_OR, "VALA_TOKEN_TYPE_OP_OR", "op-or"}, {VALA_TOKEN_TYPE_OP_PTR, "VALA_TOKEN_TYPE_OP_PTR", "op-ptr"}, {VALA_TOKEN_TYPE_OP_SHIFT_LEFT, "VALA_TOKEN_TYPE_OP_SHIFT_LEFT", "op-shift-left"}, {VALA_TOKEN_TYPE_OPEN_BRACE, "VALA_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {VALA_TOKEN_TYPE_OPEN_BRACKET, "VALA_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {VALA_TOKEN_TYPE_OPEN_PARENS, "VALA_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {VALA_TOKEN_TYPE_OVERRIDE, "VALA_TOKEN_TYPE_OVERRIDE", "override"}, {VALA_TOKEN_TYPE_PERCENT, "VALA_TOKEN_TYPE_PERCENT", "percent"}, {VALA_TOKEN_TYPE_PLUS, "VALA_TOKEN_TYPE_PLUS", "plus"}, {VALA_TOKEN_TYPE_PRIVATE, "VALA_TOKEN_TYPE_PRIVATE", "private"}, {VALA_TOKEN_TYPE_PROTECTED, "VALA_TOKEN_TYPE_PROTECTED", "protected"}, {VALA_TOKEN_TYPE_PUBLIC, "VALA_TOKEN_TYPE_PUBLIC", "public"}, {VALA_TOKEN_TYPE_REAL_LITERAL, "VALA_TOKEN_TYPE_REAL_LITERAL", "real-literal"}, {VALA_TOKEN_TYPE_REF, "VALA_TOKEN_TYPE_REF", "ref"}, {VALA_TOKEN_TYPE_REQUIRES, "VALA_TOKEN_TYPE_REQUIRES", "requires"}, {VALA_TOKEN_TYPE_RETURN, "VALA_TOKEN_TYPE_RETURN", "return"}, {VALA_TOKEN_TYPE_SEMICOLON, "VALA_TOKEN_TYPE_SEMICOLON", "semicolon"}, {VALA_TOKEN_TYPE_SET, "VALA_TOKEN_TYPE_SET", "set"}, {VALA_TOKEN_TYPE_SIGNAL, "VALA_TOKEN_TYPE_SIGNAL", "signal"}, {VALA_TOKEN_TYPE_SIZEOF, "VALA_TOKEN_TYPE_SIZEOF", "sizeof"}, {VALA_TOKEN_TYPE_STAR, "VALA_TOKEN_TYPE_STAR", "star"}, {VALA_TOKEN_TYPE_STATIC, "VALA_TOKEN_TYPE_STATIC", "static"}, {VALA_TOKEN_TYPE_STRING_LITERAL, "VALA_TOKEN_TYPE_STRING_LITERAL", "string-literal"}, {VALA_TOKEN_TYPE_STRUCT, "VALA_TOKEN_TYPE_STRUCT", "struct"}, {VALA_TOKEN_TYPE_SWITCH, "VALA_TOKEN_TYPE_SWITCH", "switch"}, {VALA_TOKEN_TYPE_THIS, "VALA_TOKEN_TYPE_THIS", "this"}, {VALA_TOKEN_TYPE_THROW, "VALA_TOKEN_TYPE_THROW", "throw"}, {VALA_TOKEN_TYPE_THROWS, "VALA_TOKEN_TYPE_THROWS", "throws"}, {VALA_TOKEN_TYPE_TILDE, "VALA_TOKEN_TYPE_TILDE", "tilde"}, {VALA_TOKEN_TYPE_TRUE, "VALA_TOKEN_TYPE_TRUE", "true"}, {VALA_TOKEN_TYPE_TRY, "VALA_TOKEN_TYPE_TRY", "try"}, {VALA_TOKEN_TYPE_TYPEOF, "VALA_TOKEN_TYPE_TYPEOF", "typeof"}, {VALA_TOKEN_TYPE_USING, "VALA_TOKEN_TYPE_USING", "using"}, {VALA_TOKEN_TYPE_VAR, "VALA_TOKEN_TYPE_VAR", "var"}, {VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL, "VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL", "verbatim-string-literal"}, {VALA_TOKEN_TYPE_VIRTUAL, "VALA_TOKEN_TYPE_VIRTUAL", "virtual"}, {VALA_TOKEN_TYPE_VOID, "VALA_TOKEN_TYPE_VOID", "void"}, {VALA_TOKEN_TYPE_VOLATILE, "VALA_TOKEN_TYPE_VOLATILE", "volatile"}, {VALA_TOKEN_TYPE_WEAK, "VALA_TOKEN_TYPE_WEAK", "weak"}, {VALA_TOKEN_TYPE_WHILE, "VALA_TOKEN_TYPE_WHILE", "while"}, {0, NULL, NULL}};
		vala_token_type_type_id = g_enum_register_static ("ValaTokenType", values);
	}
	return vala_token_type_type_id;
}




