/* valabasicblock.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valabasicblock.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>




struct _ValaBasicBlockPrivate {
	GeeList* nodes;
	GeeList* predecessors;
	GeeList* successors;
};

#define VALA_BASIC_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockPrivate))
enum  {
	VALA_BASIC_BLOCK_DUMMY_PROPERTY
};
static gpointer vala_basic_block_parent_class = NULL;
static void vala_basic_block_dispose (GObject * obj);



ValaBasicBlock* vala_basic_block_new (void) {
	ValaBasicBlock * self;
	self = g_object_newv (VALA_TYPE_BASIC_BLOCK, 0, NULL);
	return self;
}


ValaBasicBlock* vala_basic_block_new_entry (void) {
	ValaBasicBlock * self;
	self = g_object_newv (VALA_TYPE_BASIC_BLOCK, 0, NULL);
	return self;
}


ValaBasicBlock* vala_basic_block_new_exit (void) {
	ValaBasicBlock * self;
	self = g_object_newv (VALA_TYPE_BASIC_BLOCK, 0, NULL);
	return self;
}


void vala_basic_block_add_node (ValaBasicBlock* self, ValaCodeNode* node) {
	g_return_if_fail (VALA_IS_BASIC_BLOCK (self));
	g_return_if_fail (VALA_IS_CODE_NODE (node));
	gee_collection_add (GEE_COLLECTION (self->priv->nodes), node);
}


void vala_basic_block_connect (ValaBasicBlock* self, ValaBasicBlock* target) {
	g_return_if_fail (VALA_IS_BASIC_BLOCK (self));
	g_return_if_fail (VALA_IS_BASIC_BLOCK (target));
	if (!gee_collection_contains (GEE_COLLECTION (self->priv->successors), target)) {
		gee_collection_add (GEE_COLLECTION (self->priv->successors), target);
	}
	if (!gee_collection_contains (GEE_COLLECTION (target->priv->predecessors), self)) {
		gee_collection_add (GEE_COLLECTION (target->priv->predecessors), self);
	}
}


GeeList* vala_basic_block_get_predecessors (ValaBasicBlock* self) {
	g_return_val_if_fail (VALA_IS_BASIC_BLOCK (self), NULL);
	return GEE_LIST (gee_read_only_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, self->priv->predecessors));
}


GeeList* vala_basic_block_get_successors (ValaBasicBlock* self) {
	g_return_val_if_fail (VALA_IS_BASIC_BLOCK (self), NULL);
	return GEE_LIST (gee_read_only_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, self->priv->successors));
}


static void vala_basic_block_class_init (ValaBasicBlockClass * klass) {
	vala_basic_block_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaBasicBlockPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_basic_block_dispose;
}


static void vala_basic_block_instance_init (ValaBasicBlock * self) {
	self->priv = VALA_BASIC_BLOCK_GET_PRIVATE (self);
	self->priv->nodes = GEE_LIST (gee_array_list_new (VALA_TYPE_CODE_NODE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
	self->priv->predecessors = GEE_LIST (gee_array_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, g_direct_equal));
	self->priv->successors = GEE_LIST (gee_array_list_new (VALA_TYPE_BASIC_BLOCK, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
}


static void vala_basic_block_dispose (GObject * obj) {
	ValaBasicBlock * self;
	self = VALA_BASIC_BLOCK (obj);
	(self->priv->nodes == NULL ? NULL : (self->priv->nodes = (g_object_unref (self->priv->nodes), NULL)));
	(self->priv->predecessors == NULL ? NULL : (self->priv->predecessors = (g_object_unref (self->priv->predecessors), NULL)));
	(self->priv->successors == NULL ? NULL : (self->priv->successors = (g_object_unref (self->priv->successors), NULL)));
	G_OBJECT_CLASS (vala_basic_block_parent_class)->dispose (obj);
}


GType vala_basic_block_get_type (void) {
	static GType vala_basic_block_type_id = 0;
	if (G_UNLIKELY (vala_basic_block_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBasicBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_basic_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBasicBlock), 0, (GInstanceInitFunc) vala_basic_block_instance_init };
		vala_basic_block_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaBasicBlock", &g_define_type_info, 0);
	}
	return vala_basic_block_type_id;
}




