/* valabaseaccess.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valabaseaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




enum  {
	VALA_BASE_ACCESS_DUMMY_PROPERTY
};
static void vala_base_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_base_access_real_to_string (ValaCodeNode* base);
static gboolean vala_base_access_real_is_pure (ValaExpression* base);
static gpointer vala_base_access_parent_class = NULL;



/**
 * Creates a new base access expression.
 *
 * @param source reference to source code
 * @return       newly created base access expression
 */
ValaBaseAccess* vala_base_access_new (ValaSourceReference* source) {
	ValaBaseAccess * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_BASE_ACCESS, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_base_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaBaseAccess * self;
	self = VALA_BASE_ACCESS (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_base_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, VALA_EXPRESSION (self));
}


static char* vala_base_access_real_to_string (ValaCodeNode* base) {
	ValaBaseAccess * self;
	self = VALA_BASE_ACCESS (base);
	return g_strdup ("base");
}


static gboolean vala_base_access_real_is_pure (ValaExpression* base) {
	ValaBaseAccess * self;
	self = VALA_BASE_ACCESS (base);
	return TRUE;
}


static void vala_base_access_class_init (ValaBaseAccessClass * klass) {
	vala_base_access_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->accept = vala_base_access_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_base_access_real_to_string;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_base_access_real_is_pure;
}


static void vala_base_access_instance_init (ValaBaseAccess * self) {
}


GType vala_base_access_get_type (void) {
	static GType vala_base_access_type_id = 0;
	if (G_UNLIKELY (vala_base_access_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBaseAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_base_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBaseAccess), 0, (GInstanceInitFunc) vala_base_access_instance_init };
		vala_base_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBaseAccess", &g_define_type_info, 0);
	}
	return vala_base_access_type_id;
}




