/* valaccodememberaccess.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEMEMBERACCESS_H__
#define __CCODE_VALACCODEMEMBERACCESS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_MEMBER_ACCESS (vala_ccode_member_access_get_type ())
#define VALA_CCODE_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS, ValaCCodeMemberAccess))
#define VALA_CCODE_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS, ValaCCodeMemberAccessClass))
#define VALA_IS_CCODE_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS))
#define VALA_IS_CCODE_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS))
#define VALA_CCODE_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS, ValaCCodeMemberAccessClass))

typedef struct _ValaCCodeMemberAccess ValaCCodeMemberAccess;
typedef struct _ValaCCodeMemberAccessClass ValaCCodeMemberAccessClass;
typedef struct _ValaCCodeMemberAccessPrivate ValaCCodeMemberAccessPrivate;

/**
 * Represents an access to a struct member in the C code.
 */
struct _ValaCCodeMemberAccess {
	ValaCCodeExpression parent_instance;
	ValaCCodeMemberAccessPrivate * priv;
};

struct _ValaCCodeMemberAccessClass {
	ValaCCodeExpressionClass parent_class;
};


ValaCCodeMemberAccess* vala_ccode_member_access_new (ValaCCodeExpression* container, const char* member, gboolean pointer);
ValaCCodeMemberAccess* vala_ccode_member_access_new_pointer (ValaCCodeExpression* container, const char* member);
ValaCCodeExpression* vala_ccode_member_access_get_inner (ValaCCodeMemberAccess* self);
void vala_ccode_member_access_set_inner (ValaCCodeMemberAccess* self, ValaCCodeExpression* value);
const char* vala_ccode_member_access_get_member_name (ValaCCodeMemberAccess* self);
void vala_ccode_member_access_set_member_name (ValaCCodeMemberAccess* self, const char* value);
gboolean vala_ccode_member_access_get_is_pointer (ValaCCodeMemberAccess* self);
void vala_ccode_member_access_set_is_pointer (ValaCCodeMemberAccess* self, gboolean value);
GType vala_ccode_member_access_get_type (void);


G_END_DECLS

#endif
