// The UMLet source code is distributed under the terms of the GPL; see license.txt
package com.umlet.element.custom;

import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;

import com.umlet.constants.Constants;
import com.umlet.element.base.Entity;

@SuppressWarnings("serial")
public class SeqObjectActive extends Entity {
	@Override
	public void paintEntity(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		Composite[] composites = colorize(g2); // enable colors
		g2.setColor(activeColor);
		Constants.getFRC(g2);

		g2.setComposite(composites[1]);
		g2.setColor(fillColor);
		g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
		g2.setComposite(composites[0]);
		if (_selected) g2.setColor(activeColor);
		else g2.setColor(deselectedColor);

		g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);

	}

	@Override
	public int getPossibleResizeDirections() { // allow height changes only
		return Constants.RESIZE_TOP | Constants.RESIZE_BOTTOM;
	}
}
