/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <unistd.h>
#include <qsplitter.h>
#include <qtoolbar.h>
#include <qinputdialog.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qspinbox.h>
#include <qsettings.h>
#include <qaction.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmenu.h>
#include <qmenubar.h>
#include <qtextedit.h>
#include <QTableWidget>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <QTextStream>
#include <mgl/mgl_parse.h>
//-----------------------------------------------------------------------------
#include "scriptwindow.h"
#include "qmglcanvas.h"
#include "helpwindow.h"
#include "argsdialog.h"
#include "tablewindow.h"
#include "infodialog.h"
#include "finddialog.h"
#ifndef MGL_DOC_DIR
#ifdef WIN32
#define MGL_DOC_DIR ""
#else
#define MGL_DOC_DIR "/usr/local/share/doc/udav/"
#endif
#endif
//-----------------------------------------------------------------------------
#include "xpm/option.xpm"
#include "xpm/style.xpm"
#include "xpm/table.xpm"
#include "xpm/preview.xpm"
//-----------------------------------------------------------------------------
QStringList recentFiles;
int MaxRecentFiles=5;
bool mglAutoExecute = true;
bool editPosBottom = false;
bool mglAutoSave = false;
bool showHint=true;
extern HintDialog *hintDialog;
extern HelpWindow *hlp;
extern mglParse parser;
extern ArgsDialog *args_dlg;
extern QColor mglColorScheme[9];
extern QString defFontFamily;
extern int defFontSize;
QString pathHelp;
extern QString pathFont;
bool loadInNewWnd = false;
//-----------------------------------------------------------------------------
void ScriptWindow::about()
{
	QString s = tr("UDAV v. 0.")+QString::number(UDAV_VERSION)+tr("\n(c) Alexey Balakin, 2008\nhttp://udav.sf.net/");
	QMessageBox::about(this, tr("UDAV - about"), s);
}
//-----------------------------------------------------------------------------
void ScriptWindow::aboutQt()
{
	QMessageBox::aboutQt(this, tr("About Qt"));
}
//-----------------------------------------------------------------------------
void ScriptWindow::makeMenu()
{
	QAction *a;
	QMenu *o, *oo;
	QToolBar *bb;

	popup = new QMenu(this);
	// file menu
	{
	bb = new QToolBar(tr("File/Edit Operations"),this);
	addToolBar(Qt::TopToolBarArea, bb);
	o = menuBar()->addMenu(tr("&File"));
	a = new QAction(QPixmap(":/xpm/document-new.png"), tr("&New script"), this);
	connect(a, SIGNAL(activated()), this, SLOT(newDoc()));
	a->setToolTip(tr("Create new empty script window (Ctrl+N)."));
	a->setShortcut(Qt::CTRL+Qt::Key_N);	o->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-open.png"), tr("&Open file"), this);
	connect(a, SIGNAL(activated()), this, SLOT(choose()));
	a->setToolTip(tr("Open and execute/show script or data from file (Ctrl+O).\nYou may switch off automatic exection in UDAV properties."));
	a->setShortcut(Qt::CTRL+Qt::Key_O);	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-save.png"), tr("&Save script"), this);
	connect(a, SIGNAL(activated()), this, SLOT(save()));
	a->setToolTip(tr("Save script to a file (Ctrl+S)"));
	a->setShortcut(Qt::CTRL+Qt::Key_S);	o->addAction(a);	bb->addAction(a);
	a = new QAction(tr("Save &As ..."), this);
	connect(a, SIGNAL(activated()), this, SLOT(saveAs()));
	o->addAction(a);

	oo = new QMenu(tr("&Export as ..."),this);
	oo->addAction(tr("PNG"), mgl, SLOT(exportPNG()),Qt::ALT+Qt::Key_P);
	oo->addAction(tr("solid PNG"), mgl, SLOT(exportPNGs()),Qt::ALT+Qt::Key_F);
	oo->addAction(tr("JPEG"), mgl, SLOT(exportJPG()),Qt::ALT+Qt::Key_J);
	oo->addAction(tr("GIF"), mgl, SLOT(exportGIF()),Qt::ALT+Qt::Key_G);
	oo->addAction(tr("bitmap EPS"), mgl, SLOT(exportBPS()));
	oo->addAction(tr("vector EPS"), mgl, SLOT(exportEPS()),Qt::ALT+Qt::Key_E);
	oo->addAction(tr("SVG"), mgl, SLOT(exportSVG()),Qt::ALT+Qt::Key_S);
	oo->addAction(tr("C++"), mgl, SLOT(exportCPP()));
	oo->addAction(tr("IDTF"), mgl, SLOT(exportIDTF()));
	o->addMenu(oo);
	popup->addMenu(oo);

	o->addSeparator();
	o->addAction(tr("&Print script"), this, SLOT(printText()));
	a = new QAction(QPixmap(":/xpm/document-print.png"), tr("Print &graphics"), this);
	connect(a, SIGNAL(activated()), this, SLOT(printPlot()));
	a->setToolTip(tr("Open printer dialog and print graphics\t(Ctrl+P)"));
	a->setShortcut(Qt::CTRL+Qt::Key_P);	o->addAction(a);
	o->addSeparator();
	fileMenu = o->addMenu(tr("Recent files"));
	o->addSeparator();
	o->addAction(tr("&Close"), this, SLOT(close()), Qt::CTRL+Qt::Key_W);
	o->addAction(tr("&Quit"), qApp, SLOT(closeAllWindows()), Qt::CTRL+Qt::Key_Q);
	bb->addSeparator();
	}
	// edit menu
	{
	o = menuBar()->addMenu(tr("&Edit"));
	a = new QAction(QPixmap(":/xpm/edit-undo.png"), tr("&Undo"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(undo()));
	a->setToolTip(tr("Undo editor change (Ctrl+Z)."));
	a->setShortcut(Qt::CTRL+Qt::Key_Z);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-redo.png"), tr("&Redo"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(redo()));
	a->setToolTip(tr("Redo editor change (Ctrl+Shift+Z)."));
	a->setShortcut(Qt::CTRL+Qt::SHIFT+Qt::Key_Z);	o->addAction(a);		bb->addAction(a);
	bb->addSeparator();	o->addSeparator();
	o->addAction(tr("Clear all"), edit, SLOT(clear()));
	a = new QAction(QPixmap(":/xpm/edit-cut.png"), tr("Cu&t"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(cut()));
	a->setToolTip(tr("Cut selected text to clipboard (Ctrl+X)."));
	a->setShortcut(Qt::CTRL+Qt::Key_X);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-copy.png"), tr("&Copy"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(copy()));
	a->setToolTip(tr("Copy selected text to clipboard (Ctrl+C)."));
	a->setShortcut(Qt::CTRL+Qt::Key_C);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-paste.png"), tr("&Paste"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(paste()));
	a->setToolTip(tr("Paste text from clipboard (Ctrl+V)."));
	a->setShortcut(Qt::CTRL+Qt::Key_V);	o->addAction(a);		bb->addAction(a);
	o->addAction(QPixmap(":/xpm/edit-select-all.png"), tr("Select &all"), edit, SLOT(selectAll()), Qt::CTRL+Qt::Key_A);
	bb->addSeparator();	o->addSeparator();
	a = new QAction(QPixmap(":/xpm/edit-find.png"), tr("&Find/Replace"), this);
	connect(a, SIGNAL(activated()), this, SLOT(find()));
	a->setToolTip(tr("Show dialog for text finding (Ctrl+F)."));
	a->setShortcut(Qt::CTRL+Qt::Key_F);	o->addAction(a);		bb->addAction(a);
	a = new QAction(tr("Find next"), this);
	connect(a, SIGNAL(activated()), this, SLOT(findText()));
	a->setShortcut(Qt::Key_F3);	o->addAction(a);
	bb->addSeparator();	o->addSeparator();
	a = new QAction(QPixmap(option_xpm), tr("Add &options"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addOptions()));
	a->setToolTip(tr("Show dialog for options and put it into the script.\nOptions are used for additional setup the plot."));
	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(style_xpm), tr("Add &style"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addStyle()));
	a->setToolTip(tr("Show dialog for styles and put it into the script.\nStyles define the plot view (color scheme, marks, dashing and so on)."));
	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-properties.png"), tr("Setup &graphics"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addSetup()));
	a->setToolTip(tr("Show dialog for plot setup and put code into the script.\nThis dialog setup axis, labels, lighting and other general things."));
	o->addAction(a);		bb->addAction(a);
	o->addSeparator();
	a = new QAction(QPixmap(":/xpm/preferences-system.png"), tr("Properties"), this);
	connect(a, SIGNAL(activated()), this, SLOT(properties()));
	a->setToolTip(tr("Show dialog for UDAV properties."));
	o->addAction(a);
	ainfo = a = new QAction(tr("Show info"), this);
	a->setShortcut(Qt::Key_F2);	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), info, SLOT(setVisible(bool)));
	o->addAction(a);	a->setChecked(true);
	}
	// graphics menu
	{
	bb = new QToolBar(tr("Graphics"),this);
	addToolBar(Qt::TopToolBarArea, bb);
	o = menuBar()->addMenu(tr("&Graphics"));
	a = new QAction(QPixmap(":/xpm/alpha.png"), tr("&Alpha"), this);
	a->setShortcut(Qt::ALT+Qt::Key_T);	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), mgl, SLOT(setAlpha(bool)));
	connect(mgl, SIGNAL(alphaChanged(bool)), a, SLOT(setOn(bool)));
	a->setToolTip(tr("Switch on/off transparency for the graphics (Alt+T)."));
	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/weather-clear.png"), tr("&Light"), this);
	a->setShortcut(Qt::ALT+Qt::Key_L);	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), mgl, SLOT(setLight(bool)));
	connect(mgl, SIGNAL(lightChanged(bool)), a, SLOT(setOn(bool)));
	a->setToolTip(tr("Switch on/off lightning for the graphics (Alt+L)."));
	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/object-rotate-right.png"), tr("&Rotate by mouse"), this);
	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), mgl, SLOT(setRotate(bool)));
	connect(mgl, SIGNAL(rotateChanged(bool)), a, SLOT(setOn(bool)));
	a->setToolTip(tr("Switch on/off mouse handling of the graphics\n(rotation, shifting, zooming and perspective)."));
	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/zoom-fit-best.png"), tr("&Zoom by mouse"), this);
	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), mgl, SLOT(setZoom(bool)));
	connect(mgl, SIGNAL(zoomChanged(bool)), a, SLOT(setOn(bool)));
	a->setToolTip(tr("Switch on/off mouse zoom of selected region."));
	bb->addAction(a);
	o->addSeparator();
	a = new QAction(QPixmap(":/xpm/zoom-original.png"), tr("Res&tore"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(restore()));
	a->setToolTip(tr("Restore default graphics rotation, zoom and perspective (Alt+Space)."));
	a->setShortcut(Qt::ALT+Qt::Key_Space);
	o->addAction(a);	bb->addAction(a);	popup->addAction(a);
	bb->addSeparator();
	a = new QAction(QPixmap(":/xpm/view-refresh.png"), tr("Re&draw"), this);
	connect(a, SIGNAL(activated()), this, SLOT(pressF5()));
	a->setToolTip(tr("Execute script and redraw graphics (F5)."));
	a->setShortcut(Qt::Key_F5);
	o->addAction(a);	bb->addAction(a);	popup->addAction(a);
	a = new QAction(tr("&Adjust size"), this);
	connect(a, SIGNAL(activated()), this, SLOT(adjust()));
	a->setToolTip(tr("Change canvas size to fill whole region (F6)."));
	a->setShortcut(Qt::Key_F6);		o->addAction(a);
	a = new QAction(tr("Re&load"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(reload()));
	a->setToolTip(tr("Restore status for 'once' command and reload data (F9)."));
	a->setShortcut(Qt::Key_F9);	o->addAction(a);	popup->addAction(a);
	a = new QAction(QPixmap(":/xpm/process-stop.png"), tr("&Stop"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(stop()));
	a->setToolTip(tr("Stop script execution (F7)."));
	a->setShortcut(Qt::Key_F7);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-copy.png"), tr("&Copy plot"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(copy()));
	a->setToolTip(tr("Copy graphics to clipboard (Ctrl+Shift+C)."));
	a->setShortcut(Qt::CTRL+Qt::SHIFT+Qt::Key_C);
	o->addAction(a);		bb->addAction(a);	popup->addAction(a);
	bb->addSeparator();
	tet = new QSpinBox(this);	tet->setWrapping(true);
	bb->addWidget(tet);	tet->setRange(-180, 180);	tet->setSingleStep(10);
	connect(tet, SIGNAL(valueChanged(int)), mgl, SLOT(setTet(int)));
	connect(mgl, SIGNAL(tetChanged(int)), tet, SLOT(setValue(int)));
	tet->setToolTip(tr("Set value of \\theta angle."));
	bb->addSeparator();
	phi = new QSpinBox(this);	phi->setWrapping(true);
	bb->addWidget(phi);	phi->setRange(-180, 180);	phi->setSingleStep(10);
	connect(phi, SIGNAL(valueChanged(int)), mgl, SLOT(setPhi(int)));
	connect(mgl, SIGNAL(phiChanged(int)), phi, SLOT(setValue(int)));
	phi->setToolTip(tr("Set value of \\phi angle."));
	o->addAction(tr("Set ar&guments"), args_dlg, SLOT(exec()));
//	bb->addSeparator();
	}
	// zooming menu
	{
	oo = o->addMenu(tr("Zoom/move"));
	bb = new QToolBar(tr("Zoom graphics"),this);
	addToolBar(Qt::RightToolBarArea, bb);
	a = new QAction(QPixmap(":/xpm/go-previous.png"), tr("Move &left"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(shiftLeft()));
	a->setToolTip(tr("Move graphics left by 1/3 of its width."));
	bb->addAction(a);		oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/go-up.png"), tr("Move &up"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(shiftUp()));
	a->setToolTip(tr("Move graphics up by 1/3 of its height."));
	bb->addAction(a);		oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/zoom-in.png"), tr("Zoom &in"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(zoomIn()));
	a->setToolTip(tr("Zoom in graphics."));
	bb->addAction(a);		oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/zoom-out.png"), tr("Zoom &out"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(zoomOut()));
	a->setToolTip(tr("Zoom out graphics."));
	bb->addAction(a);		oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/go-down.png"), tr("Move &down"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(shiftDown()));
	a->setToolTip(tr("Move graphics up down 1/3 of its height."));
	bb->addAction(a);		oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/go-next.png"), tr("Move &right"), this);
	connect(a, SIGNAL(activated()), mgl, SLOT(shiftRight()));
	a->setToolTip(tr("Move graphics right by 1/3 of its width."));
	bb->addAction(a);		oo->addAction(a);
	}
	// animation menu
	{
	o = menuBar()->addMenu(tr("&Animation"));
	bb = new QToolBar(tr("Animation"),this);
	addToolBar(Qt::RightToolBarArea, bb);
	a = new QAction(QPixmap(":/xpm/media-seek-forward.png"), tr("&Next slide"), this);
	connect(a, SIGNAL(activated()), this, SLOT(nextSlide()));
	a->setToolTip(tr("Show next slide (Alt+Right)."));
	a->setShortcut(Qt::ALT+Qt::Key_Right);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/media-seek-backward.png"), tr("&Prev slide"), this);
	connect(a, SIGNAL(activated()), this, SLOT(prevSlide()));
	a->setToolTip(tr("Show previous slide (Alt+Left)."));
	a->setShortcut(Qt::ALT+Qt::Key_Left);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/film-b.png"), tr("&Slideshow"), this);
	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), this, SLOT(animStart(bool)));
	a->setToolTip(tr("Run slideshow (Ctrl+F5). If no parameter specified\nthen the dialog with slideshow options will appear."));
	a->setShortcut(Qt::CTRL+Qt::Key_F5);	o->addAction(a);		bb->addAction(a);
	o->addAction(tr("Se&tup show"), this, SLOT(animSetup()), Qt::CTRL+Qt::Key_W);
	}

	menuBar()->addSeparator();
	bb = new QToolBar(tr("UDAV Help"), this);
	addToolBar(Qt::RightToolBarArea, bb);
	o = menuBar()->addMenu(tr("&Help"));
	a = new QAction(QPixmap(":/xpm/help-contents.png"), tr("MGL &help"), this);
	connect(a, SIGNAL(activated()), this, SLOT(showHelp()));
	a->setToolTip(tr("Show help on MGL commands (F1)."));
	a->setShortcut(Qt::Key_F1);	bb->addAction(a);		o->addAction(a);
	a = new QAction(QPixmap(":/xpm/help-faq.png"), tr("&Examples"), this);
	connect(a, SIGNAL(activated()), hlp, SLOT(showExamples()));
	a->setToolTip(tr("Show examples of MGL usage (Shift+F1)."));
	a->setShortcut(Qt::SHIFT+Qt::Key_F1);	bb->addAction(a);	o->addAction(a);
	a = new QAction(QPixmap(":/xpm/help-faq.png"), tr("H&ints"), this);
	connect(a, SIGNAL(activated()), hintDialog, SLOT(exec()));
	a->setToolTip(tr("Show hints of MGL usage."));	o->addAction(a);
	o->addAction(tr("&About"), this, SLOT(about()));
	o->addAction(tr("About &Qt"), this, SLOT(aboutQt()));
}
//-----------------------------------------------------------------------------
void ScriptWindow::writeSettings()
{
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	settings.setValue("/animDelay", animDelay);
	settings.setValue("/geometry/size", size());
	settings.setValue("/geometry/split_e/w1", split->sizes().at(0));
	settings.setValue("/geometry/split_e/w2", split->sizes().at(1));
	settings.setValue("/geometry/split_g/w1", splitG->sizes().at(0));
	settings.setValue("/geometry/split_g/w2", splitG->sizes().at(1));

	settings.setValue("/recentFiles", recentFiles);
	settings.setValue("/recentFilesMax", MaxRecentFiles);
	settings.setValue("/helpPath", pathHelp);
	settings.setValue("/userFont", pathFont);
	settings.setValue("/colComment",mglColorScheme[0].name());
	settings.setValue("/colString", mglColorScheme[1].name());
	settings.setValue("/colKeyword",mglColorScheme[2].name());
	settings.setValue("/colOption", mglColorScheme[3].name());
	settings.setValue("/colSuffix", mglColorScheme[4].name());
	settings.setValue("/colNumber", mglColorScheme[5].name());
	settings.setValue("/colACKeyword", mglColorScheme[6].name());
	settings.setValue("/colFCKeyword", mglColorScheme[7].name());
	settings.setValue("/colReserved", mglColorScheme[8].name());
	settings.setValue("/autoExec",  mglAutoExecute);
	settings.setValue("/autoSave",  mglAutoSave);
	settings.setValue("/editAtTop", editPosBottom);
	settings.setValue("/fontFamily", defFontFamily);
	settings.setValue("/fontSize", defFontSize);
	settings.setValue("/loadInNewWnd", loadInNewWnd);

//	settings.writeEntry("/geometry/posMess", width());
//	settings.writeEntry("/geometry/posEdit", split->);
	settings.endGroup();
}
//-----------------------------------------------------------------------------
void ScriptWindow::readSettings()
{
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
#ifdef WIN32
	pathHelp = settings.value("/helpPath", MGL_DOC_DIR).toString();
#else
	pathHelp = settings.value("/helpPath", MGL_DOC_DIR[0] ? MGL_DOC_DIR : "/usr/local/share/doc/udav/").toString();
#endif
	MaxRecentFiles = settings.value("/recentFilesMax", 5).toInt();
	animDelay = settings.value("/animDelay", 500).toInt();
	resize(settings.value("/geometry/size", QSize(880,720)).toSize());
	QList<int> le, lg;
	le.append(settings.value("/geometry/split_e/w1", 230).toInt());
	le.append(settings.value("/geometry/split_e/w2", 604).toInt());
	split->setSizes(le);
	lg.append(settings.value("/geometry/split_g/w1", 406).toInt());
	lg.append(settings.value("/geometry/split_g/w2", 212).toInt());
	splitG->setSizes(lg);

	pathFont = settings.value("/userFont", "").toString();
	mglColorScheme[0] = QColor(settings.value("/colComment","#007F00").toString());
	mglColorScheme[1] = QColor(settings.value("/colString", "#FF0000").toString());
	mglColorScheme[2] = QColor(settings.value("/colKeyword","#00007F").toString());
	mglColorScheme[3] = QColor(settings.value("/colOption", "#7F0000").toString());
	mglColorScheme[4] = QColor(settings.value("/colSuffix", "#7F0000").toString());
	mglColorScheme[5] = QColor(settings.value("/colNumber", "#0000FF").toString());
	mglColorScheme[6] = QColor(settings.value("/colACKeyword","#7F007F").toString());
	mglColorScheme[7] = QColor(settings.value("/colFCKeyword","#007F7F").toString());
	mglColorScheme[8] = QColor(settings.value("/colReserved", "#0000FF").toString());
	showHint = settings.value("/showHint",  true).toBool();
	mglAutoSave = settings.value("/autoSave",  false).toBool();
	mglAutoExecute = settings.value("/autoExec",  true).toBool();
	editPosBottom = settings.value("/editAtTop", false).toBool();
	loadInNewWnd = settings.value("/loadInNewWnd", false).toBool();
	defFontFamily = settings.value("/fontFamily", "Georgia").toString();
	defFontSize = settings.value("/fontSize", 10).toInt();
	setEditorFont();	setMGLFont(pathFont);	setEditPos(editPosBottom);

	recentFiles = settings.value("/recentFiles").toStringList();
	settings.endGroup();
	updateRecentFileItems();
}
//-----------------------------------------------------------------------------
void ScriptWindow::setCurrentFile(const QString &fileName)
{
	filename = fileName;
	mgl->scriptName = filename;
	edit->document()->setModified(false);
	if(filename.isEmpty())
		setWindowTitle(tr("untitled - UDAV"));
	else
	{
		setWindowTitle(QFileInfo(filename).fileName()+tr(" - UDAV"));
//		recentFiles.removeOne(filename);
		int i = recentFiles.indexOf(filename);
		if(i>=0)	recentFiles.removeAt(i);
		recentFiles.push_front(filename);
		updateRecentFileItems();
		chdir(qPrintable(QFileInfo(filename).path()));
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::openRecentFile()
{
	QAction *a = qobject_cast<QAction *>(sender());
	if(!a)	return;
	if(edit->document()->isModified())
		switch(QMessageBox::information(this, tr("UDAV - save current"), tr("Do you want to save the changes to the document?"), QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel))
		{
			case QMessageBox::Yes:	save();	break;
			case QMessageBox::No:	break;
			default:	return;
		}
	QString fn = recentFiles[a->data().toInt()];
	load(fn);
}
//-----------------------------------------------------------------------------
void ScriptWindow::updateRecentFileItems()
{
	foreach(QWidget *w, QApplication::topLevelWidgets())
	{
		ScriptWindow *wnd = qobject_cast<ScriptWindow *>(w);
		if(wnd)	wnd->updateRecent();
//		if(w->inherits("ScriptWindow"))	((ScriptWindow *)w)->updateRecent();
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::updateRecent()
{
	QAction *a;
	fileMenu->clear();	qApp->processEvents();
	for(int i=0; i<recentFiles.size() && i<MaxRecentFiles; i++)
	{
		QString text = "&" + QString::number(i+1) + " " + QFileInfo(recentFiles[i]).fileName();
		a = fileMenu->addAction(text, this, SLOT(openRecentFile()));
		a->setData(i);
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::newDoc()
{
	ScriptWindow *ed = new ScriptWindow;
	ed->show();	ed->activateWindow();
}
//-----------------------------------------------------------------------------
void ScriptWindow::choose()
{
	if(edit->document()->isModified())
		switch(QMessageBox::information(this, tr("UDAV - save current"), tr("Do you want to save the changes to the document?"), QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel))
		{
			case QMessageBox::Yes:	save();	break;
			case QMessageBox::No:	break;
			default:	return;
		}
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	QString fn = QFileDialog::getOpenFileName(this, 
			tr("UDAV - Open file"), 
			settings.value("/filePath", MGL_DOC_DIR).toString(), 
			tr("MGL scripts (*.mgl)\nHDF5 files (*.hdf *.h5)\nText files (*.txt)\nData files (*.dat)\nAll files (*.*)"));
	settings.endGroup();
	if(!fn.isEmpty())	load(fn);
	else	statusBar()->showMessage(tr("Loading aborted"), 2000);
}
//-----------------------------------------------------------------------------
void ScriptWindow::load(const QString &fileName, bool noNewWnd)
{
	static int num=0;
	// save current path
	QFileInfo fi(fileName);
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	settings.setValue("/filePath", fi.absolutePath());
	settings.endGroup();
	// open new window if it is required
	if(loadInNewWnd && !noNewWnd)
	{
		ScriptWindow *mw = new ScriptWindow;
		mw->load(fileName, true);
		mw->show();	//ed->activateWindow();
		return;
	}
//QMessageBox::warning(this,"",fileName);
	if(fileName.right(4)==".dat")
	{
		char name[16];
		sprintf(name,"mgl_%d",num);	num++;
		mglVar *v = parser.AddVar(name);
		setlocale(LC_ALL, "C");
		v->d.Read(fileName.toAscii());
		setlocale(LC_ALL, "");
		QString s;
		if(v->d.nz>1)
			s.sprintf("#read %s '%s'\nrotate 40 60\ncrange %s\nbox\nsurf3 %s\n", name, fileName.toAscii().constData(), name, name);
		else if(v->d.ny>1)
			s.sprintf("#read %s '%s'\nrotate 40 60\ncrange %s\nzrange %s\nbox\nsurf %s\n", name, fileName.toAscii().constData(), name, name, name);
		else
			s.sprintf("#read %s '%s'\nyrange %s\nbox\nplot %s\n", name, fileName.toAscii().constData(), name, name);
		edit->setText(s);
		setCurrentFile(fileName.left(fileName.length()-3)+"mgl");
	}
	else if(fileName.right(4)==".hdf" || fileName.right(3)==".h5")
		loadHDF5(fileName);
	else
	{
		QFile f(fileName);
		if(!f.open(QIODevice::ReadOnly))
		{
			QMessageBox::warning(this,tr("UDAV - open file"), tr("Couldn't open file"),QMessageBox::Ok,0,0);
			return;
		}

		QTextStream ts(&f);
		ts.setAutoDetectUnicode(true);
//		ts.setCodec(QTextCodec::codecForLocale());
		edit->setText(ts.readAll());
		animParseText();
		setCurrentFile(fileName);
	}
	statusBar()->showMessage(tr("Loaded document ")+fileName, 2000);
	if(mglAutoExecute)	mgl->execute();
}
//-----------------------------------------------------------------------------
void ScriptWindow::save()
{
	if(filename.isEmpty())	{	saveAs();	return;	}
	if(filename.right(4)==".hdf" || filename.right(3)==".h5")
	{	saveHDF5(filename);	return;	}
	QString text = edit->toPlainText();
	QFile f(filename);
	if(!f.open(QIODevice::WriteOnly))
	{
		statusBar()->showMessage(tr("Could not write to %1").arg(filename), 2000);
		return;
	}
	QTextStream t(&f);
	t.setAutoDetectUnicode(true);
	t << text;	f.close();
	setCurrentFile(filename);
	statusBar()->showMessage(tr("File %1 saved").arg(filename), 2000);
}
//-----------------------------------------------------------------------------
void ScriptWindow::saveAs()
{
	QString fn;
//	while(1)
	{
		fn = QFileDialog::getSaveFileName(this, tr("UDAV - save file"), "", tr("MGL scripts (*.mgl)\nHDF5 files (*.hdf *.h5)\nAll files (*.*)"));
		if(fn.isEmpty())
		{	statusBar()->showMessage(tr("Saving aborted"), 2000);	return;	}
		else
		{
			if(fn[fn.length()-4]!='.' && fn[fn.length()-3]!='.')
				fn = fn + ".mgl";
			filename = fn;		save();		return;
		}
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::newTable()
{
	bool ok;
	QString name = QInputDialog::getText(this, tr("UDAV - New variable"), tr("Enter name for new variable"), QLineEdit::Normal, "", &ok);
	if(!ok || name.isEmpty())	return;
	mglVar *v = parser.AddVar(name.toAscii());
	TableWindow *t;
	if(v->o)	t = (TableWindow *)v->o;
	else
	{	t = new TableWindow;	t->setVar(v);	}
	t->show();	t->activateWindow();
	refresh();
}
//-----------------------------------------------------------------------------
void ScriptWindow::editData(int n)
{
	if(tab->rowCount()<1)	return;
	if(n<0)	n = tab->currentRow();
	if(n<0)	n = 0;
	mglVar *v = parser.FindVar(tab->item(n,0)->text().toAscii());
	if(!v)	return;
	TableWindow *t;
	if(v->o)	t = (TableWindow *)v->o;
	else
	{	t = new TableWindow;	t->setVar(v);	}
	t->show();	t->activateWindow();
}
//-----------------------------------------------------------------------------
void ScriptWindow::delData()
{
	if(tab->rowCount()<1)	return;
	int	n = tab->currentRow();
	if(n<0)	n = 0;
	mglVar *v = parser.FindVar(tab->item(n,0)->text().toAscii());
	if(!v)	return;
	if(v->o)	((TableWindow *)v->o)->close();
	parser.DeleteVar(v);
	refresh();
}
//-----------------------------------------------------------------------------
void ScriptWindow::delAllData()
{
	if(QMessageBox::information(this, tr("UDAV - delete all data"), tr("Do you want to delete all data?"), QMessageBox::No, QMessageBox::Yes)!=QMessageBox::Yes)	return;
	while(parser.DataList)	parser.DeleteVar(parser.DataList);
	refresh();
}
//-----------------------------------------------------------------------------
void ScriptWindow::infoData()
{
	if(tab->rowCount()<1)	return;
	int	n = tab->currentRow();
	if(n<0)	n = 0;
	mglVar *v = parser.FindVar(tab->item(n,0)->text().toAscii());
	if(!v)	return;
	infoDlg->setVar(v);
	QString s = QString::fromWCharArray(v->s);
	infoDlg->setWindowTitle(s + tr(" - UDAV preview"));
	infoDlg->refresh();
	infoDlg->show();
}
//-----------------------------------------------------------------------------
void ScriptWindow::refresh()
{
	mglVar *v = parser.DataList;
	int n = 0;
	while(v)	{	v = v->next;	n++;	}
	tab->setRowCount(n);
	v = parser.DataList;	n = 0;
	QString s;
	QTableWidgetItem *it;
	Qt::ItemFlags flags;
	while(v)
	{
		register unsigned i,m=wcslen(v->s);
		QChar *ss = new QChar[m+1];
		for(i=0;i<m;i++)	ss[i] = v->s[i];
		s = QString(ss, m);	delete []ss;
		it = new QTableWidgetItem(s);
		tab->setItem(n,0,it);	it->setFlags(flags);
		s.sprintf("%ld * %ld * %ld", v->d.nx, v->d.ny, v->d.nz);
		it = new QTableWidgetItem(s);
		tab->setItem(n,1,it);	it->setFlags(flags);
		it->setTextAlignment(Qt::AlignHCenter|Qt::AlignVCenter);
		s.sprintf("%12ld", v->d.nx*v->d.ny*v->d.nz*sizeof(float));
		it = new QTableWidgetItem(s);
		tab->setItem(n,2,it);	it->setFlags(flags);
		it->setTextAlignment(Qt::AlignRight|Qt::AlignVCenter);
		v = v->next;	n++;
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::messClicked()
{
	QString m = mess->toPlainText(), q;
	int p = mess->textCursor().blockNumber();
	for(;p>=0;p--)
	{
		q = m.section('\n',p,p);
		if(q.contains("In line "))
		{
			QString s = q.mid(8).section(' ',0,0);
			setCursorPosition(s.toInt(), 0);
		}
	}
	edit->setFocus();
}
//-----------------------------------------------------------------------------
void ScriptWindow::tableClicked(int, int col)
{
	tab->sortItems(col);
}
//-----------------------------------------------------------------------------
QTabWidget *ScriptWindow::setupInfo(QWidget *par)
{
	QWidget *p;
	QHBoxLayout *h;
	QVBoxLayout *v;
	QPushButton *b;

	QTabWidget *t = new QTabWidget(par);
	// messages and warnings
	p = new QWidget(par);
	v = new QVBoxLayout(p);
	mess = new QTextEdit(p);	v->addWidget(mess);	mess->setReadOnly(true);
	connect(mess, SIGNAL(cursorPositionChanged()), this, SLOT(messClicked()));
	t->addTab(p, tr("Messages and warnings"));
	// data arrays
	p = new QWidget(par);
	v = new QVBoxLayout(p);	h = new QHBoxLayout();	v->addLayout(h);
	b = new QPushButton(QPixmap(":/xpm/document-new.png"), tr("New"), p);	h->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(newTable()));
	b = new QPushButton(QPixmap(table_xpm), tr("Edit"), p);	h->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(editData()));
	b = new QPushButton(QPixmap(":/xpm/edit-delete.png"), tr("Delete"), p);	h->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(delData()));
	b = new QPushButton(QPixmap(preview_xpm), tr("Info"), p);	h->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(infoData()));
	b = new QPushButton(QPixmap(":/xpm/view-refresh.png"), tr("Update"), p);	h->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(refresh()));
	h->addStretch(1);
	b = new QPushButton(QPixmap(":/xpm/edit-delete.png"), tr("Delete All"), p);	h->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(delAllData()));
	
	tab = new QTableWidget(p);	v->addWidget(tab);	tab->setColumnCount(3);
	QStringList sl;	sl.append(tr("Name"));	sl.append(tr("Sizes"));	sl.append(tr("Memory"));
	tab->setHorizontalHeaderLabels(sl);
	connect(tab, SIGNAL(cellPressed(int,int)), this, SLOT(tableClicked(int,int)));
	t->addTab(p, tr("Data arrays"));
	// set default page - data
	t->setCurrentIndex(1);
	return t;
}
//-----------------------------------------------------------------------------
void updateDataItems()
{
	foreach (QWidget *w, QApplication::topLevelWidgets())
	{
		if(w->inherits("ScriptWindow"))
			((ScriptWindow *)w)->refresh();
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::setAsterix()
{
	if(edit->document()->isModified())
	{
		if(filename.isEmpty())
			setWindowTitle(tr("untitled* - UDAV"));
		else
			setWindowTitle(QFileInfo(filename).fileName()+tr("* - UDAV"));
	}
	else
	{
		if(filename.isEmpty())
			setWindowTitle(tr("untitled - UDAV"));
		else
			setWindowTitle(QFileInfo(filename).fileName()+tr(" - UDAV"));
	}
}
//-----------------------------------------------------------------------------
