Summary: A simple template system
Name: new
Version: 1.3.7
Release: 1
License: GPL
Group: Development/Tools
Source: http://www.flyn.org/projects/%name/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://www.flyn.org
Requires: zlib
BuildRequires: glib2-devel, zlib-devel

%description
New is a template system, especially useful in conjunction with a 
simple text editor such as vi. The user maintains templates which 
may contain format strings. At run time, new replaces the format 
strings in a template with appropriate values to create a new file.

For example, given the following template:


//   FILE: %%(FILE)
// AUTHOR: %%(FULLNAME)
//   DATE: %%(DATE)

// Copyright (C) 1999 %(FULLNAME) %(EMAIL)
// All rights reserved.
new will create:


//   FILE: foo.cpp
// AUTHOR: W. Michael Petullo
//   DATE: 11 September 1999

// Copyright (C) 1999 W. Michael Petullo new@flyn.org
// All rights reserved.
on my computer.

The program understands plaintext or gziped template files.

Building new also creates a shared library, libnewtemplate, which 
allows the programmer access to new's functionality.

%package devel
Summary: Files needed to develop applications using new's libraries
Group: Development/Libraries
Requires: new = %{version}-%{release}
Requires: glib2-devel, zlib-devel

%description devel
New is a template system, especially useful in conjunction with a
simple text editor such as vi. The user maintains templates which may
contain format strings. At run time, new replaces the format strings in
a template with appropriate values to create a new file.  This package
provides the libraries, include files, and other resources needed for
developing applications using new's API.

%prep


%setup


%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
rm -f ${RPM_BUILD_ROOT}/usr/lib/libnewfmt_ptrn.a
rm -f ${RPM_BUILD_ROOT}/usr/lib/libnewfmt_ptrn.la
rm -f ${RPM_BUILD_ROOT}/usr/lib/libnewtemplate.a
rm -f ${RPM_BUILD_ROOT}/usr/lib/libnewtemplate.la



%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_bindir}/*
%{_libdir}/lib*.so.*
%{_datadir}/new
%{_mandir}/*/*
%doc	AUTHORS COPYING ChangeLog INSTALL README

%files devel
%defattr(-, root, root)
%{_libdir}/pkgconfig/new.pc
%{_includedir}/new
%{_libdir}/lib*.so


%changelog
* Thu Feb 02 2006 W. Michael Petullo <mike[@]flyn.org> - 1.3.7-1
   - Updated to new 1.3.7.

* Wed Feb 01 2006 W. Michael Petullo <mike[@]flyn.org> - 1.3.6-1
   - Updated to new 1.3.6.

* Sat Dec 24 2005 W. Michael Petullo <mike[@]flyn.org> - 1.3.5-3
   - Add %%defattr for %%files devel.

* Tue Dec 13 2005 W. Michael Petullo <mike[@]flyn.org> - 1.3.5-2
   - Broke out -devel package.
   - Simplifies %files block.
   - Don't use %doc %{_mandir}.
   - No empty NEWS or FAQ.

* Sun Dec 11 2005 W. Michael Petullo <mike[@]flyn.org> - 1.3.5-1
   - Updated to new 1.3.5.
