/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/output/cpio.cc
 */

#ifndef COMMON_TAR_OUTPUT_CPIO_H
#define COMMON_TAR_OUTPUT_CPIO_H

#include <file/output.h>
#include <tar/output.h>

class tar_output_cpio: public tar_output
{
	 public:
	 virtual ~tar_output_cpio();
	 tar_output_cpio(file_output *, int);
	 virtual void write_data(const void *, int);
	 virtual void write_data_padding();
	 virtual void write_archive_end();
	 virtual const char *filename() const;

	 private:
	 file_output *fp;
	 long padding;
	 long pos;

	 protected:
	 int calculate_mode(const tar_header &);
	 tar_output_cpio();
	 tar_output_cpio(const tar_output_cpio &);
	 tar_output_cpio &operator = (const tar_output_cpio &);
};

#endif /* COMMON_TAR_OUTPUT_CPIO_H */
