/*
        skyeye_mach_au1100.c - au1100 machine simulation 
        Copyright (C) 2003-2007 Skyeye Develop Group
        for help please send mail to <skyeye-developer@lists.sf.linuxforum.net>

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/*
 * 03/02/2007   Michael.Kang  <blackfin.kang@gmail.com>
 */

#include "skyeye_config.h"
#include "../common/mach.h"
#include "../common/types.h"
#include "../common/inttypes.h"
#include "../common/emul.h"
#include "../common/cpu.h"
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>

/* 2007-01-18 added by Anthony Lee : for new uart device frame */
#include "skyeye_uart.h"


/* Interrupt Controller */

/* UART Controller */

extern MIPS_State *mstate;

typedef struct uart_s {
	uint32_t rxdata;
	uint32_t txdata;
	uint32_t inten;
	uint32_t intcause;
	uint32_t fifoctrl;
	uint32_t linectrl;
	uint32_t mdmctrl;
	uint32_t linestat;
	uint32_t mdmstat;
	uint32_t autoflow;
	uint32_t clkdiv;
	uint32_t enable;
}uart_t;

typedef struct int_ctrl_s {
	uint32_t cfg0rd;
	uint32_t cfg0set;
	uint32_t cfg0clr;
	uint32_t cfg1rd;
	uint32_t cfg1set;
	uint32_t cfg1clr;
	uint32_t cfg2rd;
	uint32_t cfg2set;
	uint32_t cfg2clr;
	uint32_t req0int;
	uint32_t srcrd;
	uint32_t srcset;
	uint32_t srcclr;
	uint32_t req1int;
	uint32_t assignrd;
	uint32_t assignset;
	uint32_t assignclr;
	uint32_t wakerd;
	uint32_t wakeset;
	uint32_t wakeclr;
	uint32_t maskrd;
	uint32_t maskset;
	uint32_t maskclr;
	uint32_t risingrd;
	uint32_t risingclr;
	uint32_t fallingrd;
	uint32_t fallingclr;
	uint32_t testbit;
}int_ctrl_t;

typedef struct au1100_io_s {
	uart_t uart;
	int_ctrl_t intc;
}au1100_io_t;

static au1100_io_t io;

static void
au1100_io_do_cycle ()
{

}

static UInt32
au1100_io_read_byte(UInt32 addr)
{
	UInt32 ret;

	switch (addr) {
		default:
			fprintf("I/O err in %s, addr=0x%x\n", __FUNCTION__, addr);
                        skyeye_exit(-1);

	}
	return ret;
}

static UInt32
au1100_io_read_halfword(UInt32 addr)
{
	UInt32 ret;

	switch (addr) {
		default:
			fprintf("I/O err in %s, addr=0x%x\n", __FUNCTION__, addr);
		        skyeye_exit(-1);

	}
	return ret;
}

static UInt32
au1100_io_read_word(UInt32 addr)
{
	UInt32 ret;

	switch (addr) {
		default:
			fprintf("I/O err in %s, addr=0x%x\n", __FUNCTION__, addr);
                        skyeye_exit(-1);

	}
	return ret;
}

static void
au1100_io_write_byte(UInt32 addr, UInt32 data)
{
	unsigned char c = data & 0xff;

	switch (addr) {
		default:
			fprintf("I/O err in %s, addr=0x%x\n", __FUNCTION__, addr);
                        skyeye_exit(-1);
	}
}

static void
au1100_io_write_halfword(UInt32 addr, UInt32 data)
{
	
	switch (addr) {
		default:
			fprintf("I/O err in %s, addr=0x%x\n", __FUNCTION__, addr);
                        skyeye_exit(-1);
	}
}

static void
au1100_io_write_word(UInt32 addr, UInt32 data)
{
	
	switch (addr) {
		default:
			fprintf("I/O err in %s, addr=0x%x\n", __FUNCTION__, addr);
			skyeye_exit(-1);
	}
}

static void
au1100_disable_int()
{

}

static void
au1100_enable_int()
{

}

static void
au1100_clear_int(UInt32 irq)
{

}

static void
au1100_set_int(UInt32 irq)
{

}

static void
au1100_sti(UInt32 dreg)
{

}

static void
au1100_cli(UInt32 dreg)
{

}

void
au1100_mach_init (void * state, machine_config_t * this_mach)
{
	/*init io  value */

	/*init mach */
	if (!this_mach) {
		exit (-1);
	}

	this_mach->mach_io_read_byte = au1100_io_read_byte;
        this_mach->mach_io_read_halfword = au1100_io_read_halfword;
        this_mach->mach_io_read_word = au1100_io_read_word;
        this_mach->mach_io_write_byte = au1100_io_write_byte;
        this_mach->mach_io_write_halfword = au1100_io_write_halfword;
        this_mach->mach_io_write_word = au1100_io_write_word;
        this_mach->mach_io_do_cycle = au1100_io_do_cycle;
        this_mach->mach_set_intr = au1100_set_int;

}
