/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2008 - INRIA - Jean-Baptiste Silvy 
 * desc : Strategy for computing ticks position and labels  
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#ifndef _AXES_SUBTICKS_COMPUTER_HXX_
#define _AXES_SUBTICKS_COMPUTER_HXX_

#include "DrawableAxes.h"
#include "../subwinDrawing/ComputeSubticksStrategy.hxx"

namespace sciGraphics
{

class AxesSubticksComputer : public ComputeSubticksStrategy
{
public:

  AxesSubticksComputer(DrawableAxes * axes);

  virtual ~AxesSubticksComputer(void);

  /**
   * Get the number of subticks which will be computed by the strategy.
   */
  virtual int getNbSubticks(double ticksPositions[], int nbTicks);

  /**
   * Get the subticks positions.
   */
  virtual void getSubticksPosition(const double ticksPositions[], int nbTicks,
                                   double subTickspositions[]);

protected:

  /*-----------------------------------------------------*/
  DrawableAxes * m_pAxes;
  /*-----------------------------------------------------*/


};

}

#endif /* _AXES_SUBTICKS_COMPUTER_HXX_ */

