#include "SwingScilabMenu.hxx"
/* Generated by GIWS (version 1.0.6) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_gui_bridge_menu {

// Returns the current env

JNIEnv * SwingScilabMenu::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
return curEnv;
}
// Destructor

SwingScilabMenu::~SwingScilabMenu() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors

SwingScilabMenu::SwingScilabMenu(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidsetTextjstringID=NULL; 
voidsetParentjintID=NULL; 
voidsetCallbackjstringID=NULL; 
voiddisplayID=NULL; 
voidshowID=NULL; 
voiddestroyID=NULL; 


}

SwingScilabMenu::SwingScilabMenu(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidsetTextjstringID=NULL; 
voidsetParentjintID=NULL; 
voidsetCallbackjstringID=NULL; 
voiddisplayID=NULL; 
voidshowID=NULL; 
voiddestroyID=NULL; 


}

// Generic methods

void SwingScilabMenu::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "SwingScilabMenu");
}
}

void SwingScilabMenu::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "SwingScilabMenu");
}
}
// Method(s)

void SwingScilabMenu::setText (char * newText){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetTextjstringID==NULL) { /* Use the cache Luke */ voidsetTextjstringID = curEnv->GetMethodID(this->instanceClass, "setText", "(Ljava/lang/String;)V" ) ;
if (voidsetTextjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setText");
}
}
jstring newText_ = curEnv->NewStringUTF( newText );

                         curEnv->CallVoidMethod( this->instance, voidsetTextjstringID ,newText_);if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void SwingScilabMenu::setParent (int parentIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetParentjintID==NULL) { /* Use the cache Luke */ voidsetParentjintID = curEnv->GetMethodID(this->instanceClass, "setParent", "(I)V" ) ;
if (voidsetParentjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setParent");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetParentjintID ,parentIndex);if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void SwingScilabMenu::setCallback (char * callback){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetCallbackjstringID==NULL) { /* Use the cache Luke */ voidsetCallbackjstringID = curEnv->GetMethodID(this->instanceClass, "setCallback", "(Ljava/lang/String;)V" ) ;
if (voidsetCallbackjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setCallback");
}
}
jstring callback_ = curEnv->NewStringUTF( callback );

                         curEnv->CallVoidMethod( this->instance, voidsetCallbackjstringID ,callback_);if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void SwingScilabMenu::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache Luke */ voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void SwingScilabMenu::show (){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowID==NULL) { /* Use the cache Luke */ voidshowID = curEnv->GetMethodID(this->instanceClass, "show", "()V" ) ;
if (voidshowID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowID );if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void SwingScilabMenu::destroy (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyID==NULL) { /* Use the cache Luke */ voiddestroyID = curEnv->GetMethodID(this->instanceClass, "destroy", "()V" ) ;
if (voiddestroyID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyID );if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
