/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.lcdui;

import com.sun.kvem.midp.lcdui.EmulEventHandler;
import com.sun.kvem.midp.lcdui.SpecialKeys;
import com.sun.kvem.midp.lcdui.TextEditorBridge;
import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.lcdui.InputMethodHandler;
import com.sun.midp.lcdui.InputMode;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

public class KeyPadInputMethodHandler
extends InputMethodHandler {
    protected InputMethodClient imc;
    protected char[] buf = new char[2];
    protected int bufLen;
    protected int committedLen;
    protected int maxLen;
    protected int savedEvent;
    protected static final int IM_NONE = 0;
    protected static final int IM_ROMAN_CAPS = 1;
    protected static final int IM_ROMAN_SMALL = 2;
    protected static final int IM_NUMERIC = 3;
    protected static final int IM_SYMBOL = 4;
    protected int defaultMode;
    protected int allowedModesNum;
    protected int[] allowedModes = new int[5];
    protected int inputMode;
    protected int nextInputMode;
    protected String[] supportedInputModes = new String[]{"LATIN", "LATIN_DIGITS"};
    protected Object[][] inputModeConvTable = new Object[][]{{"LATIN", new Integer(1)}, {"LATIN", new Integer(2)}, {"LATIN_DIGITS", new Integer(3)}, {"LATIN", new Integer(4)}};
    protected int constraint;
    protected static final int KEY_NONE = -1;
    protected static final int KEY_NUM0 = 0;
    protected static final int KEY_NUM1 = 1;
    protected static final int KEY_NUM2 = 2;
    protected static final int KEY_NUM3 = 3;
    protected static final int KEY_NUM4 = 4;
    protected static final int KEY_NUM5 = 5;
    protected static final int KEY_NUM6 = 6;
    protected static final int KEY_NUM7 = 7;
    protected static final int KEY_NUM8 = 8;
    protected static final int KEY_NUM9 = 9;
    protected static final int KEY_STAR = 10;
    protected static final int KEY_POUND = 11;
    protected static final int KEY_CLEAR = 100;
    protected static final int KEY_SELECT = 19;
    protected char[][] keyMap;
    protected char[][] upperRomanKeyMap = new char[][]{{'0'}, {'1'}, {'A', 'B', 'C', '2'}, {'D', 'E', 'F', '3'}, {'G', 'H', 'I', '4'}, {'J', 'K', 'L', '5'}, {'M', 'N', 'O', '6'}, {'P', 'Q', 'R', 'S', '7'}, {'T', 'U', 'V', '8'}, {'W', 'X', 'Y', 'Z', '9'}, {'\u0000'}, {' '}};
    protected char[][] lowerRomanKeyMap = new char[][]{{'0'}, {'1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}, {'\u0000'}, {' '}};
    protected char[][] numericKeyMap = new char[][]{{'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'*'}, {' '}};
    protected char[][] phoneNumericKeyMap = new char[][]{{'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'*'}, {'#', '+'}};
    protected SymbolTable st = new SymbolTable();
    protected char[] symbolTableChars = new char[]{'_', '$', '(', ')', '\\', '~', '\"', '\'', '/', '&', '*', '@', '.', '?', '!', '#', '-', ',', ':', ';', '%', '=', '+', '<', '>'};
    protected int defaultSymbolCursorPos = 12;
    protected boolean hasSymbolTable = false;
    protected boolean incomposing;
    protected int inputPos;
    protected static final int TM_NONE = 0;
    protected static final int TM_INPUT_MODE = 1;
    protected static final int TM_IN_COMPOSING = 2;
    protected static final int TM_CLEAR_BUFFER = 3;
    protected int timerType;
    protected Timer timerService = new Timer();
    protected TimerTask timerClient = null;
    protected int lastKey;
    protected int lastPos;

    public void setFocus(boolean focus) {
        if (this.imc == null) {
            return;
        }
        if (focus) {
            if (this.hasSymbolTable) {
                int mode = this.nextInputMode();
                if (this.bufLen > 0) {
                    this.handleCharInput();
                }
                this.setInputMode(mode);
                this.hasSymbolTable = false;
            } else {
                this.setInputMode(this.defaultMode);
            }
        } else if (!this.hasSymbolTable) {
            this.setInputMode(0);
        }
    }

    public void setInputMethodClient(InputMethodClient imc) {
        if (this.imc == imc) {
            return;
        }
        this.lastKey = -1;
        this.lastPos = 0;
        this.incomposing = false;
        this.imc = imc;
        this.constraint = imc.getConstraints() & 0xFFFF;
        this.setConstraint();
        this.inputMode = this.defaultMode;
        switch (this.inputMode) {
            case 1: {
                this.keyMap = this.upperRomanKeyMap;
                break;
            }
            case 2: {
                this.keyMap = this.lowerRomanKeyMap;
                break;
            }
            case 3: {
                this.keyMap = this.constraint == 3 ? this.phoneNumericKeyMap : this.numericKeyMap;
            }
        }
    }

    public void clearInputMethodClient(InputMethodClient imcToBeCleared) {
        if (!this.hasSymbolTable && this.imc == imcToBeCleared) {
            this.imc = null;
        }
    }

    protected int toKeyMapIndex(int keyCode) {
        switch (keyCode) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
        }
        int systemKey = EmulEventHandler.getSystemKeyImpl(keyCode);
        int gameAction = EmulEventHandler.getGameActionImpl(keyCode);
        if (systemKey == 4) {
            return 100;
        }
        if (gameAction == 8) {
            return 19;
        }
        return -1;
    }

    public boolean keyPressed(int keyCode) {
        if (SpecialKeys.isStartEdit(keyCode)) {
            TextEditorBridge.editText(this.imc);
            return true;
        }
        int idx = this.toKeyMapIndex(keyCode);
        switch (idx) {
            case -1: 
            case 19: {
                return false;
            }
            case 100: {
                this.setTimer(3, 1500L);
                return true;
            }
        }
        switch (this.constraint) {
            case 2: {
                if (idx == 10) {
                    this.toggleSign();
                    return true;
                }
                if (idx != 11) break;
                return false;
            }
            case 3: {
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                if (idx != 10) break;
                this.setTimer(1, 1000L);
                return true;
            }
        }
        if (this.processChar(idx)) {
            try {
                this.handleCharInput();
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public boolean keyReleased(int keyCode) {
        int idx = this.toKeyMapIndex(keyCode);
        if (idx == -1) {
            return false;
        }
        if (idx == 100) {
            if (this.timerType == 3) {
                this.endComposition();
                int pos = this.imc.getCaretPosition();
                if (pos > 0) {
                    this.imc.replace(null, 0, 1, pos - 1, pos);
                }
            }
            return true;
        }
        if (idx == 10) {
            if (this.timerType == 1) {
                this.endComposition();
                this.setInputMode(this.nextInputMode());
            }
            return true;
        }
        return false;
    }

    public boolean keyRepeated(int keyCode) {
        return false;
    }

    public void endComposition() {
        if (this.timerType != 0) {
            this.cancelTimer();
            this.timerType = 0;
        }
        if (this.incomposing) {
            this.imc.setCaretVisible(true);
            this.incomposing = false;
        }
        this.end();
    }

    public String[] supportedInputModes() {
        return this.supportedInputModes;
    }

    protected void insertChar(char c) {
        if (this.imc.getSize() < this.imc.getMaxSize()) {
            char[] buf = new char[]{c};
            this.imc.insert(buf, 0, 1, this.imc.getCaretPosition());
        }
    }

    protected void toggleSign() {
        char[] tmp = new char[this.imc.getSize() + 1];
        int len = this.imc.getChars(tmp);
        if (len > 0 && tmp[0] == '-') {
            if (--len == 0) {
                this.imc.setChars(null, 0, 0);
            } else {
                System.arraycopy(tmp, 1, tmp, 0, len);
                int pos = this.imc.getCaretPosition();
                this.imc.setChars(tmp, 0, len);
                this.imc.setCaretPosition(--pos);
            }
        } else {
            if (len >= this.imc.getMaxSize()) {
                return;
            }
            if (len != 0) {
                System.arraycopy(tmp, 0, tmp, 1, len);
            }
            tmp[0] = 45;
            int pos = this.imc.getCaretPosition();
            this.imc.setChars(tmp, 0, ++len);
            this.imc.setCaretPosition(++pos);
        }
    }

    protected void handleCharInput() {
        if (this.bufLen == 0) {
            return;
        }
        if (!this.incomposing) {
            this.inputPos = this.imc.getCaretPosition();
        }
        if (this.committedLen >= 1) {
            if (this.incomposing) {
                if (this.imc.getSize() + this.committedLen >= this.imc.getMaxSize()) {
                    this.committedLen = this.imc.getMaxSize() - this.imc.getSize();
                }
                if (this.committedLen > 0) {
                    this.imc.replace(this.buf, 0, this.committedLen, this.inputPos - 1, this.inputPos);
                }
            } else {
                int i = 0;
                while (i < this.committedLen) {
                    if (this.imc.getSize() < this.imc.getMaxSize()) {
                        this.imc.insert(this.buf, i, i + 1, this.inputPos + i);
                    }
                    ++i;
                }
            }
            this.incomposing = false;
        }
        if (this.bufLen > 0 && this.bufLen > this.committedLen) {
            if (this.incomposing) {
                this.imc.replace(this.buf, this.committedLen, 1, this.inputPos - 1, this.inputPos);
            } else if (this.imc.getSize() < this.imc.getMaxSize()) {
                this.imc.insert(this.buf, this.committedLen, 1, this.inputPos++);
                this.incomposing = true;
            }
        }
        if (this.incomposing) {
            this.setTimer(2, 1600L);
        } else {
            this.imc.setCaretVisible(true);
        }
    }

    protected void setTimer(int type, long delay) {
        if (type != this.timerType) {
            if (type == 2) {
                this.imc.setCaretVisible(false);
            }
            this.timerType = type;
        }
        this.cancelTimer();
        try {
            this.timerClient = new TimerClient();
            this.timerService.schedule(this.timerClient, delay);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.cancelTimer();
        }
    }

    protected void cancelTimer() {
        if (this.timerClient != null) {
            this.timerClient.cancel();
            this.timerClient = null;
        }
    }

    protected void timerWentOff() {
        switch (this.timerType) {
            case 1: {
                this.endComposition();
                this.nextInputMode = this.inputMode;
                this.setInputMode(4);
                break;
            }
            case 2: {
                this.endComposition();
                break;
            }
            case 3: {
                this.endComposition();
                this.imc.setChars(null, 0, 0);
            }
        }
    }

    protected boolean processChar(int idx) {
        if (this.lastKey == -1) {
            if (this.inputMode == 0) {
                this.buf[0] = '\u0000';
                this.committedLen = 0;
                this.bufLen = 0;
            } else {
                this.buf[0] = this.keyMap[idx][0];
                if (this.buf[0] == '\u0000') {
                    return false;
                }
                if (this.keyMap[idx].length == 1) {
                    this.committedLen = 1;
                    this.bufLen = 1;
                } else {
                    this.bufLen = 1;
                    this.lastKey = idx;
                    this.committedLen = 0;
                    this.lastPos = 0;
                }
            }
            return true;
        }
        if (this.lastKey != idx) {
            char c = this.keyMap[idx][0];
            if (c == '\u0000') {
                return false;
            }
            this.buf[0] = this.keyMap[this.lastKey][this.lastPos];
            this.buf[1] = c;
            this.bufLen = 2;
            this.lastPos = 0;
            if (this.keyMap[idx].length == 1) {
                this.committedLen = 2;
                this.lastKey = -1;
            } else {
                this.committedLen = 1;
                this.lastKey = idx;
            }
            return true;
        }
        if (this.lastKey == idx) {
            int len = this.keyMap[idx].length;
            this.lastPos = len == this.lastPos + 1 ? 0 : ++this.lastPos;
            this.buf[0] = this.keyMap[idx][this.lastPos];
            this.bufLen = 1;
            this.committedLen = 0;
            return true;
        }
        return false;
    }

    protected void end() {
        if (this.lastKey != -1) {
            this.buf[0] = this.keyMap[this.lastKey][this.lastPos];
            this.bufLen = 1;
            this.committedLen = 1;
            this.lastKey = -1;
        } else {
            this.bufLen = 0;
            this.committedLen = 0;
        }
    }

    protected int nextInputMode() {
        if (this.nextInputMode != 0) {
            int tmp = this.nextInputMode;
            this.nextInputMode = 0;
            return tmp;
        }
        int n = 0;
        while (n < this.allowedModesNum) {
            if (this.allowedModes[n] == this.inputMode) break;
            ++n;
        }
        if (++n >= this.allowedModesNum) {
            n = 0;
        }
        return this.allowedModes[n];
    }

    protected boolean setInputMode(int mode) {
        switch (mode) {
            case 1: {
                this.keyMap = this.upperRomanKeyMap;
                break;
            }
            case 2: {
                this.keyMap = this.lowerRomanKeyMap;
                break;
            }
            case 3: {
                this.keyMap = this.constraint == 3 ? this.phoneNumericKeyMap : this.numericKeyMap;
                break;
            }
            case 4: {
                this.st.invokeSYM();
                break;
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        this.inputMode = mode;
        this.imc.setInputMode(this.inputMode);
        return true;
    }

    protected void setConstraint() {
        if (this.constraint == 2 || this.constraint == 3) {
            this.defaultMode = 3;
            this.allowedModesNum = 1;
            this.allowedModes[0] = 3;
        } else if (this.constraint == 1 || this.constraint == 4) {
            this.defaultMode = 2;
            this.allowedModesNum = 4;
            this.allowedModes[0] = 2;
            this.allowedModes[1] = 1;
            this.allowedModes[2] = 3;
            this.allowedModes[3] = 4;
        } else {
            String dMode = null;
            String[] aMode = null;
            if (this.constraint == 0) {
                Object obj = this.imc.getClientObject();
                if (obj instanceof TextBox) {
                    dMode = InputMode.getMode((TextBox)obj);
                    aMode = InputMode.getAllowedModes((TextBox)obj);
                } else if (obj instanceof TextField) {
                    dMode = InputMode.getMode((TextField)obj);
                    aMode = InputMode.getAllowedModes((TextField)obj);
                }
            }
            this.allowedModesNum = 0;
            if (dMode == null && aMode == null) {
                int i = 0;
                while (i < this.inputModeConvTable.length) {
                    this.allowedModes[this.allowedModesNum++] = (Integer)this.inputModeConvTable[i][1];
                    ++i;
                }
                this.defaultMode = this.allowedModes[0];
            } else {
                if (dMode == null && aMode != null) {
                    dMode = aMode[0];
                }
                if (dMode != null && aMode == null) {
                    aMode = new String[this.supportedInputModes.length];
                    System.arraycopy(this.supportedInputModes, 0, aMode, 0, this.supportedInputModes.length);
                }
                int i = 0;
                while (i < this.inputModeConvTable.length) {
                    if (((String)this.inputModeConvTable[i][0]).equals(dMode)) {
                        this.defaultMode = (Integer)this.inputModeConvTable[i][1];
                        break;
                    }
                    ++i;
                }
                int j = 0;
                while (j < this.inputModeConvTable.length) {
                    i = 0;
                    while (i < aMode.length) {
                        if (((String)this.inputModeConvTable[j][0]).equals(aMode[i])) {
                            this.allowedModes[this.allowedModesNum++] = (Integer)this.inputModeConvTable[j][1];
                        }
                        ++i;
                    }
                    ++j;
                }
                if (this.defaultMode == 0) {
                    this.defaultMode = this.allowedModes[0];
                } else if (this.defaultMode != this.allowedModes[0]) {
                    int t;
                    i = 0;
                    while (i < this.allowedModesNum) {
                        if (this.defaultMode == this.allowedModes[i]) break;
                        ++i;
                    }
                    this.allowedModes[i] = t = this.allowedModes[0];
                    this.allowedModes[0] = this.defaultMode;
                }
            }
        }
    }

    protected class SymbolTable
    extends Canvas {
        private final int MARGIN;
        private final int DMARGIN;
        private int cc;
        private int hmargin;
        private int wmargin;
        private int margin;
        private int wx;
        private int wy;
        private int ww;
        private int wh;
        private int cols;
        private int rows;
        private int pos;
        private int newpos;
        private Font font;
        private boolean firstTime = false;
        private Display currentDisplay;
        private Displayable previousScreen;

        protected SymbolTable() {
            this.MARGIN = 1;
            this.DMARGIN = 2;
        }

        void init() {
            if (KeyPadInputMethodHandler.this.symbolTableChars.length <= 25) {
                this.cols = 5;
                this.rows = 5;
            } else {
                this.rows = 6;
                this.cols = 6;
            }
            int w = this.getWidth() / this.cols;
            int h = this.getHeight() / this.rows;
            this.cc = w > h ? h : w;
            int cw = 0;
            int ch = 0;
            int[] fs = new int[]{16, 0, 8};
            int i = 0;
            while (i < fs.length) {
                this.font = Font.getFont(0, 1, fs[i]);
                cw = this.font.charWidth('M');
                ch = this.font.getHeight();
                if (cw <= this.cc && ch <= this.cc) break;
                ++i;
            }
            this.ww = this.cols * this.cc;
            this.wh = this.rows * this.cc;
            this.wx = (this.getWidth() - this.ww) / 2;
            this.wy = this.getHeight() - this.wh;
            this.hmargin = (this.cc - ch) / 2;
            this.wmargin = this.cc / 2;
            this.margin = this.hmargin + 2;
        }

        public void invokeSYM() {
            if (this.font == null) {
                this.init();
            }
            this.currentDisplay = KeyPadInputMethodHandler.this.imc.getDisplay();
            this.previousScreen = this.currentDisplay.getCurrent();
            this.currentDisplay.setCurrent(this);
            KeyPadInputMethodHandler.this.hasSymbolTable = true;
        }

        protected void showNotify() {
            this.pos = this.newpos = KeyPadInputMethodHandler.this.defaultSymbolCursorPos;
        }

        protected void hideNotify() {
            this.firstTime = false;
        }

        protected void paint(Graphics g) {
            if (!this.firstTime) {
                this.paintPanel(g);
                this.firstTime = true;
            }
            this.showCursor(g, this.pos, false);
            this.pos = this.newpos;
            this.showCursor(g, this.pos, true);
        }

        void paintPanel(Graphics g) {
            g.setFont(this.font);
            g.setGrayScale(255);
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setGrayScale(0);
            g.drawRect(this.wx + 1, this.wy + 1, this.ww - 2, this.wh - 2);
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.cols) {
                    int i = r * this.cols + c;
                    if (i == KeyPadInputMethodHandler.this.symbolTableChars.length) break;
                    this.drawChar(g, KeyPadInputMethodHandler.this.symbolTableChars[i], r, c, false);
                    ++c;
                }
                ++r;
            }
        }

        void drawChar(Graphics g, char c, int row, int col, boolean reverse) {
            int h = this.font.charWidth(c);
            int y = this.wy + row * this.cc + this.hmargin;
            int x = this.wx + col * this.cc + this.wmargin;
            g.setFont(this.font);
            if (reverse) {
                g.setGrayScale(255);
            } else {
                g.setGrayScale(0);
            }
            g.drawChar(c, x, y, 17);
        }

        void showCursor(Graphics g, int pos, boolean show) {
            int row = pos / this.cols;
            int col = pos % this.cols;
            int y = this.wy + row * this.cc;
            int x = this.wx + col * this.cc;
            if (show) {
                g.setGrayScale(0);
            } else {
                g.setGrayScale(255);
            }
            g.fillRect(x + this.margin, y + this.margin, this.cc - this.margin - 1, this.cc - this.margin - 1);
            this.drawChar(g, KeyPadInputMethodHandler.this.symbolTableChars[pos], row, col, show);
        }

        protected void keyPressed(int keyCode) {
            if (keyCode > 0 && (char)keyCode == '*') {
                this.currentDisplay.setCurrent(this.previousScreen);
            } else {
                switch (this.getGameAction(keyCode)) {
                    case 5: {
                        if (this.pos + 1 >= KeyPadInputMethodHandler.this.symbolTableChars.length) break;
                        this.newpos = this.pos + 1;
                        this.repaint();
                        break;
                    }
                    case 2: {
                        if (this.pos <= 0) break;
                        this.newpos = this.pos - 1;
                        this.repaint();
                        break;
                    }
                    case 1: {
                        int p = this.pos - this.cols;
                        if (p < 0) break;
                        this.newpos = p;
                        this.repaint();
                        break;
                    }
                    case 6: {
                        int p = this.pos + this.cols;
                        if (p >= KeyPadInputMethodHandler.this.symbolTableChars.length) break;
                        this.newpos = p;
                        this.repaint();
                        break;
                    }
                    case 8: {
                        KeyPadInputMethodHandler.this.buf[0] = KeyPadInputMethodHandler.this.symbolTableChars[this.pos];
                        KeyPadInputMethodHandler.this.bufLen = 1;
                        KeyPadInputMethodHandler.this.committedLen = 1;
                        this.currentDisplay.setCurrent(this.previousScreen);
                    }
                }
            }
        }
    }

    class TimerClient
    extends TimerTask {
        TimerClient() {
        }

        public final void run() {
            KeyPadInputMethodHandler.this.timerWentOff();
        }
    }
}

