/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ksecurity;

import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.MessageDigest;
import com.sun.ksecurity.RandomData;

final class PRand
extends RandomData {
    private static MessageDigest md = null;
    private static byte[] seed = new byte[]{-55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47};
    private static byte[] randomBytes;
    private static int bytesAvailable;

    public PRand() throws CryptoException {
        if (md != null) {
            return;
        }
        try {
            md = MessageDigest.getInstance((byte)1, false);
        }
        catch (Exception e) {
            throw new CryptoException(4);
        }
        randomBytes = new byte[seed.length];
        this.updateSeed();
    }

    public void generateData(byte[] b, short off, short len) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            int i = 0;
            block3: while (true) {
                if (bytesAvailable == 0) {
                    md.doFinal(seed, 0, seed.length, randomBytes, 0);
                    this.updateSeed();
                    bytesAvailable = randomBytes.length;
                }
                while (true) {
                    if (bytesAvailable <= 0) continue block3;
                    if (i == len) {
                        return;
                    }
                    b[off + i] = randomBytes[--bytesAvailable];
                    ++i;
                }
                break;
            }
        }
    }

    public void setSeed(byte[] b, short off, short len) {
        int j = 0;
        if (len <= 0 || b.length < off + len) {
            return;
        }
        int i = 0;
        while (i < seed.length) {
            if (j == len) {
                j = 0;
            }
            PRand.seed[i] = b[off + j];
            ++i;
            ++j;
        }
    }

    public void updateSeed() {
        long t = System.currentTimeMillis();
        byte[] tmp = new byte[8];
        int i = 0;
        while (i < 8) {
            tmp[i] = (byte)(t & 0xFFL);
            t >>>= 8;
            ++i;
        }
        md.update(seed, 0, seed.length);
        md.doFinal(tmp, 0, tmp.length, seed, 0);
    }

    static {
        bytesAvailable = 0;
    }
}

