/*
 * File:	mca.h
 * Purpose:	Machine check handling specific defines
 *
 * Copyright (C) 1999 Silicon Graphics, Inc.
 * Copyright (C) Vijay Chander (vijay@engr.sgi.com)
 * Copyright (C) Srinivasa Thirumalachar (sprasad@engr.sgi.com)
 * 2003-11-05 Strip down to the bare minimum required to decode SAL records.
 *	      Keith Owens <kaos@sgi.com>
 * 2003-11-16 Break out oem data decoder so each platform can handle the
 *	      oem data as it likes.
 *	      Keith Owens <kaos@sgi.com>
 */

#ifndef _MCA_H
#define _MCA_H

/* Minimal declarations so we can use the kernel definitions of SAL records */
#include <stdint.h>
typedef uint8_t  u8;
typedef int8_t   s8;
typedef uint16_t u16;
typedef int16_t  s16;
typedef uint32_t u32;
typedef int32_t  s32;
typedef uint64_t u64;
typedef int64_t  s64;

#include "sal.h"

#define platform_mem_dev_err_print prt_oem_data
#define platform_pci_bus_err_print prt_oem_data
#define platform_pci_comp_err_print prt_oem_data
#define platform_plat_specific_err_print prt_oem_data
#define platform_host_ctlr_err_print prt_oem_data
#define platform_plat_bus_err_print prt_oem_data

extern void platform_info_print (sal_log_record_header_t *lh, int use_sal, int fd_data, int cpu, int *oemdata_fd);

#endif /* _MCA_H */
