/*
 * Decompiled with CFR 0.152.
 */
package king.tool.export;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.util.SoftLog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import king.KinCanvas;
import king.Plugin;
import king.ToolBox;

public class ImageExport
extends Plugin
implements PropertyChangeListener,
Runnable {
    JFileChooser chooser;
    SuffixFileFilter jpgFilter;
    SuffixFileFilter pngFilter;
    SuffixFileFilter pngtFilter;

    public ImageExport(ToolBox toolBox) {
        super(toolBox);
        this.buildChooser();
    }

    private void buildChooser() {
        this.jpgFilter = new SuffixFileFilter("Joint Photographic Experts Group (JPEG)");
        this.jpgFilter.addSuffix(".jpg");
        this.jpgFilter.addSuffix(".jpe");
        this.jpgFilter.addSuffix(".jpeg");
        this.pngFilter = new SuffixFileFilter("Portable Network Graphics (PNG)");
        this.pngFilter.addSuffix(".png");
        this.pngtFilter = new SuffixFileFilter("PNG with transparent background");
        this.pngtFilter.addSuffix(".png");
        String string = System.getProperty("user.dir");
        this.chooser = new JFileChooser();
        this.chooser.addChoosableFileFilter(this.jpgFilter);
        this.chooser.addChoosableFileFilter(this.pngFilter);
        this.chooser.addChoosableFileFilter(this.pngtFilter);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(this.jpgFilter);
        if (string != null) {
            this.chooser.setCurrentDirectory(new File(string));
        }
        this.chooser.addPropertyChangeListener(this);
    }

    public static void exportImage(KinCanvas kinCanvas, String string, File file) throws IOException {
        ImageExport.exportImage(kinCanvas, string, false, 1, file);
    }

    public static void exportImage(KinCanvas kinCanvas, String string, boolean bl, int n, File file) throws IOException {
        Dimension dimension = kinCanvas.getCanvasSize();
        BufferedImage bufferedImage = string.equals("png") ? new BufferedImage(n * dimension.width, n * dimension.height, 2) : new BufferedImage(n * dimension.width, n * dimension.height, 4);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(n, n);
        if (bl) {
            kinCanvas.getEngine().setTransparentBackground();
        }
        kinCanvas.paintCanvas(graphics2D, dimension, 2);
        if (string.equals("jpg")) {
            ImageExport.writeAtHighestQuality(bufferedImage, string, file);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        }
    }

    static void writeAtHighestQuality(BufferedImage bufferedImage, String string, File file) throws IOException {
        Object object;
        Object object2 = null;
        ImageWriteParam imageWriteParam = null;
        float f = 0.0f;
        Object object3 = ImageIO.getImageWritersByFormatName(string);
        while (object3.hasNext()) {
            object = object3.next();
            ImageWriteParam imageWriteParam2 = ((ImageWriter)object).getDefaultWriteParam();
            imageWriteParam2.setCompressionMode(2);
            float f2 = 0.0f;
            float[] fArray = imageWriteParam2.getCompressionQualityValues();
            for (int i = 0; i < fArray.length; ++i) {
                f2 = Math.max(f2, fArray[i]);
            }
            if (!(f2 > f)) continue;
            imageWriteParam2.setCompressionQuality(f2);
            object2 = object;
            imageWriteParam = imageWriteParam2;
            f = f2;
        }
        if (object2 == null) {
            return;
        }
        object3 = new FileImageOutputStream(file);
        ((ImageWriter)object2).setOutput(object3);
        object = new IIOImage(bufferedImage, null, null);
        ((ImageWriter)object2).write(null, (IIOImage)object, imageWriteParam);
        ((ImageInputStreamImpl)object3).flush();
        ((ImageWriter)object2).dispose();
        ((FileImageOutputStream)object3).close();
    }

    public void askExport() {
        this.propertyChange(null);
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.chooser.setCurrentDirectory(new File(string));
        }
        if (0 == this.chooser.showSaveDialog(this.kMain.getTopWindow())) {
            File file;
            String string2 = this.getFormat();
            FileFilter fileFilter = this.chooser.getFileFilter();
            if (!fileFilter.accept(file = this.chooser.getSelectedFile()) && 0 == JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file has the wrong extension. Append '." + string2 + "' to the name?", "Fix extension?", 0)) {
                file = new File(file + "." + string2);
            }
            if (!file.exists() || 0 == JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file exists -- do you want to overwrite it?", "Overwrite file?", 0)) {
                try {
                    ImageExport.exportImage(this.kMain.getCanvas(), string2, this.pngtFilter.equals(fileFilter), this.kMain.getPrefs().getInt("imageExportMultiplier"), file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An I/O error occurred while saving the file:\n" + iOException.getMessage(), "Sorry!", 0);
                    iOException.printStackTrace(SoftLog.err);
                }
                System.setProperty("user.dir", file.getAbsolutePath());
            }
        }
    }

    String getFormat() {
        FileFilter fileFilter = this.chooser.getFileFilter();
        String string = this.pngFilter.equals(fileFilter) ? "png" : (this.pngtFilter.equals(fileFilter) ? "png" : (this.jpgFilter.equals(fileFilter) ? "jpg" : "jpg"));
        return string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null || "fileFilterChanged".equals(propertyChangeEvent.getPropertyName()) || "directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        String string = this.getFormat();
        for (int i = 1; i < 1000; ++i) {
            File file = new File(this.chooser.getCurrentDirectory(), "kingsnap" + i + "." + string);
            if (file.exists()) continue;
            this.chooser.setSelectedFile(file);
            break;
        }
    }

    public static void diagnostics() {
        int n;
        SoftLog.err.println("Can write the following formats:");
        String[] stringArray = ImageIO.getWriterMIMETypes();
        for (n = 0; n < stringArray.length; ++n) {
            SoftLog.err.println("  " + n + ":\t" + stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            SoftLog.err.println("Writers for " + stringArray[n] + ":");
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(stringArray[n]);
            while (iterator.hasNext()) {
                SoftLog.err.println("  " + iterator.next());
            }
        }
    }

    public JMenuItem getToolsMenuItem() {
        return new JMenuItem(new ReflectiveAction(this.toString() + "...", null, this, "onExport"));
    }

    public JMenuItem getHelpMenuItem() {
        return null;
    }

    public String toString() {
        return "Image file (JPG, PNG)";
    }

    public void onExport(ActionEvent actionEvent) {
        this.askExport();
    }

    public static boolean isAppletSafe() {
        return false;
    }
}

