/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.MagnifiedTheme;
import driftwood.gui.SuffixFileFilter;
import driftwood.util.ReflectiveRunnable;
import driftwood.util.SoftLog;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JApplet;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import king.ContentPane;
import king.FileDropHandler;
import king.KMessage;
import king.KinCanvas;
import king.KinStable;
import king.KinTree;
import king.KinfileIO;
import king.KingPrefs;
import king.MainWindow;
import king.Plugin;
import king.UIMenus;
import king.UIText;
import king.core.KView;
import king.core.Kinemage;

public class KingMain
implements WindowListener {
    static int instanceCount;
    public static int MENU_ACCEL_MASK;
    KingPrefs prefs = null;
    KinStable kinStable = null;
    KinfileIO kinIO = null;
    FileDropHandler dropHandler = null;
    KinCanvas kinCanvas = null;
    UIMenus uiMenus = null;
    UIText uiText = null;
    KinTree kinTree = null;
    MainWindow mainWin = null;
    ContentPane contentPane = null;
    JApplet theApplet = null;
    boolean isAppletFlat = true;
    ArrayList<File> filesToOpen = null;
    ArrayList<File> pdbFilesToOpen = null;
    boolean doMerge = true;
    Set<KMessage.Subscriber> subscribers = new LinkedHashSet<KMessage.Subscriber>();

    public static void main(String[] stringArray) {
        new KingMain(stringArray).Main();
    }

    public KingMain() {
        this(new String[0]);
    }

    public KingMain(String[] stringArray) {
        try {
            Locale.setDefault(Locale.US);
        }
        catch (SecurityException securityException) {
            SoftLog.err.println("Can't change to US locale; numbers may be garbled on kinemage write.");
        }
        this.prefs = new KingPrefs(false);
        if (this.prefs.getBoolean("checkNewVersion")) {
            try {
                this.prefs.checkVersion(new URL("http://kinemage.biochem.duke.edu/downloads/software/king/king2.version.props"), 2000L);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(SoftLog.err);
            }
        }
        this.parseArguments(stringArray);
        ++instanceCount;
    }

    public KingMain(JApplet jApplet, boolean bl) {
        this.prefs = new KingPrefs(true);
        this.theApplet = jApplet;
        this.isAppletFlat = bl;
        String string = this.theApplet.getParameter("king_prefs");
        if (string != null) {
            try {
                URL uRL = new URL(this.theApplet.getDocumentBase(), string);
                this.prefs.loadFromURL(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                SoftLog.err.println("<PARAM> king_prefs specified an unresolvable URL.");
            }
        }
        ++instanceCount;
    }

    public void createComponents() {
        this.createComponents(true, true);
    }

    public void createComponents(boolean bl, boolean bl2) {
        this.kinStable = new KinStable(this);
        this.contentPane = new ContentPane(this);
        this.kinIO = new KinfileIO(this);
        this.dropHandler = new FileDropHandler(this);
        this.kinCanvas = new KinCanvas(this);
        this.uiMenus = new UIMenus(this);
        this.uiText = new UIText(this);
        this.kinTree = new KinTree(this);
        this.contentPane.buildGUI(bl, bl2);
    }

    public void shutdown() {
        if (this.mainWin != null) {
            this.mainWin.shutdown();
        }
        this.publish(new KMessage(this, 1024L));
        if (--instanceCount <= 0 && this.theApplet == null) {
            try {
                System.exit(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void Main() {
        if (this.isApplet()) {
            MENU_ACCEL_MASK = 2;
        }
        try {
            if (System.getProperty("user.dir").equals("/Applications")) {
                System.setProperty("user.dir", System.getProperty("user.home"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        float f = this.prefs.getFloat("fontMagnification");
        if (f != 1.0f) {
            MetalLookAndFeel.setCurrentTheme(new MagnifiedTheme(f));
            try {
                UIManager.setLookAndFeel(UIManager.getLookAndFeel());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!SoftLog.replaceSystemStreams() && this.theApplet == null) {
            SoftLog.err.println("Unable to subvert System.err; some exception traces may be lost.");
        }
        if (this.theApplet == null || !this.isAppletFlat) {
            this.mainWin = new MainWindow(this);
        }
        this.createComponents();
        if (this.theApplet == null || !this.isAppletFlat) {
            this.mainWin.setContentPane(this.contentPane);
            this.mainWin.setJMenuBar(this.uiMenus.getMenuBar());
            this.mainWin.addWindowListener(this);
            this.mainWin.pack();
            this.mainWin.setVisible(true);
            if (this.prefs.getBoolean("textOpenOnStart")) {
                this.uiText.cascadeBehind(this.mainWin);
            }
        } else {
            this.kinCanvas.setPreferredSize(null);
            this.kinCanvas.setMinimumSize(null);
            this.theApplet.setContentPane(this.contentPane);
            this.theApplet.setJMenuBar(this.uiMenus.getMenuBar());
            this.theApplet.validate();
        }
        try {
            Class<?> clazz = Class.forName("king.MacDropTarget");
            Method method = clazz.getMethod("bindTo", KingMain.class);
            method.invoke(null, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.theApplet == null) {
            SwingUtilities.invokeLater(new ReflectiveRunnable(this, "loadFiles"));
        } else {
            SwingUtilities.invokeLater(new ReflectiveRunnable(this, "appletLoadFiles"));
        }
    }

    public void loadFiles() {
        if (this.filesToOpen != null && this.filesToOpen.size() > 0 || this.pdbFilesToOpen != null && this.pdbFilesToOpen.size() > 0) {
            Plugin plugin;
            Kinemage kinemage = null;
            if (this.doMerge && this.filesToOpen.size() - this.pdbFilesToOpen.size() > 1) {
                kinemage = new Kinemage("Kinemage #1");
            }
            for (File iterator2 : this.filesToOpen) {
                this.kinIO.loadFile(iterator2, kinemage);
            }
            if (kinemage != null) {
                this.getStable().append(Arrays.asList(kinemage));
            }
            List list = this.kinCanvas.toolbox.getPluginList();
            Iterator iterator = list.iterator();
            if (this.pdbFilesToOpen != null && this.pdbFilesToOpen.size() > 0) {
                while (iterator.hasNext()) {
                    plugin = (Plugin)iterator.next();
                    plugin.loadFileFromCmdline(this.pdbFilesToOpen);
                }
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                plugin = (Plugin)iterator2.next();
                plugin.loadFileFromCmdline(this.filesToOpen);
            }
        }
        this.publish(new KMessage(this, 1L));
    }

    public void appletLoadFiles() {
        URL uRL;
        try {
            uRL = this.getAppletKinURL();
            if (uRL != null) {
                this.getKinIO().loadURL(uRL, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            SoftLog.err.println("<PARAM> kinSource specified an unresolvable URL.");
        }
        try {
            uRL = this.getAppletPdbURL();
            if (uRL != null) {
                List list = this.kinCanvas.toolbox.getPluginList();
                for (Plugin plugin : list) {
                    try {
                        plugin.loadFromURL(uRL);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            SoftLog.err.println("<PARAM> pdbSource specified an unresolvable URL.");
        }
        this.publish(new KMessage(this, 1L));
    }

    public URL getAppletKinURL() throws MalformedURLException {
        String string = this.theApplet.getParameter("kinSource");
        if (string == null) {
            string = this.theApplet.getParameter("kinFile");
        }
        if (string == null) {
            string = this.theApplet.getParameter("kinURL");
        }
        if (string == null) {
            string = this.theApplet.getParameter("kinemage");
        }
        if (string == null) {
            string = this.theApplet.getParameter("kin");
        }
        if (string != null) {
            return new URL(this.theApplet.getDocumentBase(), string);
        }
        return null;
    }

    public URL getAppletPdbURL() throws MalformedURLException {
        String string = this.theApplet.getParameter("pdbSource");
        if (string == null) {
            string = this.theApplet.getParameter("pdbFile");
        }
        if (string == null) {
            string = this.theApplet.getParameter("pdbURL");
        }
        if (string == null) {
            string = this.theApplet.getParameter("pdb");
        }
        if (string != null) {
            return new URL(this.theApplet.getDocumentBase(), string);
        }
        return null;
    }

    public void subscribe(KMessage.Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void unsubscribe(KMessage.Subscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public void publish(KMessage kMessage) {
        KMessage.Subscriber[] subscriberArray;
        for (KMessage.Subscriber subscriber : subscriberArray = this.subscribers.toArray(new KMessage.Subscriber[this.subscribers.size()])) {
            subscriber.deliverMessage(kMessage);
        }
    }

    public Container getContentContainer() {
        return this.mainWin == null ? this.theApplet : this.mainWin;
    }

    public ContentPane getContentPane() {
        return this.contentPane;
    }

    public Frame getTopWindow() {
        return this.mainWin;
    }

    public KinStable getStable() {
        return this.kinStable;
    }

    public KinfileIO getKinIO() {
        return this.kinIO;
    }

    public FileDropHandler getFileDropHandler() {
        return this.dropHandler;
    }

    public KinCanvas getCanvas() {
        return this.kinCanvas;
    }

    public UIMenus getMenus() {
        return this.uiMenus;
    }

    public UIText getTextWindow() {
        return this.uiText;
    }

    public KinTree getKinTree() {
        return this.kinTree;
    }

    public KingPrefs getPrefs() {
        return this.prefs;
    }

    public Kinemage getKinemage() {
        return this.kinStable.getKinemage();
    }

    public KView getView() {
        if (this.kinCanvas == null) {
            return null;
        }
        return this.kinCanvas.getCurrentView();
    }

    public void setView(KView kView) {
        if (this.kinCanvas != null) {
            this.kinCanvas.setCurrentView(kView);
        }
    }

    public JApplet getApplet() {
        return this.theApplet;
    }

    public boolean isApplet() {
        return this.getApplet() != null;
    }

    public boolean isTrusted() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        try {
            securityManager.checkPermission(new AllPermission());
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    void parseArguments(String[] stringArray) {
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter("PDB files");
        suffixFileFilter.addSuffix(".pdb");
        suffixFileFilter.addSuffix(".xyz");
        suffixFileFilter.addSuffix(".ent");
        suffixFileFilter.addSuffix(".cif");
        suffixFileFilter.addSuffix(".mmcif");
        suffixFileFilter.addSuffix(".pdb.gz");
        suffixFileFilter.addSuffix(".xyz.gz");
        suffixFileFilter.addSuffix(".ent.gz");
        suffixFileFilter.addSuffix(".cif.gz");
        suffixFileFilter.addSuffix(".mmcif.gz");
        this.filesToOpen = new ArrayList();
        this.pdbFilesToOpen = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-h") || string.equals("-help")) {
                    SoftLog.err.println("Help not available. Sorry!");
                    System.exit(0);
                    continue;
                }
                if (string.equals("-version")) {
                    SoftLog.err.println("KingMain, version " + this.getPrefs().getString("version") + "\nCopyright (C) 2002-2007 by Ian W. Davis");
                    System.exit(0);
                    continue;
                }
                if (string.equals("-m") || string.equals("-merge")) {
                    this.doMerge = true;
                    continue;
                }
                if (string.equals("-s") || string.equals("-single")) {
                    this.doMerge = false;
                    continue;
                }
                SoftLog.err.println("*** Unrecognized option: " + string);
                continue;
            }
            if (suffixFileFilter.accept(string)) {
                this.pdbFilesToOpen.add(new File(string));
                continue;
            }
            this.filesToOpen.add(new File(string));
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.uiMenus != null) {
            this.uiMenus.onFileExit(null);
        } else {
            this.shutdown();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        instanceCount = 0;
        MENU_ACCEL_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }
}

