#!/usr/bin/env python

import sys
import os
import colorize
import coverage

# coverage init
# early initialization, before the import of pyinotify
# (avoid to miss something)
coverage.erase()
coverage.start()

try:
    import autopath
    import src.pyinotify.pyinotify
    from src.pyinotify.pyinotify import *
    module_ = src.pyinotify.pyinotify
except ImportError:
    import pyinotify
    from pyinotify import *
    module_ = pyinotify

# pyinotify
module_.command_line()

# coverage analysis
coverage.stop()
# colorization
f, s, m, mf = coverage.analysis(module_)
fo = file(os.path.basename(f)+'.html', 'wb')
colorize.colorize_file(f, outstream=fo, not_covered=mf)

coverage.report(module_)
coverage.erase()

