/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;

public class TailRecursionSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraTailRecursionVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private Method targetMethod;
    private boolean recursive;
    private boolean inlinedAny;

    public TailRecursionSimplifier() {
        this(null);
    }

    public TailRecursionSimplifier(InstructionVisitor instructionVisitor) {
        this.extraTailRecursionVisitor = instructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = method.getAccessFlags();
        if ((n & 0x1A) != 0 && (n & 0x720) == 0) {
            this.targetMethod = method;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.copyCode(clazz, method, codeAttribute);
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
            }
        }
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        this.codeAttributeComposer.endCodeFragment();
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(n, instruction.shrink());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                if (!this.recursive) break;
                int n2 = n + constantInstruction.length(n);
                Instruction instruction = InstructionFactory.create(codeAttribute.code, n2);
                switch (instruction.opcode) {
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: {
                        codeAttribute.exceptionsAccept(clazz, method, n, this);
                        if (!this.recursive) break;
                        this.codeAttributeComposer.appendLabel(n);
                        this.storeParameters(clazz, method);
                        int n3 = n + 1;
                        this.codeAttributeComposer.appendInstruction(n3, new BranchInstruction(-89, -n3));
                        this.inlinedAny = true;
                        if (this.extraTailRecursionVisitor != null) {
                            this.extraTailRecursionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
                        }
                        return;
                    }
                }
                break;
            }
        }
        this.codeAttributeComposer.appendInstruction(n, constantInstruction.shrink());
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.recursive = this.targetMethod.equals(methodrefConstant.referencedMember);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.recursive = false;
    }

    private void storeParameters(Clazz clazz, Method method) {
        String string;
        int n;
        String string2 = method.getDescriptor(clazz);
        boolean bl = (method.getAccessFlags() & 8) != 0;
        int n2 = ClassUtil.internalMethodParameterCount(string2);
        int n3 = ClassUtil.internalMethodParameterSize(string2);
        int n4 = bl ? 0 : 1;
        String[] stringArray = new String[n3];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string2);
        for (n = 0; n < n3; ++n) {
            stringArray[n] = string = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(string) != 2) continue;
            ++n;
        }
        this.codeAttributeComposer.beginCodeFragment(n3 + 1);
        for (n = n3 - 1; n >= 0; --n) {
            byte by;
            string = stringArray[n];
            if (string == null) continue;
            switch (string.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    by = 54;
                    break;
                }
                case 'J': {
                    by = 55;
                    break;
                }
                case 'F': {
                    by = 56;
                    break;
                }
                case 'D': {
                    by = 57;
                    break;
                }
                default: {
                    by = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(n3 - n - 1, new VariableInstruction(by, n4 + n).shrink());
        }
        if (!bl) {
            this.codeAttributeComposer.appendInstruction(n3, new VariableInstruction(58, 0).shrink());
        }
        this.codeAttributeComposer.endCodeFragment();
    }
}

