/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import proguard.ConfigurationParser;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.ant.ConfigurationTask;
import proguard.classfile.util.ClassUtil;

public class ProGuardTask
extends ConfigurationTask {
    public void setConfiguration(File file) throws BuildException {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(file);
            try {
                configurationParser.parse(this.configuration);
            }
            catch (ParseException parseException) {
                throw new BuildException(parseException.getMessage());
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage());
        }
    }

    public void setOutjar(String string) {
        throw new BuildException("Use the <outjar> nested element instead of the 'outjar' attribute");
    }

    public void setSkipnonpubliclibraryclasses(boolean bl) {
        this.configuration.skipNonPublicLibraryClasses = bl;
    }

    public void setSkipnonpubliclibraryclassmembers(boolean bl) {
        this.configuration.skipNonPublicLibraryClassMembers = bl;
    }

    public void setTarget(String string) {
        this.configuration.targetClassVersion = ClassUtil.internalClassVersion(string);
        if (this.configuration.targetClassVersion == 0) {
            throw new BuildException("Unsupported target '" + string + "'");
        }
    }

    public void setForceprocessing(boolean bl) {
        this.configuration.lastModified = bl ? Long.MAX_VALUE : 0L;
    }

    public void setPrintseeds(File file) {
        this.configuration.printSeeds = this.optionalFile(file);
    }

    public void setShrink(boolean bl) {
        this.configuration.shrink = bl;
    }

    public void setPrintusage(File file) {
        this.configuration.printUsage = this.optionalFile(file);
    }

    public void setOptimize(boolean bl) {
        this.configuration.optimize = bl;
    }

    public void setOptimizationpasses(int n) {
        this.configuration.optimizationPasses = n;
    }

    public void setAllowaccessmodification(boolean bl) {
        this.configuration.allowAccessModification = bl;
    }

    public void setMergeinterfacesaggressively(boolean bl) {
        this.configuration.mergeInterfacesAggressively = bl;
    }

    public void setObfuscate(boolean bl) {
        this.configuration.obfuscate = bl;
    }

    public void setPrintmapping(File file) {
        this.configuration.printMapping = this.optionalFile(file);
    }

    public void setApplymapping(File file) {
        this.configuration.applyMapping = this.resolvedFile(file);
    }

    public void setObfuscationdictionary(File file) {
        this.configuration.obfuscationDictionary = this.resolvedFile(file);
    }

    public void setClassobfuscationdictionary(File file) {
        this.configuration.classObfuscationDictionary = this.resolvedFile(file);
    }

    public void setPackageobfuscationdictionary(File file) {
        this.configuration.packageObfuscationDictionary = this.resolvedFile(file);
    }

    public void setOverloadaggressively(boolean bl) {
        this.configuration.overloadAggressively = bl;
    }

    public void setUseuniqueclassmembernames(boolean bl) {
        this.configuration.useUniqueClassMemberNames = bl;
    }

    public void setUsemixedcaseclassnames(boolean bl) {
        this.configuration.useMixedCaseClassNames = bl;
    }

    public void setFlattenpackagehierarchy(String string) {
        this.configuration.flattenPackageHierarchy = ClassUtil.internalClassName(string);
    }

    public void setRepackageclasses(String string) {
        this.configuration.repackageClasses = ClassUtil.internalClassName(string);
    }

    public void setDefaultpackage(String string) {
        this.configuration.repackageClasses = ClassUtil.internalClassName(string);
    }

    public void setRenamesourcefileattribute(String string) {
        this.configuration.newSourceFileAttribute = string;
    }

    public void setPreverify(boolean bl) {
        this.configuration.preverify = bl;
    }

    public void setMicroedition(boolean bl) {
        this.configuration.microEdition = bl;
    }

    public void setVerbose(boolean bl) {
        this.configuration.verbose = bl;
    }

    public void setNote(boolean bl) {
        this.configuration.note = bl ? null : new ArrayList();
    }

    public void setWarn(boolean bl) {
        this.configuration.warn = bl ? null : new ArrayList();
    }

    public void setIgnorewarnings(boolean bl) {
        this.configuration.ignoreWarnings = bl;
    }

    public void setPrintconfiguration(File file) {
        this.configuration.printConfiguration = this.optionalFile(file);
    }

    public void setDump(File file) {
        this.configuration.dump = this.optionalFile(file);
    }

    public void execute() throws BuildException {
        try {
            ProGuard proGuard = new ProGuard(this.configuration);
            proGuard.execute();
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage());
        }
    }

    private File optionalFile(File file) {
        String string = file.getName();
        return string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off") ? null : (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") ? new File("") : this.resolvedFile(file));
    }

    private File resolvedFile(File file) {
        return file.isAbsolute() ? file : new File(this.getProject().getBaseDir(), file.getName());
    }
}

