
/****************************************************************************
** Adapted from PDFviewer, originally published in the QT Quarterly:
** http://doc.trolltech.com/qq/QtQuarterly27.pdf
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Modified for use with prerex:
** http://www.ctan.org/tex-archive/graphics/prerex
** Copyright (C) 2009-11 R. D. Tennent 
** School of Computing, Queen's University, rdt@cs.queensu.ca 

** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public License as published by the
** Free Software Foundation; either version 2 of the License, or (at your
** option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
** Public License for more details.
** 
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
**
****************************************************************************/

#include <QtGui>
#include "window.h"


# include <QString>
# include <QStringList>

Window::Window(QWidget *parent)
    : QMainWindow(parent)
{
    setupUi(this);

    scaleFactors << 1. << 1.1 << 1.25 << 1.75 << 2.5 << 4.;

    documentWidget = new DocumentWidget();
    scrollAreaWidget->setWidget(documentWidget);
    fsw = new QFileSystemWatcher();
    sb = statusBar();
    versionWidget = new QLabel(QString("This is vprerex, v.%1        ").arg(version), this);
    sb->addPermanentWidget(versionWidget);

    connect(documentControlsAction, SIGNAL(toggled(bool)),
            controlsDockWidget, SLOT(setVisible(bool)));

    connect(pageSpinBox, SIGNAL(valueChanged(int)),
            documentWidget, SLOT(setPage(int)));
    connect(documentWidget, SIGNAL(pageChanged(int)),
            pageSpinBox, SLOT(setValue(int)));
    connect(scaleComboBox, SIGNAL(currentIndexChanged(int)),
            this, SLOT(scaleDocument(int)));


    connect(fsw, SIGNAL(fileChanged(QString)), 
            documentWidget, SLOT(reloadDocument1()));
    connect(documentWidget, SIGNAL(documentReloaded()),
            this, SLOT(reloadMessage()));
    connect(quitButton, SIGNAL(clicked()), this, SLOT(quit()));

}

void Window::setFileNames(QString FileName, QString ChartFileName )
{
  fileName.append(FileName);
  fileInfo.setFile(FileName);
  chartFileName.append(ChartFileName);
  loadDocument();
}

void Window::open()
{
   QString fullFileName;
   fullFileName.append(QDir::cleanPath(QFileDialog::getOpenFileName(this, "Select a prerex file to edit or a pdf file to view.", QString(), "Prerex source files (*.tex);;Portable Document Format files (*.pdf)")));
   if (fullFileName.isNull()) 
   { 
     QMessageBox::critical(this, "Qtprerex", "File selection failed.");
     close();
     exit(1);
   }
   fileInfo.setFile(fullFileName);
// user can specify a separate "chartFile" by using two command-line arguments  
   fileName.append(fileInfo.baseName());
   fileName.append(".");
   fileName.append(fileInfo.suffix());
   loadDocument();
}

void Window::loadDocument(void)
{
   pdfFilePath.append(fileInfo.baseName());
   pdfFilePath.append(".pdf");
   if (fileName.endsWith(".tex"))
   {
     QStringList arguments;
     process = new QProcess(centralwidget);
     if ( chartFileName.length() > 0 )
       arguments << QString("-geometry") << QString("100x60") << QString("-fa") << QString("Monospace") << QString("-e") << QString("prerex") << fileName << chartFileName;
     else
       arguments << QString("-geometry") << QString("100x60") << QString("-fa") << QString("Monospace") << QString("-e") << QString("prerex") << fileName;
     process->start(QString("xterm"), arguments);  
   }

   QFileInfo pdfFileInfo;
   pdfFileInfo.setFile(pdfFilePath);
   while ( pdfFileInfo.size() == 0 ) 
   { // wait for the PDF file 
        sleep (1);
        pdfFileInfo.refresh();
   }
   sleep (2);
   sb->showMessage(pdfFilePath);
   fsw->addPath(pdfFilePath);
   while ( !(documentWidget->setDocument(pdfFilePath)) ) 
   { // if at first you don't succeed, try, try again 
     sleep (1);
   }    
   scaleComboBox->setEnabled(true);
   pageSpinBox->setEnabled(true);
   pageSpinBox->setMinimum(1);
   pageSpinBox->setMaximum(documentWidget->document()->numPages());
   pageSpinBox->setValue(1);


}

void Window::reloadMessage(void)
{
  sb->showMessage(pdfFilePath + " reloaded.", 2000);
  QTimer::singleShot(2000, this, SLOT(pathMessage()));
}

void Window::pathMessage(void)
{
  sb->showMessage(pdfFilePath);
}

void Window::scaleDocument(int index)
{
    documentWidget->setScale(scaleFactors[index]);
}

void Window::quit(void)
{
  close();
}
