//
// Binder.cpp
//
// $Id: //poco/1.3/Data/SQLite/src/Binder.cpp#2 $
//
// Library: SQLite
// Package: SQLite
// Module:  Binder
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/SQLite/Binder.h"
#include "Poco/Data/SQLite/Utility.h"
#include "Poco/Data/BLOB.h"
#include "Poco/Exception.h"
#include "sqlite3.h"
#include <cstdlib>


namespace Poco {
namespace Data {
namespace SQLite {


Binder::Binder(sqlite3_stmt* pStmt):
	_pStmt(pStmt)
{
}


Binder::~Binder()
{
}


void Binder::bind(std::size_t pos, const Poco::Int32 &val)
{
	int rc = sqlite3_bind_int(_pStmt, (int) pos, val);
	checkReturn(rc);
}


void Binder::bind(std::size_t pos, const Poco::Int64 &val)
{
	int rc = sqlite3_bind_int64(_pStmt, (int) pos, val);
	checkReturn(rc);
}


void Binder::bind(std::size_t pos, const double &val)
{
	int rc = sqlite3_bind_double(_pStmt, (int) pos, val);
	checkReturn(rc);
}


void Binder::bind(std::size_t pos, const std::string& val)
{
	int rc = sqlite3_bind_text(_pStmt, (int) pos, val.c_str(), (int) val.size()*sizeof(char), SQLITE_TRANSIENT);
	checkReturn(rc);
}


void Binder::bind(std::size_t pos, const Poco::Data::BLOB& val)
{
	// convert a blob to a an unsigned char* array
	const unsigned char* pData = reinterpret_cast<const unsigned char*>(val.rawContent());
	int valSize = static_cast<int>(val.size());

	int rc = sqlite3_bind_blob(_pStmt, static_cast<int>(pos), pData, valSize, SQLITE_STATIC); // no deep copy, do not free memory
	checkReturn(rc);
}


void Binder::checkReturn(int rc)
{
	if (rc != SQLITE_OK)
		Utility::throwException(rc);
}


} } } // namespace Poco::Data::SQLite
