/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file item_waiting_for_players.tpp
 * \brief Implementation of the ptb::item_waiting_for_players class.
 * \author Julien Jorge
 */

#include "ptb/game_variables.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
template<class Base>
ptb::item_waiting_for_players<Base>::item_waiting_for_players()
  : m_first_player(NULL), m_second_player(NULL)
{

} // item_waiting_for_players::item_waiting_for_players()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do one step in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
template<class Base>
void ptb::item_waiting_for_players<Base>::progress
( bear::universe::time_type elapsed_time )
{
  if (m_first_player != NULL)
    {
      if (game_variables::get_players_count()==2)
        {
          if (m_second_player != NULL)
            on_all_players(m_first_player, m_second_player);
          else
            on_one_player(m_first_player);
        }
      else
        on_all_players(m_first_player, NULL);
    }
  else if (m_second_player != NULL)
    on_one_player(m_second_player);

  m_first_player = NULL;
  m_second_player = NULL;
} // item_waiting_for_players::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called in a two players game, when only one player is colliding
 *        with the item.
 * \param p The player colliding with the item.
 */
template<class Base>
void ptb::item_waiting_for_players<Base>::on_one_player( plee* p )
{
  // nothing to do
} // item_waiting_for_players::on_one_player()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when all players are colliding with the item.
 * \param p1 The first player, colliding with the item.
 * \param p2 The second player, colliding with the item. In single player games,
 *        this pointer is NULL.
 */
template<class Base>
void ptb::item_waiting_for_players<Base>::on_all_players( plee* p1, plee* p2 )
{
  // nothing to do
} // item_waiting_for_players::on_all_players()

/*----------------------------------------------------------------------------*/
/**
 * \brief Collision with an other item.
 * \param that The other item of the collision.
 * \param info Some informations about the collision.
 */
template<class Base>
void ptb::item_waiting_for_players<Base>::collision
( bear::engine::base_item& that, bear::universe::collision_info& info )
{
  plee* p = dynamic_cast<plee*>(&that);

  if ( p != NULL )
    {
      if ( p->get_index() == 1 )
        m_first_player = p;
      else
        m_second_player = p;
    }
} // item_waiting_for_players::collision()
