/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file small_honeypot.cpp
 * \brief Implementation of the ptb::small_honeypot class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/small_honeypot.hpp"

#include "universe/collision_info.hpp"
#include "generic_items/decorative_item.hpp"
#include "ptb/item/plee/plee.hpp"
#include "engine/game.hpp"

#include "engine/export.hpp"

BASE_ITEM_EXPORT( small_honeypot, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
ptb::small_honeypot::small_honeypot()
{
  set_mass(1);
  set_width(15);
  set_height(15);
  set_elasticity(0.2);
} // small_honeypot::small_honeypot()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void ptb::small_honeypot::build()
{
  super::build();

  switch(get_type())
    {
    case fire_power:
      set_animation
	( get_level_globals().get_animation
	  ("animation/powerup/small_fire.canim") );
      break;
    case air_power:
      set_animation
	( get_level_globals().get_animation
	  ("animation/powerup/small_air.canim") );
      break;
    case water_power:
      set_animation
	( get_level_globals().get_animation
	  ("animation/powerup/small_water.canim") );
      break;
    default:
      {
        CLAW_ASSERT( false, 
		     "'unknown_type' is not a valid power for this class." );
      }
    } 
} // small_honeypot::build()
 
/*----------------------------------------------------------------------------*/
/**
 * \brief Check if the collision is with a player.
 * \param that The other item of the collision.
 * \param info Some informations about the collision.
 */
void ptb::small_honeypot::collision_check_and_apply
( bear::engine::base_item& that, bear::universe::collision_info& info )
{
  plee* p = dynamic_cast<plee*>(&that);
  
  if ( p != NULL )
    {
      if ( ! get_bonus_given() &&
           ( info.get_collision_side() != bear::universe::zone::middle_zone ) )
        give_bonus(p);
    }
} // small_honeypot::collision_check_and_apply()

/*----------------------------------------------------------------------------*/
/**
 * \brief Call collision_check_and_apply().
 * \param that The other item of the collision.
 * \param info Some informations about the collision.
 */
void ptb::small_honeypot::collision
( bear::engine::base_item& that, bear::universe::collision_info& info )
{
  collision_check_and_apply(that, info);
} // small_honeypot::collision()
