/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_game_options.hpp
 * \brief This frame is shown to choose the game_options parameters.
 * \author Julien Jorge
 */
#ifndef __PTB_FRAME_GAME_OPTIONS_HPP__
#define __PTB_FRAME_GAME_OPTIONS_HPP__

#include "ptb/frame/frame.hpp"
#include "ptb/frame/button.hpp"
#include "gui/checkbox.hpp"
#include "gui/picture.hpp"
#include "gui/static_text.hpp"

namespace ptb
{
  /**
   * \brief This frame is shown to configure miscellaneous game options.
   * \author Julien Jorge
   */
  class frame_game_options:
    public frame
  {
  private:
    /** \brief The control next to the cursor. */
    enum cursor_position
      {
        cursor_friendly_fire,
        cursor_ok,
        cursor_cancel
      }; // enum cursor_position

    typedef button< bear::gui::static_text,
                    std::mem_fun_t<bool, frame_game_options> > button_with_text;

  public:
    frame_game_options( windows_layer* in_layer );

  private:
    bool on_key_press( const bear::input::key_info& key );
    bool on_button_press( bear::input::joystick::joy_code button,
                          unsigned int joy_index );
    bool on_mouse_press( bear::input::mouse::mouse_code key,
                         const claw::math::coordinate_2d<unsigned int>& pos );
    bool on_mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

    void validate();

    void create_controls();
    void create_checkbox( bear::gui::static_text::font_type f );
    void create_ok_cancel( bear::gui::static_text::font_type f );

    void save();

    bool on_ok();
    bool on_cancel();
    bool on_up();
    bool on_down();
    bool on_left();
    bool on_right();

    void position_cursor();

  private:
    /** \brief The cursor. */
    bear::gui::picture* m_cursor;

    /** \brief The "friendly fire" checkbox. */
    bear::gui::checkbox* m_friendly_fire;

    /** \brief The "Ok" button. */
    button_with_text* m_ok;

    /** \brief 'Cancel' button. */
    button_with_text* m_cancel;

    /** \brief The position of the cursor. */
    cursor_position m_cursor_position;

    /** \brief The size of the margins between controls. */
    static const unsigned int s_margin;

  }; // class frame_game_options
} // namespace ptb

#endif // __PTB_FRAME_GAME_OPTIONS_HPP__
