;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../common.scm")

(let ( (image_name "floating-log.xcf.bz2")
       (dest_name "floating-log.png") )
  (let ( (src_image (car (gimp-file-load 1 image_name image_name)))
         (dest_image (car (gimp-image-new 256 256 RGB)))
         )
    (let ( (bk (car (gimp-layer-new dest_image 256 256 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    ( create-layer-crop src_image '(0 1 2 3 4 5 6 7 8 9)
                        82 18 253 206
                         0  0 127 103 dest_image '() )
    ( create-layer-crop src_image '(0 1 2 3     6 7 8 9)
                        82  18 253 206
                         0 103 127 103 dest_image '() )
    ( create-layer-crop src_image '(        4 5 6 7 8 9)
                         93 94 242 130
                        127  0 121  65 dest_image '() )
    ( create-layer-crop src_image '(            6 7 8 9)
                         93 113 242 111
                        127  65 121  56 dest_image '() )
    
    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let

