/*
    Bear Engine - Editor library

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/animation_file_edit.hpp
 * \brief Control for editing a field whose value is a path to an animation.
 * \author Julien Jorge
 */
#ifndef __BF_ANIMATION_FILE_EDIT_HPP__
#define __BF_ANIMATION_FILE_EDIT_HPP__

#include "bf/base_file_edit.hpp"
#include "bf/custom_type.hpp"
#include "bf/libeditor_export.hpp"

namespace bf
{
  /**
   * \brief Control for editing a field whose value is a path to an animation.
   * \author Julien Jorge
   */
  class BEAR_EDITOR_EXPORT animation_file_edit:
    public base_file_edit<animation_file_type>
  {
  private:
    typedef base_file_edit<animation_file_type> super;

  public:
    animation_file_edit
    ( wxWindow& parent,
      const animation_file_type& v =
      default_value<animation_file_type>::get() );

  }; // class animation_file_edit
} // namespace bf

#endif // __BF_ANIMATION_FILE_EDIT_HPP__
