/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file picture.hpp
 * \brief A simple component to display an image (sprite) in windows or any
 *        visual component.
 * \author Julien Jorge
 */
#ifndef __GUI_PICTURE_HPP__
#define __GUI_PICTURE_HPP__

#include "gui/visual_component.hpp"
#include "visual/sprite.hpp"

#include "gui/class_export.hpp"

namespace bear
{
  namespace gui
  {
    /**
     * \brief A simple component to display an image (sprite) in windows or any
     *        visual component.
     * \author Julien Jorge
     */
    class GUI_EXPORT picture : public visual_component
    {
    public:
      picture( visual_component* owner, visual::sprite* pict = NULL );
      ~picture();

      void set_picture( visual::sprite* pict );
      void set_stretch( bool b );

    private:
      void display( scene_element_list& e ) const;

      virtual void on_resized();

    private:
      /** \brief The sprite to render. */
      visual::sprite* m_sprite;

      /** \brief Tell if the sprite is stretched to fill the control. */
      bool m_stretch;

    }; // class picture
  } // namespace gui
} // namespace bear

#endif // __GUI_PICTURE_HPP__
