/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file checkbox.hpp
 * \brief A checkbox with a text.
 * \author Julien Jorge
 */
#ifndef __GUI_CHECKBOX_HPP__
#define __GUI_CHECKBOX_HPP__

#include "gui/static_text.hpp"
#include "gui/class_export.hpp"

#include "visual/sprite.hpp"

namespace bear
{
  namespace gui
  {
    /**
     * \brief A checkbox with a text.
     * \author Julien Jorge
     */
    class GUI_EXPORT checkbox:
      public visual_component
    {
    public:
      /** \brief The type of the font used to display the text. */
      typedef static_text::font_type font_type;

    public:
      checkbox( visual_component* owner, const visual::sprite& off,
                const visual::sprite& on );
      checkbox( visual_component* owner, const visual::sprite& off,
                const visual::sprite& on, font_type f );

      void set_font( font_type f );
      void set_text( const std::string& text );
      void check( bool b = true );
      void toggle_value();

      const std::string& get_text() const;
      bool checked() const;

    private:
      void display( scene_element_list& e ) const;

      void create();
      void fit();

    private:
      /** \brief The text to draw. */
      static_text* m_text;

      /** \brief Tell if the box is checked or not. */
      bool m_checked;

      /** \brief The sprite displayed when the box is not checked. */
      const visual::sprite m_off;

      /** \brief The sprite displayed when the box is checked. */
      const visual::sprite m_on;

    }; // class checkbox
  } // namespace gui
} // namespace bear

#endif // __GUI_CHECKBOX_HPP__
