/*
	 pingpong - Really free server for Amateur Radio convers
	 Copyright (C) 2005 Joop Stakenborg <pg4i@amsat.org>

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2, or (at your option)
	 any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; if not, write to the Free Software Foundation,
	 Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	
*/

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "pingpong.h"
#include "init.h"

typedef struct
{
	gchar *servername;
	gint port;
	gint defaultchannel;
} prefs;

prefs setting;

gint readconf(gchar *filename)
{
	gboolean conf_exist = TRUE;
	FILE *fp;
	gchar label[1024], value[1024];
	GString *confline = g_string_new("");
	gint c;

	/* first some defaults */
	setting.servername = g_strdup("UNKNOWN");
	setting.port = 3600;
	setting.defaultchannel = 45;

	/* read pingpong.conf */
	if ((fp = fopen(filename, "r")) == NULL) conf_exist = FALSE;
	if (conf_exist)
	{
		while((c = fgetc(fp)) != EOF)
		{
			confline = g_string_append_c(confline, c);
			if (c == '\n')
			{
				if (g_strncasecmp(confline->str, "#", 1) != 0 && 
						g_strncasecmp(confline->str, "\n", 1) != 0 && 
						confline->len < 1024)
				{
					sscanf(confline->str, "%s %s", label, value);
					if (g_strcasecmp(label, "servername") == 0)
						setting.servername = g_strdup(value);
					else if (g_strcasecmp(label, "port") == 0)
						setting.port = atoi(value);
					else if (g_strcasecmp(label, "defaultchannel") == 0)
						setting.defaultchannel = atoi(value);
				}
				confline = g_string_new("");
			}
		}
	fclose(fp);
	}
	g_string_free(confline, TRUE);
	return (setting.port);
}

gchar *getservername()
{
	return (setting.servername);
}

gint getdefaultchannel()
{
	return (setting.defaultchannel);
}
