<?php
/**
 * This file contains a mapping of common file extensions to
 * MIME types. It has been automatically generated from the
 * horde-support/maintainer-tools/mime_mapping directory.
 *
 * ALL changes should be made to
 * horde-support/maintainer-tools/mime_mapping/mime.types.horde or else they
 * they will be lost when this file is regenerated.
 *
 * Any unknown file extensions will automatically be mapped to
 * 'x-extension/<ext>' where <ext> is the unknown file extension.
 *
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package  Mime
 *
 * Generated: 02/09/10 13:08:53 by slusarz on bigworm.curecanti.org
 */
$mime_extension_map = array(
    '__MAXPERIOD__' => '1',
    '3dml'          => 'text/vnd.in3d.3dml',
    '3ds'           => 'image/x-3ds',
    '3g2'           => 'video/3gpp',
    '3ga'           => 'video/3gpp',
    '3gp'           => 'video/3gpp',
    '3gpp'          => 'video/3gpp',
    '7z'            => 'application/x-7z-compressed',
    'BLEND'         => 'application/x-blender',
    'C'             => 'text/x-c++src',
    'CSSL'          => 'text/css',
    'PAR2'          => 'application/x-par2',
    'Z'             => 'application/x-compress',
    'a'             => 'application/x-archive',
    'aab'           => 'application/x-authorware-bin',
    'aac'           => 'audio/mp4',
    'aam'           => 'application/x-authorware-map',
    'aas'           => 'application/x-authorware-seg',
    'abw'           => 'application/x-abiword',
    'abw.CRASHED'   => 'application/x-abiword',
    'abw.gz'        => 'application/x-abiword',
    'ac3'           => 'audio/ac3',
    'acc'           => 'application/vnd.americandynamics.acc',
    'ace'           => 'application/x-ace',
    'acu'           => 'application/vnd.acucobol',
    'acutc'         => 'application/vnd.acucorp',
    'adb'           => 'text/x-adasrc',
    'adp'           => 'audio/adpcm',
    'ads'           => 'text/x-adasrc',
    'aep'           => 'application/vnd.audiograph',
    'afm'           => 'application/x-font-afm',
    'afp'           => 'application/vnd.ibm.modcap',
    'ag'            => 'image/x-applix-graphics',
    'ai'            => 'application/illustrator',
    'aif'           => 'audio/x-aiff',
    'aifc'          => 'audio/x-aiff',
    'aiff'          => 'audio/x-aiff',
    'air'           => 'application/vnd.adobe.air-application-installer-package+zip',
    'al'            => 'application/x-perl',
    'alz'           => 'application/x-alz',
    'ami'           => 'application/vnd.amiga.ami',
    'amr'           => 'audio/AMR',
    'ani'           => 'application/x-navi-animation',
    'anx'           => 'application/annodex',
    'ape'           => 'audio/x-ape',
    'apk'           => 'application/vnd.android.package-archive',
    'application'   => 'application/x-ms-application',
    'apr'           => 'application/vnd.lotus-approach',
    'arj'           => 'application/x-arj',
    'arw'           => 'image/x-sony-arw',
    'as'            => 'application/x-applix-spreadsheet',
    'asc'           => 'text/plain',
    'asf'           => 'video/x-ms-asf',
    'asm'           => 'text/x-asm',
    'aso'           => 'application/vnd.accpac.simply.aso',
    'asp'           => 'application/x-asp',
    'ass'           => 'text/x-ssa',
    'asx'           => 'audio/x-ms-asx',
    'atc'           => 'application/vnd.acucorp',
    'atom'          => 'application/atom+xml',
    'atomcat'       => 'application/atomcat+xml',
    'atomsvc'       => 'application/atomsvc+xml',
    'atx'           => 'application/vnd.antix.game-component',
    'au'            => 'audio/basic',
    'avi'           => 'video/x-msvideo',
    'aw'            => 'application/x-applix-word',
    'awb'           => 'audio/AMR-WB',
    'awk'           => 'application/x-awk',
    'axa'           => 'audio/annodex',
    'axv'           => 'video/annodex',
    'azf'           => 'application/vnd.airzip.filesecure.azf',
    'azs'           => 'application/vnd.airzip.filesecure.azs',
    'azw'           => 'application/vnd.amazon.ebook',
    'bak'           => 'application/x-trash',
    'bat'           => 'application/x-msdownload',
    'bcpio'         => 'application/x-bcpio',
    'bdf'           => 'application/x-font-bdf',
    'bdm'           => 'application/vnd.syncml.dm+wbxml',
    'bed'           => 'application/vnd.realvnc.bed',
    'bh2'           => 'application/vnd.fujitsu.oasysprs',
    'bib'           => 'text/x-bibtex',
    'bin'           => 'application/octet-stream',
    'blend'         => 'application/x-blender',
    'blender'       => 'application/x-blender',
    'bmi'           => 'application/vnd.bmi',
    'bmp'           => 'image/bmp',
    'book'          => 'application/vnd.framemaker',
    'box'           => 'application/vnd.previewsystems.box',
    'boz'           => 'application/x-bzip2',
    'bpk'           => 'application/octet-stream',
    'btif'          => 'image/prs.btif',
    'bz'            => 'application/x-bzip',
    'bz2'           => 'application/x-bzip',
    'c'             => 'text/x-csrc',
    'c++'           => 'text/x-c++src',
    'c4d'           => 'application/vnd.clonk.c4group',
    'c4f'           => 'application/vnd.clonk.c4group',
    'c4g'           => 'application/vnd.clonk.c4group',
    'c4p'           => 'application/vnd.clonk.c4group',
    'c4u'           => 'application/vnd.clonk.c4group',
    'cab'           => 'application/vnd.ms-cab-compressed',
    'car'           => 'application/vnd.curl.car',
    'cat'           => 'application/vnd.ms-pki.seccat',
    'cb7'           => 'application/x-cb7',
    'cbr'           => 'application/x-cbr',
    'cbt'           => 'application/x-cbt',
    'cbz'           => 'application/x-cbz',
    'cc'            => 'text/x-c++src',
    'cct'           => 'application/x-director',
    'ccxml'         => 'application/ccxml+xml',
    'cdbcmsg'       => 'application/vnd.contact.cmsg',
    'cdf'           => 'application/x-netcdf',
    'cdkey'         => 'application/vnd.mediastation.cdkey',
    'cdr'           => 'application/vnd.corel-draw',
    'cdx'           => 'chemical/x-cdx',
    'cdxml'         => 'application/vnd.chemdraw+xml',
    'cdy'           => 'application/vnd.cinderella',
    'cer'           => 'application/pkix-cert',
    'cert'          => 'application/x-x509-ca-cert',
    'cgm'           => 'image/cgm',
    'chat'          => 'application/x-chat',
    'chm'           => 'application/x-chm',
    'chrt'          => 'application/x-kchart',
    'cif'           => 'chemical/x-cif',
    'cii'           => 'application/vnd.anser-web-certificate-issue-initiation',
    'cil'           => 'application/vnd.ms-artgalry',
    'cla'           => 'application/vnd.claymore',
    'class'         => 'application/x-java',
    'clkk'          => 'application/vnd.crick.clicker.keyboard',
    'clkp'          => 'application/vnd.crick.clicker.palette',
    'clkt'          => 'application/vnd.crick.clicker.template',
    'clkw'          => 'application/vnd.crick.clicker.wordbank',
    'clkx'          => 'application/vnd.crick.clicker',
    'clp'           => 'application/x-msclip',
    'cls'           => 'text/x-tex',
    'cmake'         => 'text/x-cmake',
    'cmc'           => 'application/vnd.cosmocaller',
    'cmdf'          => 'chemical/x-cmdf',
    'cml'           => 'chemical/x-cml',
    'cmp'           => 'application/vnd.yellowriver-custom-menu',
    'cmx'           => 'image/x-cmx',
    'cod'           => 'application/vnd.rim.cod',
    'com'           => 'application/x-msdownload',
    'conf'          => 'text/plain',
    'cpio'          => 'application/x-cpio',
    'cpio.gz'       => 'application/x-cpio-compressed',
    'cpp'           => 'text/x-c++src',
    'cpt'           => 'application/mac-compactpro',
    'cr2'           => 'image/x-canon-cr2',
    'crd'           => 'application/x-mscardfile',
    'crl'           => 'application/pkix-crl',
    'crt'           => 'application/x-x509-ca-cert',
    'crw'           => 'image/x-canon-crw',
    'cs'            => 'text/x-csharp',
    'csh'           => 'application/x-csh',
    'csml'          => 'chemical/x-csml',
    'csp'           => 'application/vnd.commonspace',
    'css'           => 'text/css',
    'cst'           => 'application/x-director',
    'csv'           => 'text/csv',
    'cu'            => 'application/cu-seeme',
    'cue'           => 'application/x-cue',
    'cur'           => 'image/x-win-bitmap',
    'curl'          => 'text/vnd.curl',
    'cww'           => 'application/prs.cww',
    'cxt'           => 'application/x-director',
    'cxx'           => 'text/x-c++src',
    'd'             => 'text/x-dsrc',
    'daf'           => 'application/vnd.mobius.daf',
    'dar'           => 'application/x-dar',
    'dataless'      => 'application/vnd.fdsn.seed',
    'davmount'      => 'application/davmount+xml',
    'dbf'           => 'application/x-dbf',
    'dc'            => 'application/x-dc-rom',
    'dcl'           => 'text/x-dcl',
    'dcm'           => 'application/dicom',
    'dcr'           => 'image/x-kodak-dcr',
    'dcurl'         => 'text/vnd.curl.dcurl',
    'dd2'           => 'application/vnd.oma.dd2+xml',
    'ddd'           => 'application/vnd.fujixerox.ddd',
    'dds'           => 'image/x-dds',
    'deb'           => 'application/x-deb',
    'def'           => 'text/plain',
    'deploy'        => 'application/octet-stream',
    'der'           => 'application/x-x509-ca-cert',
    'desktop'       => 'application/x-desktop',
    'dfac'          => 'application/vnd.dreamfactory',
    'dia'           => 'application/x-dia-diagram',
    'dic'           => 'text/x-c',
    'diff'          => 'text/x-patch',
    'dir'           => 'application/x-director',
    'dis'           => 'application/vnd.mobius.dis',
    'dist'          => 'application/octet-stream',
    'distz'         => 'application/octet-stream',
    'divx'          => 'video/x-msvideo',
    'djv'           => 'image/vnd.djvu',
    'djvu'          => 'image/vnd.djvu',
    'dll'           => 'application/x-msdownload',
    'dmg'           => 'application/octet-stream',
    'dms'           => 'application/octet-stream',
    'dna'           => 'application/vnd.dna',
    'dng'           => 'image/x-adobe-dng',
    'doc'           => 'application/msword',
    'docbook'       => 'application/docbook+xml',
    'docm'          => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'docx'          => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'dot'           => 'text/vnd.graphviz',
    'dotm'          => 'application/vnd.ms-word.template.macroenabled.12',
    'dotx'          => 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
    'dp'            => 'application/vnd.osgi.dp',
    'dpg'           => 'application/vnd.dpgraph',
    'dra'           => 'audio/vnd.dra',
    'dsc'           => 'text/prs.lines.tag',
    'dsl'           => 'text/x-dsl',
    'dssc'          => 'application/dssc+der',
    'dtb'           => 'application/x-dtbook+xml',
    'dtd'           => 'application/xml-dtd',
    'dts'           => 'audio/vnd.dts',
    'dtshd'         => 'audio/vnd.dts.hd',
    'dtx'           => 'text/x-tex',
    'dump'          => 'application/octet-stream',
    'dv'            => 'video/dv',
    'dvi'           => 'application/x-dvi',
    'dvi.bz2'       => 'application/x-bzdvi',
    'dvi.gz'        => 'application/x-gzdvi',
    'dwf'           => 'model/vnd.dwf',
    'dwg'           => 'image/vnd.dwg',
    'dxf'           => 'image/vnd.dxf',
    'dxp'           => 'application/vnd.spotfire.dxp',
    'dxr'           => 'application/x-director',
    'e'             => 'text/x-eiffel',
    'ecelp4800'     => 'audio/vnd.nuera.ecelp4800',
    'ecelp7470'     => 'audio/vnd.nuera.ecelp7470',
    'ecelp9600'     => 'audio/vnd.nuera.ecelp9600',
    'ecma'          => 'application/ecmascript',
    'edm'           => 'application/vnd.novadigm.edm',
    'edx'           => 'application/vnd.novadigm.edx',
    'efif'          => 'application/vnd.picsel',
    'egon'          => 'application/x-egon',
    'ei6'           => 'application/vnd.pg.osasli',
    'eif'           => 'text/x-eiffel',
    'el'            => 'text/x-emacs-lisp',
    'elc'           => 'application/octet-stream',
    'emf'           => 'image/x-emf',
    'eml'           => 'message/rfc822',
    'emma'          => 'application/emma+xml',
    'emp'           => 'application/vnd.emusic-emusic_package',
    'ent'           => 'application/xml-external-parsed-entity',
    'eol'           => 'audio/vnd.digital-winds',
    'eot'           => 'application/vnd.ms-fontobject',
    'eps'           => 'image/x-eps',
    'eps.bz2'       => 'image/x-bzeps',
    'eps.gz'        => 'image/x-gzeps',
    'epsf'          => 'image/x-eps',
    'epsf.bz2'      => 'image/x-bzeps',
    'epsf.gz'       => 'image/x-gzeps',
    'epsi'          => 'image/x-eps',
    'epsi.bz2'      => 'image/x-bzeps',
    'epsi.gz'       => 'image/x-gzeps',
    'epub'          => 'application/epub+zip',
    'erl'           => 'text/x-erlang',
    'es'            => 'application/ecmascript',
    'es3'           => 'application/vnd.eszigno3+xml',
    'esf'           => 'application/vnd.epson.esf',
    'et3'           => 'application/vnd.eszigno3+xml',
    'etheme'        => 'application/x-e-theme',
    'etx'           => 'text/x-setext',
    'exe'           => 'application/x-ms-dos-executable',
    'exr'           => 'image/x-exr',
    'ext'           => 'application/vnd.novadigm.ext',
    'ez'            => 'application/andrew-inset',
    'ez2'           => 'application/vnd.ezpix-album',
    'ez3'           => 'application/vnd.ezpix-package',
    'f'             => 'text/x-fortran',
    'f4v'           => 'video/x-f4v',
    'f77'           => 'text/x-fortran',
    'f90'           => 'text/x-fortran',
    'f95'           => 'text/x-fortran',
    'fb2'           => 'application/x-fictionbook+xml',
    'fbs'           => 'image/vnd.fastbidsheet',
    'fdf'           => 'application/vnd.fdf',
    'fe_launch'     => 'application/vnd.denovo.fcselayout-link',
    'fg5'           => 'application/vnd.fujitsu.oasysgp',
    'fgd'           => 'application/x-director',
    'fh'            => 'image/x-freehand',
    'fh4'           => 'image/x-freehand',
    'fh5'           => 'image/x-freehand',
    'fh7'           => 'image/x-freehand',
    'fhc'           => 'image/x-freehand',
    'fig'           => 'image/x-xfig',
    'fits'          => 'image/fits',
    'fl'            => 'application/x-fluid',
    'flac'          => 'audio/x-flac',
    'flc'           => 'video/x-flic',
    'fli'           => 'video/x-flic',
    'flo'           => 'application/vnd.micrografx.flo',
    'flv'           => 'video/x-flv',
    'flw'           => 'application/x-kivio',
    'flx'           => 'text/vnd.fmi.flexstor',
    'fly'           => 'text/vnd.fly',
    'fm'            => 'application/vnd.framemaker',
    'fnc'           => 'application/vnd.frogans.fnc',
    'fo'            => 'text/x-xslfo',
    'fodg'          => 'application/vnd.oasis.opendocument.graphics-flat-xml',
    'fodp'          => 'application/vnd.oasis.opendocument.presentation-flat-xml',
    'fods'          => 'application/vnd.oasis.opendocument.spreadsheet-flat-xml',
    'fodt'          => 'application/vnd.oasis.opendocument.text-flat-xml',
    'for'           => 'text/x-fortran',
    'fpx'           => 'image/vnd.fpx',
    'frame'         => 'application/vnd.framemaker',
    'fsc'           => 'application/vnd.fsc.weblaunch',
    'fst'           => 'image/vnd.fst',
    'ftc'           => 'application/vnd.fluxtime.clip',
    'fti'           => 'application/vnd.anser-web-funds-transfer-initiation',
    'fvt'           => 'video/vnd.fvt',
    'fzs'           => 'application/vnd.fuzzysheet',
    'g2w'           => 'application/vnd.geoplan',
    'g3'            => 'image/fax-g3',
    'g3w'           => 'application/vnd.geospace',
    'gac'           => 'application/vnd.groove-account',
    'gb'            => 'application/x-gameboy-rom',
    'gba'           => 'application/x-gba-rom',
    'gcrd'          => 'text/directory',
    'gdl'           => 'model/vnd.gdl',
    'ged'           => 'application/x-gedcom',
    'gedcom'        => 'application/x-gedcom',
    'gen'           => 'application/x-genesis-rom',
    'geo'           => 'application/vnd.dynageo',
    'gex'           => 'application/vnd.geometry-explorer',
    'gf'            => 'application/x-tex-gf',
    'gg'            => 'application/x-sms-rom',
    'ggb'           => 'application/vnd.geogebra.file',
    'ggt'           => 'application/vnd.geogebra.tool',
    'ghf'           => 'application/vnd.groove-help',
    'gif'           => 'image/gif',
    'gim'           => 'application/vnd.groove-identity-message',
    'glade'         => 'application/x-glade',
    'gmo'           => 'application/x-gettext-translation',
    'gmx'           => 'application/vnd.gmx',
    'gnc'           => 'application/x-gnucash',
    'gnd'           => 'application/gnunet-directory',
    'gnucash'       => 'application/x-gnucash',
    'gnumeric'      => 'application/x-gnumeric',
    'gnuplot'       => 'application/x-gnuplot',
    'gp'            => 'application/x-gnuplot',
    'gpg'           => 'application/pgp-encrypted',
    'gph'           => 'application/vnd.flographit',
    'gplt'          => 'application/x-gnuplot',
    'gqf'           => 'application/vnd.grafeq',
    'gqs'           => 'application/vnd.grafeq',
    'gra'           => 'application/x-graphite',
    'gram'          => 'application/srgs',
    'gre'           => 'application/vnd.geometry-explorer',
    'grv'           => 'application/vnd.groove-injector',
    'grxml'         => 'application/srgs+xml',
    'gsf'           => 'application/x-font-type1',
    'gsm'           => 'audio/x-gsm',
    'gtar'          => 'application/x-tar',
    'gtm'           => 'application/vnd.groove-tool-message',
    'gtw'           => 'model/vnd.gtw',
    'gv'            => 'text/vnd.graphviz',
    'gvp'           => 'text/x-google-video-pointer',
    'gxt'           => 'application/vnd.geonext',
    'gz'            => 'application/x-gzip',
    'h'             => 'text/x-chdr',
    'h++'           => 'text/x-c++hdr',
    'h261'          => 'video/h261',
    'h263'          => 'video/h263',
    'h264'          => 'video/h264',
    'hbci'          => 'application/vnd.hbci',
    'hdf'           => 'application/x-hdf',
    'hh'            => 'text/x-c++hdr',
    'hlp'           => 'application/winhlp',
    'hp'            => 'text/x-c++hdr',
    'hpgl'          => 'application/vnd.hp-hpgl',
    'hpid'          => 'application/vnd.hp-hpid',
    'hpp'           => 'text/x-c++hdr',
    'hps'           => 'application/vnd.hp-hps',
    'hqx'           => 'application/mac-binhex40',
    'hs'            => 'text/x-haskell',
    'htke'          => 'application/vnd.kenameaapp',
    'htm'           => 'text/html',
    'html'          => 'text/html',
    'hvd'           => 'application/vnd.yamaha.hv-dic',
    'hvp'           => 'application/vnd.yamaha.hv-voice',
    'hvs'           => 'application/vnd.yamaha.hv-script',
    'hwp'           => 'application/x-hwp',
    'hwt'           => 'application/x-hwt',
    'hxx'           => 'text/x-c++hdr',
    'ica'           => 'application/x-ica',
    'icb'           => 'image/x-tga',
    'icc'           => 'application/vnd.iccprofile',
    'ice'           => 'x-conference/x-cooltalk',
    'icm'           => 'application/vnd.iccprofile',
    'icns'          => 'image/x-icns',
    'ico'           => 'image/vnd.microsoft.icon',
    'ics'           => 'text/calendar',
    'idl'           => 'text/x-idl',
    'ief'           => 'image/ief',
    'ifb'           => 'text/calendar',
    'iff'           => 'image/x-iff',
    'ifm'           => 'application/vnd.shana.informed.formdata',
    'iges'          => 'model/iges',
    'igl'           => 'application/vnd.igloader',
    'igs'           => 'model/iges',
    'igx'           => 'application/vnd.micrografx.igx',
    'iif'           => 'application/vnd.shana.informed.interchange',
    'ilbm'          => 'image/x-ilbm',
    'ime'           => 'text/x-iMelody',
    'imp'           => 'application/vnd.accpac.simply.imp',
    'ims'           => 'application/vnd.ms-ims',
    'imy'           => 'text/x-iMelody',
    'in'            => 'text/plain',
    'ins'           => 'text/x-tex',
    'ipfix'         => 'application/ipfix',
    'ipk'           => 'application/vnd.shana.informed.package',
    'iptables'      => 'text/x-iptables',
    'irm'           => 'application/vnd.ibm.rights-management',
    'irp'           => 'application/vnd.irepository.package+xml',
    'iso'           => 'application/x-cd-image',
    'iso9660'       => 'application/x-cd-image',
    'it'            => 'audio/x-it',
    'it87'          => 'application/x-it87',
    'itp'           => 'application/vnd.shana.informed.formtemplate',
    'ivp'           => 'application/vnd.immervision-ivp',
    'ivu'           => 'application/vnd.immervision-ivu',
    'j2k'           => 'image/jp2',
    'jad'           => 'text/vnd.sun.j2me.app-descriptor',
    'jam'           => 'application/vnd.jam',
    'jar'           => 'application/x-java-archive',
    'java'          => 'text/x-java',
    'jceks'         => 'application/x-java-jce-keystore',
    'jisp'          => 'application/vnd.jisp',
    'jks'           => 'application/x-java-keystore',
    'jlt'           => 'application/vnd.hp-jlyt',
    'jng'           => 'image/x-jng',
    'jnlp'          => 'application/x-java-jnlp-file',
    'joda'          => 'application/vnd.joost.joda-archive',
    'jp2'           => 'image/jp2',
    'jpc'           => 'image/jp2',
    'jpg'           => 'image/jpeg',
    'jpe'           => 'image/jpeg',
    'jpeg'          => 'image/jpeg',
    'jpf'           => 'image/jp2',
    'jpgm'          => 'video/jpm',
    'jpgv'          => 'video/jpeg',
    'jpm'           => 'video/jpm',
    'jpr'           => 'application/x-jbuilder-project',
    'jpx'           => 'image/jp2',
    'js'            => 'application/javascript',
    'json'          => 'application/json',
    'k25'           => 'image/x-kodak-k25',
    'kar'           => 'audio/midi',
    'karbon'        => 'application/x-karbon',
    'kdc'           => 'image/x-kodak-kdc',
    'kdelnk'        => 'application/x-desktop',
    'kexi'          => 'application/x-kexiproject-sqlite3',
    'kexic'         => 'application/x-kexi-connectiondata',
    'kexis'         => 'application/x-kexiproject-shortcut',
    'kfo'           => 'application/x-kformula',
    'kia'           => 'application/vnd.kidspiration',
    'kil'           => 'application/x-killustrator',
    'kino'          => 'application/smil',
    'kml'           => 'application/vnd.google-earth.kml+xml',
    'kmz'           => 'application/vnd.google-earth.kmz',
    'kne'           => 'application/vnd.kinar',
    'knp'           => 'application/vnd.kinar',
    'kon'           => 'application/x-kontour',
    'kpm'           => 'application/x-kpovmodeler',
    'kpr'           => 'application/x-kpresenter',
    'kpt'           => 'application/x-kpresenter',
    'kra'           => 'application/x-krita',
    'ks'            => 'application/x-java-keystore',
    'ksp'           => 'application/x-kspread',
    'ktr'           => 'application/vnd.kahootz',
    'ktz'           => 'application/vnd.kahootz',
    'kud'           => 'application/x-kugar',
    'kwd'           => 'application/x-kword',
    'kwt'           => 'application/x-kword',
    'la'            => 'application/x-shared-library-la',
    'latex'         => 'text/x-tex',
    'lbd'           => 'application/vnd.llamagraphics.life-balance.desktop',
    'lbe'           => 'application/vnd.llamagraphics.life-balance.exchange+xml',
    'ldif'          => 'text/x-ldif',
    'les'           => 'application/vnd.hhe.lesson-player',
    'lha'           => 'application/x-lha',
    'lhs'           => 'text/x-literate-haskell',
    'lhz'           => 'application/x-lhz',
    'link66'        => 'application/vnd.route66.link66+xml',
    'list'          => 'text/plain',
    'list3820'      => 'application/vnd.ibm.modcap',
    'listafp'       => 'application/vnd.ibm.modcap',
    'log'           => 'text/x-log',
    'lostxml'       => 'application/lost+xml',
    'lrf'           => 'application/octet-stream',
    'lrm'           => 'application/vnd.ms-lrm',
    'ltf'           => 'application/vnd.frogans.ltf',
    'ltx'           => 'text/x-tex',
    'lua'           => 'text/x-lua',
    'lvp'           => 'audio/vnd.lucent.voice',
    'lwo'           => 'image/x-lwo',
    'lwob'          => 'image/x-lwo',
    'lwp'           => 'application/vnd.lotus-wordpro',
    'lws'           => 'image/x-lws',
    'ly'            => 'text/x-lilypond',
    'lyx'           => 'application/x-lyx',
    'lz'            => 'application/x-lzip',
    'lzh'           => 'application/x-lha',
    'lzma'          => 'application/x-lzma',
    'lzo'           => 'application/x-lzop',
    'm'             => 'text/x-matlab',
    'm13'           => 'application/x-msmediaview',
    'm14'           => 'application/x-msmediaview',
    'm15'           => 'audio/x-mod',
    'm1v'           => 'video/mpeg',
    'm2a'           => 'audio/mpeg',
    'm2t'           => 'video/mpeg',
    'm2v'           => 'video/mpeg',
    'm3a'           => 'audio/mpeg',
    'm3u'           => 'application/vnd.apple.mpegurl',
    'm3u8'          => 'application/vnd.apple.mpegurl',
    'm4'            => 'application/x-m4',
    'm4a'           => 'audio/mp4',
    'm4b'           => 'audio/x-m4b',
    'm4u'           => 'video/vnd.mpegurl',
    'm4v'           => 'video/mp4',
    'ma'            => 'application/mathematica',
    'mab'           => 'application/x-markaby',
    'mag'           => 'application/vnd.ecowin.chart',
    'maker'         => 'application/vnd.framemaker',
    'man'           => 'application/x-troff-man',
    'mathml'        => 'application/mathml+xml',
    'mb'            => 'application/mathematica',
    'mbk'           => 'application/vnd.mobius.mbk',
    'mbox'          => 'application/mbox',
    'mc1'           => 'application/vnd.medcalcdata',
    'mcd'           => 'application/vnd.mcd',
    'mcurl'         => 'text/vnd.curl.mcurl',
    'md'            => 'application/x-genesis-rom',
    'mdb'           => 'application/vnd.ms-access',
    'mdi'           => 'image/vnd.ms-modi',
    'me'            => 'text/x-troff-me',
    'med'           => 'audio/x-mod',
    'mesh'          => 'model/mesh',
    'metalink'      => 'application/metalink+xml',
    'mfm'           => 'application/vnd.mfmp',
    'mgp'           => 'application/x-magicpoint',
    'mgz'           => 'application/vnd.proteus.magazine',
    'mid'           => 'audio/midi',
    'midi'          => 'audio/midi',
    'mif'           => 'application/x-mif',
    'mime'          => 'message/rfc822',
    'minipsf'       => 'audio/x-minipsf',
    'mj2'           => 'video/mj2',
    'mjp2'          => 'video/mj2',
    'mka'           => 'audio/x-matroska',
    'mkv'           => 'video/x-matroska',
    'ml'            => 'text/x-ocaml',
    'mli'           => 'text/x-ocaml',
    'mlp'           => 'application/vnd.dolby.mlp',
    'mm'            => 'text/x-troff-mm',
    'mmd'           => 'application/vnd.chipnuts.karaoke-mmd',
    'mmf'           => 'application/x-smaf',
    'mml'           => 'application/mathml+xml',
    'mmr'           => 'image/vnd.fujixerox.edmics-mmr',
    'mng'           => 'video/x-mng',
    'mny'           => 'application/x-msmoney',
    'mo'            => 'application/x-gettext-translation',
    'mo3'           => 'audio/x-mo3',
    'mobi'          => 'application/x-mobipocket-ebook',
    'moc'           => 'text/x-moc',
    'mod'           => 'audio/x-mod',
    'mof'           => 'text/x-mof',
    'moov'          => 'video/quicktime',
    'mov'           => 'video/quicktime',
    'movie'         => 'video/x-sgi-movie',
    'mp+'           => 'audio/x-musepack',
    'mp2'           => 'video/mpeg',
    'mp2a'          => 'audio/mpeg',
    'mp3'           => 'audio/mpeg',
    'mp4'           => 'video/mp4',
    'mp4a'          => 'audio/mp4',
    'mp4s'          => 'application/mp4',
    'mp4v'          => 'video/mp4',
    'mpc'           => 'audio/x-musepack',
    'mpe'           => 'video/mpeg',
    'mpeg'          => 'video/mpeg',
    'mpg'           => 'video/mpeg',
    'mpg4'          => 'video/mp4',
    'mpga'          => 'audio/mpeg',
    'mpkg'          => 'application/vnd.apple.installer+xml',
    'mpm'           => 'application/vnd.blueice.multipass',
    'mpn'           => 'application/vnd.mophun.application',
    'mpp'           => 'audio/x-musepack',
    'mpt'           => 'application/vnd.ms-project',
    'mpy'           => 'application/vnd.ibm.minipay',
    'mqy'           => 'application/vnd.mobius.mqy',
    'mrc'           => 'application/marc',
    'mrl'           => 'text/x-mrml',
    'mrml'          => 'text/x-mrml',
    'mrw'           => 'image/x-minolta-mrw',
    'ms'            => 'text/x-troff-ms',
    'mscml'         => 'application/mediaservercontrol+xml',
    'mseed'         => 'application/vnd.fdsn.mseed',
    'mseq'          => 'application/vnd.mseq',
    'msf'           => 'application/vnd.epson.msf',
    'msh'           => 'model/mesh',
    'msi'           => 'application/x-msi',
    'msl'           => 'application/vnd.mobius.msl',
    'msod'          => 'image/x-msod',
    'msty'          => 'application/vnd.muvee.style',
    'msx'           => 'application/x-msx-rom',
    'mtm'           => 'audio/x-mod',
    'mts'           => 'model/vnd.mts',
    'mup'           => 'text/x-mup',
    'mus'           => 'application/vnd.musician',
    'musicxml'      => 'application/vnd.recordare.musicxml+xml',
    'mvb'           => 'application/x-msmediaview',
    'mwf'           => 'application/vnd.mfer',
    'mxf'           => 'application/mxf',
    'mxl'           => 'application/vnd.recordare.musicxml',
    'mxml'          => 'application/xv+xml',
    'mxs'           => 'application/vnd.triscape.mxs',
    'mxu'           => 'video/vnd.mpegurl',
    'n-gage'        => 'application/vnd.nokia.n-gage.symbian.install',
    'n64'           => 'application/x-n64-rom',
    'nb'            => 'application/mathematica',
    'nbp'           => 'application/vnd.wolfram.player',
    'nc'            => 'application/x-netcdf',
    'ncx'           => 'application/x-dtbncx+xml',
    'nds'           => 'application/x-nintendo-ds-rom',
    'nef'           => 'image/x-nikon-nef',
    'nes'           => 'application/x-nes-rom',
    'nfo'           => 'text/x-nfo',
    'ngdat'         => 'application/vnd.nokia.n-gage.data',
    'nlu'           => 'application/vnd.neurolanguage.nlu',
    'nml'           => 'application/vnd.enliven',
    'nnd'           => 'application/vnd.noblenet-directory',
    'nns'           => 'application/vnd.noblenet-sealer',
    'nnw'           => 'application/vnd.noblenet-web',
    'not'           => 'text/x-mup',
    'npx'           => 'image/vnd.net-fpx',
    'nsc'           => 'application/x-netshow-channel',
    'nsf'           => 'application/vnd.lotus-notes',
    'nsv'           => 'video/x-nsv',
    'o'             => 'application/x-object',
    'oa2'           => 'application/vnd.fujitsu.oasys2',
    'oa3'           => 'application/vnd.fujitsu.oasys3',
    'oas'           => 'application/vnd.fujitsu.oasys',
    'obd'           => 'application/x-msbinder',
    'obj'           => 'application/x-tgif',
    'ocl'           => 'text/x-ocl',
    'oda'           => 'application/oda',
    'odb'           => 'application/vnd.oasis.opendocument.database',
    'odc'           => 'application/vnd.oasis.opendocument.chart',
    'odf'           => 'application/vnd.oasis.opendocument.formula',
    'odft'          => 'application/vnd.oasis.opendocument.formula-template',
    'odg'           => 'application/vnd.oasis.opendocument.graphics',
    'odi'           => 'application/vnd.oasis.opendocument.image',
    'odm'           => 'application/vnd.oasis.opendocument.text-master',
    'odp'           => 'application/vnd.oasis.opendocument.presentation',
    'ods'           => 'application/vnd.oasis.opendocument.spreadsheet',
    'odt'           => 'application/vnd.oasis.opendocument.text',
    'oga'           => 'audio/ogg',
    'ogg'           => 'video/x-theora+ogg',
    'ogm'           => 'video/x-ogm+ogg',
    'ogv'           => 'video/ogg',
    'ogx'           => 'application/ogg',
    'old'           => 'application/x-trash',
    'oleo'          => 'application/x-oleo',
    'onepkg'        => 'application/onenote',
    'onetmp'        => 'application/onenote',
    'onetoc'        => 'application/onenote',
    'onetoc2'       => 'application/onenote',
    'oot'           => 'application/vnd.oasis.opendocument.text',
    'opf'           => 'application/oebps-package+xml',
    'opml'          => 'text/x-opml+xml',
    'oprc'          => 'application/vnd.palm',
    'ora'           => 'image/openraster',
    'orf'           => 'image/x-olympus-orf',
    'org'           => 'application/vnd.lotus-organizer',
    'osf'           => 'application/vnd.yamaha.openscoreformat',
    'osfpvg'        => 'application/vnd.yamaha.openscoreformat.osfpvg+xml',
    'otc'           => 'application/vnd.oasis.opendocument.chart-template',
    'otf'           => 'application/x-font-otf',
    'otg'           => 'application/vnd.oasis.opendocument.graphics-template',
    'oth'           => 'application/vnd.oasis.opendocument.text-web',
    'oti'           => 'application/vnd.oasis.opendocument.image-template',
    'otm'           => 'application/vnd.oasis.opendocument.text-master',
    'otp'           => 'application/vnd.oasis.opendocument.presentation-template',
    'ots'           => 'application/vnd.oasis.opendocument.spreadsheet-template',
    'ott'           => 'application/vnd.oasis.opendocument.text-template',
    'owl'           => 'application/rdf+xml',
    'oxt'           => 'application/vnd.openofficeorg.extension',
    'p'             => 'text/x-pascal',
    'p10'           => 'application/pkcs10',
    'p12'           => 'application/x-pkcs12',
    'p7b'           => 'application/x-pkcs7-certificates',
    'p7c'           => 'application/pkcs7-mime',
    'p7m'           => 'application/pkcs7-mime',
    'p7r'           => 'application/x-pkcs7-certreqresp',
    'p7s'           => 'application/pkcs7-signature',
    'pack'          => 'application/x-java-pack200',
    'pak'           => 'application/x-pak',
    'par2'          => 'application/x-par2',
    'pas'           => 'text/x-pascal',
    'patch'         => 'text/x-patch',
    'paw'           => 'application/vnd.pawaafile',
    'pbd'           => 'application/vnd.powerbuilder6',
    'pbm'           => 'image/x-portable-bitmap',
    'pcd'           => 'image/x-photo-cd',
    'pcf'           => 'application/x-cisco-vpn-settings',
    'pcf.Z'         => 'application/x-font-pcf',
    'pcf.gz'        => 'application/x-font-pcf',
    'pcl'           => 'application/vnd.hp-pcl',
    'pclxl'         => 'application/vnd.hp-pclxl',
    'pct'           => 'image/x-pict',
    'pcurl'         => 'application/vnd.curl.pcurl',
    'pcx'           => 'image/x-pcx',
    'pdb'           => 'application/x-palm-database',
    'pdc'           => 'application/x-aportisdoc',
    'pdf'           => 'application/pdf',
    'pdf.bz2'       => 'application/x-bzpdf',
    'pdf.gz'        => 'application/x-gzpdf',
    'pef'           => 'image/x-pentax-pef',
    'pem'           => 'application/x-x509-ca-cert',
    'perl'          => 'application/x-perl',
    'pfa'           => 'application/x-font-type1',
    'pfb'           => 'application/x-font-type1',
    'pfm'           => 'application/x-font-type1',
    'pfr'           => 'application/font-tdpfr',
    'pfx'           => 'application/x-pkcs12',
    'pgm'           => 'image/x-portable-graymap',
    'pgn'           => 'application/x-chess-pgn',
    'pgp'           => 'application/pgp-encrypted',
    'php'           => 'application/x-php',
    'php3'          => 'application/x-php',
    'php4'          => 'application/x-php',
    'pic'           => 'image/x-pict',
    'pict'          => 'image/x-pict',
    'pict1'         => 'image/x-pict',
    'pict2'         => 'image/x-pict',
    'pk'            => 'application/x-tex-pk',
    'pkg'           => 'application/octet-stream',
    'pki'           => 'application/pkixcmp',
    'pkipath'       => 'application/pkix-pkipath',
    'pkr'           => 'application/pgp-keys',
    'pl'            => 'application/x-perl',
    'pla'           => 'audio/x-iriver-pla',
    'plb'           => 'application/vnd.3gpp.pic-bw-large',
    'plc'           => 'application/vnd.mobius.plc',
    'plf'           => 'application/vnd.pocketlearn',
    'pln'           => 'application/x-planperfect',
    'pls'           => 'audio/x-scpls',
    'pm'            => 'application/x-perl',
    'pml'           => 'application/vnd.ctc-posml',
    'png'           => 'image/png',
    'pnm'           => 'image/x-portable-anymap',
    'pntg'          => 'image/x-macpaint',
    'po'            => 'text/x-gettext-translation',
    'por'           => 'application/x-spss-por',
    'portpkg'       => 'application/vnd.macports.portpkg',
    'pot'           => 'text/x-gettext-translation-template',
    'potm'          => 'application/vnd.ms-powerpoint.template.macroenabled.12',
    'potx'          => 'application/vnd.openxmlformats-officedocument.presentationml.template',
    'ppam'          => 'application/vnd.ms-powerpoint.addin.macroenabled.12',
    'ppd'           => 'application/vnd.cups-ppd',
    'ppm'           => 'image/x-portable-pixmap',
    'pps'           => 'application/vnd.ms-powerpoint',
    'ppsm'          => 'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
    'ppsx'          => 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
    'ppt'           => 'application/vnd.ms-powerpoint',
    'pptm'          => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'pptx'          => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'ppz'           => 'application/vnd.ms-powerpoint',
    'pqa'           => 'application/vnd.palm',
    'prc'           => 'application/x-palm-database',
    'pre'           => 'application/vnd.lotus-freelance',
    'prf'           => 'application/pics-rules',
    'ps'            => 'application/postscript',
    'ps.bz2'        => 'application/x-bzpostscript',
    'ps.gz'         => 'application/x-gzpostscript',
    'psb'           => 'application/vnd.3gpp.pic-bw-small',
    'psd'           => 'image/vnd.adobe.photoshop',
    'psf'           => 'audio/x-psf',
    'psf.gz'        => 'application/x-gz-font-linux-psf',
    'psflib'        => 'audio/x-psflib',
    'psid'          => 'audio/prs.sid',
    'psw'           => 'application/x-pocket-word',
    'ptid'          => 'application/vnd.pvi.ptid1',
    'pub'           => 'application/x-mspublisher',
    'pvb'           => 'application/vnd.3gpp.pic-bw-var',
    'pw'            => 'application/x-pw',
    'pwn'           => 'application/vnd.3m.post-it-notes',
    'py'            => 'text/x-python',
    'pya'           => 'audio/vnd.ms-playready.media.pya',
    'pyc'           => 'application/x-python-bytecode',
    'pyo'           => 'application/x-python-bytecode',
    'pyv'           => 'video/vnd.ms-playready.media.pyv',
    'qam'           => 'application/vnd.epson.quickanime',
    'qbo'           => 'application/vnd.intu.qbo',
    'qfx'           => 'application/vnd.intu.qfx',
    'qif'           => 'image/x-quicktime',
    'qps'           => 'application/vnd.publishare-delta-tree',
    'qt'            => 'video/quicktime',
    'qtif'          => 'image/x-quicktime',
    'qtl'           => 'application/x-quicktime-media-link',
    'qtvr'          => 'video/quicktime',
    'qwd'           => 'application/vnd.quark.quarkxpress',
    'qwt'           => 'application/vnd.quark.quarkxpress',
    'qxb'           => 'application/vnd.quark.quarkxpress',
    'qxd'           => 'application/vnd.quark.quarkxpress',
    'qxl'           => 'application/vnd.quark.quarkxpress',
    'qxt'           => 'application/vnd.quark.quarkxpress',
    'ra'            => 'audio/vnd.rn-realaudio',
    'raf'           => 'image/x-fuji-raf',
    'ram'           => 'application/ram',
    'rar'           => 'application/x-rar',
    'ras'           => 'image/x-cmu-raster',
    'raw'           => 'image/x-panasonic-raw',
    'rax'           => 'audio/vnd.rn-realaudio',
    'rb'            => 'application/x-ruby',
    'rcprofile'     => 'application/vnd.ipunplugged.rcprofile',
    'rdf'           => 'application/rdf+xml',
    'rdfs'          => 'application/rdf+xml',
    'rdz'           => 'application/vnd.data-vision.rdz',
    'reg'           => 'text/x-ms-regedit',
    'rej'           => 'application/x-reject',
    'rep'           => 'application/vnd.businessobjects',
    'res'           => 'application/x-dtbresource+xml',
    'rgb'           => 'image/x-rgb',
    'rif'           => 'application/reginfo+xml',
    'rl'            => 'application/resource-lists+xml',
    'rlc'           => 'image/vnd.fujixerox.edmics-rlc',
    'rld'           => 'application/resource-lists-diff+xml',
    'rle'           => 'image/rle',
    'rm'            => 'application/vnd.rn-realmedia',
    'rmi'           => 'audio/midi',
    'rmj'           => 'application/vnd.rn-realmedia',
    'rmm'           => 'application/vnd.rn-realmedia',
    'rmp'           => 'audio/x-pn-realaudio-plugin',
    'rms'           => 'application/vnd.rn-realmedia',
    'rmvb'          => 'application/vnd.rn-realmedia',
    'rmx'           => 'application/vnd.rn-realmedia',
    'rnc'           => 'application/relax-ng-compact-syntax',
    'roff'          => 'text/troff',
    'rp'            => 'image/vnd.rn-realpix',
    'rp9'           => 'application/vnd.cloanto.rp9',
    'rpm'           => 'application/x-rpm',
    'rpss'          => 'application/vnd.nokia.radio-presets',
    'rpst'          => 'application/vnd.nokia.radio-preset',
    'rq'            => 'application/sparql-query',
    'rs'            => 'application/rls-services+xml',
    'rsd'           => 'application/rsd+xml',
    'rss'           => 'application/rss+xml',
    'rt'            => 'text/vnd.rn-realtext',
    'rtf'           => 'application/rtf',
    'rtx'           => 'text/richtext',
    'rv'            => 'video/vnd.rn-realvideo',
    'rvx'           => 'video/vnd.rn-realvideo',
    's'             => 'text/x-asm',
    's3m'           => 'audio/x-s3m',
    'saf'           => 'application/vnd.yamaha.smaf-audio',
    'sam'           => 'application/x-amipro',
    'sami'          => 'application/x-sami',
    'sav'           => 'application/x-spss-sav',
    'sbml'          => 'application/sbml+xml',
    'sc'            => 'application/vnd.ibm.secure-container',
    'scd'           => 'application/x-msschedule',
    'scm'           => 'text/x-scheme',
    'scq'           => 'application/scvp-cv-request',
    'scs'           => 'application/scvp-cv-response',
    'scurl'         => 'text/vnd.curl.scurl',
    'sda'           => 'application/vnd.stardivision.draw',
    'sdc'           => 'application/vnd.stardivision.calc',
    'sdd'           => 'application/vnd.stardivision.impress',
    'sdkd'          => 'application/vnd.solent.sdkm+xml',
    'sdkm'          => 'application/vnd.solent.sdkm+xml',
    'sdp'           => 'application/sdp',
    'sds'           => 'application/vnd.stardivision.chart',
    'sdw'           => 'application/vnd.stardivision.writer',
    'see'           => 'application/vnd.seemail',
    'seed'          => 'application/vnd.fdsn.seed',
    'sema'          => 'application/vnd.sema',
    'semd'          => 'application/vnd.semd',
    'semf'          => 'application/vnd.semf',
    'ser'           => 'application/java-serialized-object',
    'setpay'        => 'application/set-payment-initiation',
    'setreg'        => 'application/set-registration-initiation',
    'sfd-hdstx'     => 'application/vnd.hydrostatix.sof-data',
    'sfs'           => 'application/vnd.spotfire.sfs',
    'sgf'           => 'application/x-go-sgf',
    'sgi'           => 'image/x-sgi',
    'sgl'           => 'application/vnd.stardivision.writer',
    'sgm'           => 'text/sgml',
    'sgml'          => 'text/sgml',
    'sh'            => 'application/x-shellscript',
    'shar'          => 'application/x-shar',
    'shf'           => 'application/shf+xml',
    'shn'           => 'application/x-shorten',
    'shtml'         => 'text/html',
    'siag'          => 'application/x-siag',
    'sid'           => 'audio/prs.sid',
    'sig'           => 'application/pgp-signature',
    'sik'           => 'application/x-trash',
    'silo'          => 'model/mesh',
    'sis'           => 'application/vnd.symbian.install',
    'sisx'          => 'x-epoc/x-sisx-app',
    'sit'           => 'application/x-stuffit',
    'sitx'          => 'application/x-stuffitx',
    'siv'           => 'application/sieve',
    'sk'            => 'image/x-skencil',
    'sk1'           => 'image/x-skencil',
    'skd'           => 'application/vnd.koan',
    'skm'           => 'application/vnd.koan',
    'skp'           => 'application/vnd.koan',
    'skr'           => 'application/pgp-keys',
    'skt'           => 'application/vnd.koan',
    'sldm'          => 'application/vnd.ms-powerpoint.slide.macroenabled.12',
    'sldx'          => 'application/vnd.openxmlformats-officedocument.presentationml.slide',
    'slk'           => 'text/spreadsheet',
    'slt'           => 'application/vnd.epson.salt',
    'smaf'          => 'application/x-smaf',
    'smc'           => 'application/x-snes-rom',
    'smd'           => 'application/vnd.stardivision.mail',
    'smf'           => 'application/vnd.stardivision.math',
    'smi'           => 'application/x-sami',
    'smil'          => 'application/smil',
    'sml'           => 'application/smil',
    'sms'           => 'application/x-sms-rom',
    'snd'           => 'audio/basic',
    'snf'           => 'application/x-font-snf',
    'so'            => 'application/x-sharedlib',
    'spc'           => 'application/x-pkcs7-certificates',
    'spd'           => 'application/x-font-speedo',
    'spec'          => 'text/x-rpm-spec',
    'spf'           => 'application/vnd.yamaha.smaf-phrase',
    'spl'           => 'application/x-shockwave-flash',
    'spot'          => 'text/vnd.in3d.spot',
    'spp'           => 'application/scvp-vp-response',
    'spq'           => 'application/scvp-vp-request',
    'spx'           => 'audio/x-speex',
    'sql'           => 'text/x-sql',
    'sr2'           => 'image/x-sony-sr2',
    'src'           => 'application/x-wais-source',
    'srf'           => 'image/x-sony-srf',
    'srt'           => 'application/x-subrip',
    'srx'           => 'application/sparql-results+xml',
    'ssa'           => 'text/x-ssa',
    'sse'           => 'application/vnd.kodak-descriptor',
    'ssf'           => 'application/vnd.epson.ssf',
    'ssml'          => 'application/ssml+xml',
    'st'            => 'application/vnd.sailingtracker.track',
    'stc'           => 'application/vnd.sun.xml.calc.template',
    'std'           => 'application/vnd.sun.xml.draw.template',
    'stf'           => 'application/vnd.wt.stf',
    'sti'           => 'application/vnd.sun.xml.impress.template',
    'stk'           => 'application/hyperstudio',
    'stl'           => 'application/vnd.ms-pki.stl',
    'stm'           => 'audio/x-stm',
    'str'           => 'application/vnd.pg.format',
    'stw'           => 'application/vnd.sun.xml.writer.template',
    'sty'           => 'text/x-tex',
    'sub'           => 'text/x-subviewer',
    'sun'           => 'image/x-sun-raster',
    'sus'           => 'application/vnd.sus-calendar',
    'susp'          => 'application/vnd.sus-calendar',
    'sv4cpio'       => 'application/x-sv4cpio',
    'sv4crc'        => 'application/x-sv4crc',
    'svd'           => 'application/vnd.svd',
    'svg'           => 'image/svg+xml',
    'svgz'          => 'image/svg+xml-compressed',
    'swa'           => 'application/x-director',
    'swf'           => 'application/x-shockwave-flash',
    'swi'           => 'application/vnd.aristanetworks.swi',
    'sxc'           => 'application/vnd.sun.xml.calc',
    'sxd'           => 'application/vnd.sun.xml.draw',
    'sxg'           => 'application/vnd.sun.xml.writer.global',
    'sxi'           => 'application/vnd.sun.xml.impress',
    'sxm'           => 'application/vnd.sun.xml.math',
    'sxw'           => 'application/vnd.sun.xml.writer',
    'sylk'          => 'text/spreadsheet',
    't'             => 'text/troff',
    't2t'           => 'text/x-txt2tags',
    'tao'           => 'application/vnd.tao.intent-module-archive',
    'tar'           => 'application/x-tar',
    'tar.Z'         => 'application/x-tarz',
    'tar.bz'        => 'application/x-bzip-compressed-tar',
    'tar.bz2'       => 'application/x-bzip-compressed-tar',
    'tar.gz'        => 'application/x-compressed-tar',
    'tar.lzma'      => 'application/x-lzma-compressed-tar',
    'tar.lzo'       => 'application/x-tzo',
    'tar.xz'        => 'application/x-xz-compressed-tar',
    'tbz'           => 'application/x-bzip-compressed-tar',
    'tbz2'          => 'application/x-bzip-compressed-tar',
    'tcap'          => 'application/vnd.3gpp2.tcap',
    'tcl'           => 'text/x-tcl',
    'teacher'       => 'application/vnd.smart.teacher',
    'tex'           => 'text/x-tex',
    'texi'          => 'text/x-texinfo',
    'texinfo'       => 'text/x-texinfo',
    'text'          => 'text/plain',
    'tfm'           => 'application/x-tex-tfm',
    'tga'           => 'image/x-tga',
    'tgz'           => 'application/x-compressed-tar',
    'theme'         => 'application/x-theme',
    'themepack'     => 'application/x-windows-themepack',
    'tif'           => 'image/tiff',
    'tiff'          => 'image/tiff',
    'tk'            => 'text/x-tcl',
    'tlz'           => 'application/x-lzma-compressed-tar',
    'tmo'           => 'application/vnd.tmobile-livetv',
    'tnef'          => 'application/vnd.ms-tnef',
    'tnf'           => 'application/vnd.ms-tnef',
    'toc'           => 'application/x-cdrdao-toc',
    'torrent'       => 'application/x-bittorrent',
    'tpic'          => 'image/x-tga',
    'tpl'           => 'application/vnd.groove-tool-template',
    'tpt'           => 'application/vnd.trid.tpt',
    'tr'            => 'text/troff',
    'tra'           => 'application/vnd.trueapp',
    'trm'           => 'application/x-msterminal',
    'ts'            => 'application/x-linguist',
    'tsv'           => 'text/tab-separated-values',
    'tta'           => 'audio/x-tta',
    'ttc'           => 'application/x-font-ttf',
    'ttf'           => 'application/x-font-ttf',
    'ttx'           => 'application/x-font-ttx',
    'twd'           => 'application/vnd.simtech-mindmapper',
    'twds'          => 'application/vnd.simtech-mindmapper',
    'txd'           => 'application/vnd.genomatix.tuxedo',
    'txf'           => 'application/vnd.mobius.txf',
    'txt'           => 'text/plain',
    'txz'           => 'application/x-xz-compressed-tar',
    'tzo'           => 'application/x-tzo',
    'u32'           => 'application/x-authorware-bin',
    'udeb'          => 'application/x-debian-package',
    'ufd'           => 'application/vnd.ufdl',
    'ufdl'          => 'application/vnd.ufdl',
    'ufraw'         => 'application/x-ufraw',
    'ui'            => 'application/x-designer',
    'uil'           => 'text/x-uil',
    'ult'           => 'audio/x-mod',
    'umj'           => 'application/vnd.umajin',
    'uni'           => 'audio/x-mod',
    'unityweb'      => 'application/vnd.unity',
    'uoml'          => 'application/vnd.uoml+xml',
    'uri'           => 'text/x-uri',
    'uris'          => 'text/uri-list',
    'url'           => 'text/x-uri',
    'urls'          => 'text/uri-list',
    'ustar'         => 'application/x-ustar',
    'utz'           => 'application/vnd.uiq.theme',
    'uu'            => 'text/x-uuencode',
    'vala'          => 'text/x-vala',
    'vapi'          => 'text/x-vala',
    'vcd'           => 'application/x-cdlink',
    'vcf'           => 'text/directory',
    'vcg'           => 'application/vnd.groove-vcard',
    'vcs'           => 'text/calendar',
    'vct'           => 'text/directory',
    'vcx'           => 'application/vnd.vcx',
    'vda'           => 'image/x-tga',
    'vfb'           => 'text/calendar',
    'vhd'           => 'text/x-vhdl',
    'vhdl'          => 'text/x-vhdl',
    'vis'           => 'application/vnd.visionary',
    'viv'           => 'video/vivo',
    'vivo'          => 'video/vivo',
    'vlc'           => 'audio/x-mpegurl',
    'vob'           => 'video/mpeg',
    'voc'           => 'audio/x-voc',
    'vor'           => 'application/vnd.stardivision.writer',
    'vox'           => 'application/x-authorware-bin',
    'vrml'          => 'model/vrml',
    'vsd'           => 'application/vnd.visio',
    'vsf'           => 'application/vnd.vsf',
    'vss'           => 'application/vnd.visio',
    'vst'           => 'image/x-tga',
    'vsw'           => 'application/vnd.visio',
    'vtu'           => 'model/vnd.vtu',
    'vxml'          => 'application/voicexml+xml',
    'w3d'           => 'application/x-director',
    'wad'           => 'application/x-doom',
    'wav'           => 'audio/x-wav',
    'wax'           => 'audio/x-ms-asx',
    'wb1'           => 'application/x-quattropro',
    'wb2'           => 'application/x-quattropro',
    'wb3'           => 'application/x-quattropro',
    'wbmp'          => 'image/vnd.wap.wbmp',
    'wbs'           => 'application/vnd.criticaltools.wbs+xml',
    'wbxml'         => 'application/vnd.wap.wbxml',
    'wcm'           => 'application/vnd.ms-works',
    'wdb'           => 'application/vnd.ms-works',
    'wg'            => 'application/vnd.pmi.widget',
    'wk1'           => 'application/vnd.lotus-1-2-3',
    'wk3'           => 'application/vnd.lotus-1-2-3',
    'wk4'           => 'application/vnd.lotus-1-2-3',
    'wks'           => 'application/vnd.ms-works',
    'wm'            => 'video/x-ms-wm',
    'wma'           => 'audio/x-ms-wma',
    'wmd'           => 'application/x-ms-wmd',
    'wmf'           => 'image/x-wmf',
    'wml'           => 'text/vnd.wap.wml',
    'wmlc'          => 'application/vnd.wap.wmlc',
    'wmls'          => 'text/vnd.wap.wmlscript',
    'wmlsc'         => 'application/vnd.wap.wmlscriptc',
    'wmv'           => 'video/x-ms-wmv',
    'wmx'           => 'audio/x-ms-asx',
    'wmz'           => 'application/x-ms-wmz',
    'wp'            => 'application/vnd.wordperfect',
    'wp4'           => 'application/vnd.wordperfect',
    'wp5'           => 'application/vnd.wordperfect',
    'wp6'           => 'application/vnd.wordperfect',
    'wpd'           => 'application/vnd.wordperfect',
    'wpg'           => 'application/x-wpg',
    'wpl'           => 'application/vnd.ms-wpl',
    'wpp'           => 'application/vnd.wordperfect',
    'wps'           => 'application/vnd.ms-works',
    'wqd'           => 'application/vnd.wqd',
    'wri'           => 'application/x-mswrite',
    'wrl'           => 'model/vrml',
    'wsdl'          => 'application/wsdl+xml',
    'wspolicy'      => 'application/wspolicy+xml',
    'wtb'           => 'application/vnd.webturbo',
    'wv'            => 'audio/x-wavpack',
    'wvc'           => 'audio/x-wavpack-correction',
    'wvp'           => 'audio/x-wavpack',
    'wvx'           => 'audio/x-ms-asx',
    'x32'           => 'application/x-authorware-bin',
    'x3d'           => 'application/vnd.hzn-3d-crossword',
    'x3f'           => 'image/x-sigma-x3f',
    'xac'           => 'application/x-gnucash',
    'xap'           => 'application/x-silverlight-app',
    'xar'           => 'application/vnd.xara',
    'xbap'          => 'application/x-ms-xbap',
    'xbd'           => 'application/vnd.fujixerox.docuworks.binder',
    'xbel'          => 'application/x-xbel',
    'xbl'           => 'application/xml',
    'xbm'           => 'image/x-xbitmap',
    'xcf'           => 'image/x-xcf',
    'xcf.bz2'       => 'image/x-compressed-xcf',
    'xcf.gz'        => 'image/x-compressed-xcf',
    'xdm'           => 'application/vnd.syncml.dm+xml',
    'xdp'           => 'application/vnd.adobe.xdp+xml',
    'xdssc'         => 'application/dssc+xml',
    'xdw'           => 'application/vnd.fujixerox.docuworks',
    'xenc'          => 'application/xenc+xml',
    'xer'           => 'application/patch-ops-error+xml',
    'xfdf'          => 'application/vnd.adobe.xfdf',
    'xfdl'          => 'application/vnd.xfdl',
    'xht'           => 'application/xhtml+xml',
    'xhtml'         => 'application/xhtml+xml',
    'xhvml'         => 'application/xv+xml',
    'xi'            => 'audio/x-xi',
    'xif'           => 'image/vnd.xiff',
    'xla'           => 'application/vnd.ms-excel',
    'xlam'          => 'application/vnd.ms-excel.addin.macroenabled.12',
    'xlc'           => 'application/vnd.ms-excel',
    'xld'           => 'application/vnd.ms-excel',
    'xlf'           => 'application/x-xliff',
    'xliff'         => 'application/x-xliff',
    'xll'           => 'application/vnd.ms-excel',
    'xlm'           => 'application/vnd.ms-excel',
    'xls'           => 'application/vnd.ms-excel',
    'xlsb'          => 'application/vnd.ms-excel.sheet.binary.macroenabled.12',
    'xlsm'          => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'xlsx'          => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'xlt'           => 'application/vnd.ms-excel',
    'xltm'          => 'application/vnd.ms-excel.template.macroenabled.12',
    'xltx'          => 'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
    'xlw'           => 'application/vnd.ms-excel',
    'xm'            => 'audio/x-xm',
    'xmf'           => 'audio/x-xmf',
    'xmi'           => 'text/x-xmi',
    'xml'           => 'application/xml',
    'xo'            => 'application/vnd.olpc-sugar',
    'xop'           => 'application/xop+xml',
    'xpi'           => 'application/x-xpinstall',
    'xpm'           => 'image/x-xpixmap',
    'xpr'           => 'application/vnd.is-xpr',
    'xps'           => 'application/vnd.ms-xpsdocument',
    'xpw'           => 'application/vnd.intercon.formnet',
    'xpx'           => 'application/vnd.intercon.formnet',
    'xsl'           => 'application/xslt+xml',
    'xslfo'         => 'text/x-xslfo',
    'xslt'          => 'application/xslt+xml',
    'xsm'           => 'application/vnd.syncml+xml',
    'xspf'          => 'application/xspf+xml',
    'xul'           => 'application/vnd.mozilla.xul+xml',
    'xvm'           => 'application/xv+xml',
    'xvml'          => 'application/xv+xml',
    'xwd'           => 'image/x-xwindowdump',
    'xyz'           => 'chemical/x-xyz',
    'xz'            => 'application/x-xz',
    'zabw'          => 'application/x-abiword',
    'zaz'           => 'application/vnd.zzazz.deck+xml',
    'zip'           => 'application/zip',
    'zir'           => 'application/vnd.zul',
    'zirz'          => 'application/vnd.zul',
    'zmm'           => 'application/vnd.handheld-entertainment+xml',
    'zoo'           => 'application/x-zoo',
    '123'           => 'application/vnd.lotus-1-2-3',
    '602'           => 'application/x-t602',
    '669'           => 'audio/x-mod'
);
