/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000 The PHP Group                   |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Chad Cunningham <ccunning@math.ohio-state.edu>              |
   +----------------------------------------------------------------------+
*/
 
/*
 * Very basic pam extension to authenticate when given a username
 * and password. This is largely based on mod_auth_pam...
 *
 * CHANGELOG
 *  6/17/00 - Initial release
 *  2/12/02 - Um, look who hasn't been keeping a change log
 *            * released 0.3.1 with php 4.1.X support
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "php_pam_auth.h"
#include <security/pam_appl.h>

/* change this to 0 on RedHat 4.x */
#define PAM_STRE_NEEDS_PAMH 1

/* #include "ext/standard/info.h" */
/* #include "php_globals.h" */

/* #if HAVE_PAM_AUTH */

ZEND_DECLARE_MODULE_GLOBALS(pam_auth)

function_entry pam_auth_functions[] = {
	PHP_FE(pam_auth, NULL)
	{NULL, NULL, NULL}
};

zend_module_entry pam_auth_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
    STANDARD_MODULE_HEADER,
#endif	
	"pam_auth",
	pam_auth_functions,
	PHP_MINIT(pam_auth),
	PHP_MSHUTDOWN(pam_auth),
	NULL,
	NULL,
	PHP_MINFO(pam_auth),
#if ZEND_MODULE_API_NO >= 20010901
	"0.3",
#endif			
	STANDARD_MODULE_PROPERTIES
};


#ifdef COMPILE_DL_PAM_AUTH
ZEND_GET_MODULE(pam_auth)
#endif

PHP_INI_BEGIN()
	STD_PHP_INI_ENTRY("pam_auth.servicename", "php", PHP_INI_ALL, OnUpdateString, servicename, zend_pam_auth_globals, pam_auth_globals)
PHP_INI_END()

PHP_MINIT_FUNCTION(pam_auth) {
	REGISTER_INI_ENTRIES();
	return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(pam_auth) {
	UNREGISTER_INI_ENTRIES();
	return SUCCESS;
}
		
PHP_MINFO_FUNCTION(pam_auth) {
	php_info_print_table_start();
	php_info_print_table_row(2, "Pam Authentication Support", "active");
	php_info_print_table_end();
	DISPLAY_INI_ENTRIES();
}


/*
 *  most of this next stuff was taken from mod_auth_pam :)
 */
 
 typedef struct {
  char *name, *pw;
} auth_pam_userinfo;

/* 
 * Solaris 2.6.x has a broken conversation function and needs this
 * as a global variable 
 * I refused to pollute code for other platforms with this, 
 * so all Solaris 2.6 specific stuff is if'd like the following
 */
#if SOLARIS2 == 260
auth_pam_userinfo *global_userinfo;
#endif

/* 
 * the pam_strerror function has different parameters in early PAM
 * versions 
 */
#ifndef PAM_STRE_NEEDS_PAMH
#define compat_pam_strerror(pamh, res) pam_strerror(res)
#else
#define compat_pam_strerror(pamh, res) pam_strerror(pamh, res)
#endif
 
/*
 * auth_pam_talker: supply authentication information to PAM when asked
 *
 * Assumptions:
 *   A password is asked for by requesting input without echoing
 *   A username is asked for by requesting input _with_ echoing
 *
 */
static
int auth_pam_talker(int num_msg,
                    const struct pam_message **msg,
                    struct pam_response **resp,
                    void *appdata_ptr)
{
  unsigned short i = 0;
  auth_pam_userinfo *userinfo = (auth_pam_userinfo*)appdata_ptr;
  struct pam_response *pr = 0;

#if SOLARIS2 == 260
  if(!userinfo)
    userinfo = global_userinfo;
#endif

  /* allocate memory to store response */
  pr = malloc(num_msg * sizeof(struct pam_response));
  if(!pr) 
    return PAM_CONV_ERR;

  /* copy values */
  for(i = 0; i < num_msg; i++) {
    /* initialize to safe values */
    pr[i].resp_retcode = 0;
    pr[i].resp = 0;

    /* select response based on requested output style */
    switch(msg[i]->msg_style) {
    case PAM_PROMPT_ECHO_ON:
      /* on memory allocation failure, auth fails */
      pr[i].resp = strdup(userinfo->name);
      break;
    case PAM_PROMPT_ECHO_OFF:
      pr[i].resp = strdup(userinfo->pw);
      break;
    default:
      if(pr)
        free(pr);
      return PAM_CONV_ERR;
    }
  }
  /* everything okay, set PAM response values */
  *resp = pr;
  return PAM_SUCCESS;
}

PHP_FUNCTION(pam_auth)
{
	pval **username, **password, **status;
	int res = 0, cnt;
	auth_pam_userinfo userinfo = { NULL, NULL };
	struct pam_conv conv_info = { &auth_pam_talker, (void*)&userinfo};
	pam_handle_t *pamh  = NULL;
	char *error;
	PA_LS_FETCH();

#if SOLARIS2 == 260
	global_userinfo = &userinfo;
#endif

	cnt = ARG_COUNT(ht);
	switch (cnt) {
		case 2:
			if (zend_get_parameters_ex(2, &username, &password)==FAILURE) {
				RETURN_FALSE;
			}
			break;
		case 3:
			if (zend_get_parameters_ex(3, &username, &password, &status) == FAILURE) {
				RETURN_FALSE;
			}
			if (!PZVAL_IS_REF(*status)) {
				php_error(E_WARNING, "Error variable must be passed by reference");
				RETURN_FALSE;
			}
			pval_destructor(*status);
			break;
		default:
			WRONG_PARAM_COUNT;
			break;
	}

	convert_to_string_ex(username);
	convert_to_string_ex(password);

	userinfo.name = (*username)->value.str.val;
	userinfo.pw = (*password)->value.str.val;
	
	if ((res = pam_start(PA_G(servicename),
						userinfo.name,
						&conv_info,
						&pamh)) != PAM_SUCCESS) {
		if (cnt == 3) {
			error = (char *) compat_pam_strerror(pamh, res);
			(*status)->value.str.val = estrdup(error);
			(*status)->value.str.len = strlen(error);
			(*status)->type = IS_STRING;
		}
		RETURN_FALSE;
	}

	if ((res = pam_authenticate(pamh, PAM_DISALLOW_NULL_AUTHTOK)) !=
			PAM_SUCCESS) {
		if (cnt == 3) {
			error = (char *) compat_pam_strerror(pamh, res);
			(*status)->value.str.val = estrdup(error);
			(*status)->value.str.len = strlen(error);
			(*status)->type = IS_STRING;
		}
		RETURN_FALSE;
	}
	
	if ((res = pam_acct_mgmt(pamh, PAM_DISALLOW_NULL_AUTHTOK)) != PAM_SUCCESS) {
		if (cnt == 3) {
			error = (char *) compat_pam_strerror(pamh, res);
			(*status)->value.str.val = estrdup(error);
			(*status)->value.str.len = strlen(error);
			(*status)->type = IS_STRING;
		}
		pam_end(pamh, PAM_SUCCESS);
		RETURN_FALSE;
	}
	
	pam_end(pamh, PAM_SUCCESS);
	RETURN_TRUE;
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
