/*
 * Permafrost - Physical modelling framework
 *
 * Copyright (C) 2009, 2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "src/types.h"
#include "src/util.h"

char *
copy_str(const char *s)
{
	size_t len;
	char *ret;

	len = strlen(s);
	ret = xmalloc(len + 1);
	strcpy(ret, s);

	return ret;
}

char *
copy_str_no_q(const char *s)
{
	size_t len;
	char *ret;

	len = strlen(s);
	ret = xmalloc(len - 1);
	strncpy(ret, s + 1, len - 2);
	ret[len - 2] = '\0';

	return ret;
}

void *
xmalloc(size_t size)
{
	void *ret;

	ret = malloc(size);
	if (ret == NULL)
	  {
		fprintf(stderr, "%s\n", strerror(ENOMEM));
		exit(EXIT_FAILURE);
	  }

	return ret;
}

void *
xrealloc(void *ptr, size_t size)
{
	void *ret;

	ret = realloc(ptr, size);
	if (ret == NULL)
	  {
		fprintf(stderr, "%s\n", strerror(ENOMEM));
		exit(EXIT_FAILURE);
	  }

	return ret;
}
