/* Copyright © 2007, 2008 Jakub Wilk
 *
 * This package is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 */

namespace djvu
{
  static const int MIN_DPI = 72;
  static const int MAX_DPI = 6000;
  /* ``djvumake`` used to require dpi ≥ 72.
   * The library itself enforces dpi ≤ 6000.
   *
   * See
   * <http://sf.net/tracker/?func=detail&aid=1956093&group_id=32953&atid=406583>
   * for details.
   */

  static const unsigned char VERSION = 1;

  static const char BINARY_TEMPLATE[] = "AT&TFORM\0\0\0\0DJVMDIRM\0\0\0";

  static const char DUMMY_SINGLE_HEAD[12] = 
  { 0x41, 0x54, 0x26, 0x54, 0x46, 0x4f, 0x52, 0x4d,
    0x00, 0x00, 0x00, 0x20
  };

  static const char DUMMY_DOUBLE_HEAD[48] = 
  { 0x41, 0x54, 0x26, 0x54, 0x46, 0x4f, 0x52, 0x4d, 
    0x00, 0x00, 0x00, 0x74, 0x44, 0x4a, 0x56, 0x4d,
    0x44, 0x49, 0x52, 0x4d, 0x00, 0x00, 0x00, 0x18,
    0x81, 0x00, 0x02, 0x00, 0x00, 0x00, 0x30, 0x00,
    0x00, 0x00, 0x58, 0xff, 0xff, 0xf2, 0xbf, 0x34,
    0x7b, 0xf3, 0x10, 0x74, 0x07, 0x45, 0xc5, 0x40
  };

  static const char DUMMY_DATA[32] =
  { 0x44, 0x4a, 0x56, 0x55, 0x49, 0x4e, 0x46, 0x4f,
    0x00, 0x00, 0x00, 0x0a, 0x00, 0x01, 0x00, 0x01,
    0x18, 0x00, 0x2c, 0x01, 0x16, 0x00, 0x53, 0x6a,
    0x62, 0x7a, 0x00, 0x00, 0x00, 0x02, 0xbb, 0x7f
  };

}

// vim:ts=2 sw=2 et
