/* Test of u16_vasnprintf() function in an ISO-8859-1 locale.
   Copyright (C) 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2007.  */

#include <config.h>

#include "unistdio.h"

#include <locale.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "unistr.h"

#define SIZEOF(array) (sizeof (array) / sizeof (array[0]))
#define ASSERT(expr) \
  do									     \
    {									     \
      if (!(expr))							     \
        {								     \
          fprintf (stderr, "%s:%d: assertion failed\n", __FILE__, __LINE__); \
          abort ();							     \
        }								     \
    }									     \
  while (0)

static void
test_function (uint16_t * (*my_asnprintf) (uint16_t *, size_t *, const char *, ...))
{
  /* Test the support of the 's' conversion specifier for strings.  */

  {
    const char *locale_string = "\304rger"; /* Ärger */
    {
      size_t length;
      uint16_t *result =
	my_asnprintf (NULL, &length, "%s %d", locale_string, 33, 44, 55);
      static const uint16_t expected[] =
	{ 0x00c4, 'r', 'g', 'e', 'r', ' ', '3', '3', 0 };
      ASSERT (result != NULL);
      ASSERT (u16_strcmp (result, expected) == 0);
      ASSERT (length == u16_strlen (result));
      free (result);
    }
    { /* Width.  */
      size_t length;
      uint16_t *result =
	my_asnprintf (NULL, &length, "%10s %d", locale_string, 33, 44, 55);
      static const uint16_t expected[] =
	{ ' ', ' ', ' ', ' ', ' ', 0x00c4, 'r', 'g', 'e', 'r',
	  ' ', '3', '3', 0
	};
      ASSERT (result != NULL);
      ASSERT (u16_strcmp (result, expected) == 0);
      ASSERT (length == u16_strlen (result));
      free (result);
    }
    { /* FLAG_LEFT.  */
      size_t length;
      uint16_t *result =
	my_asnprintf (NULL, &length, "%-10s %d", locale_string, 33, 44, 55);
      static const uint16_t expected[] =
	{ 0x00c4, 'r', 'g', 'e', 'r', ' ', ' ', ' ', ' ', ' ',
	  ' ', '3', '3', 0
	};
      ASSERT (result != NULL);
      ASSERT (u16_strcmp (result, expected) == 0);
      ASSERT (length == u16_strlen (result));
      free (result);
    }
    { /* FLAG_ZERO: no effect.  */
      size_t length;
      uint16_t *result =
	my_asnprintf (NULL, &length, "%010s %d", locale_string, 33, 44, 55);
      static const uint16_t expected[] =
	{ ' ', ' ', ' ', ' ', ' ', 0x00c4, 'r', 'g', 'e', 'r',
	  ' ', '3', '3', 0
	};
      ASSERT (result != NULL);
      ASSERT (u16_strcmp (result, expected) == 0);
      ASSERT (length == u16_strlen (result));
      free (result);
    }
  }
}

static uint16_t *
my_asnprintf (uint16_t *resultbuf, size_t *lengthp, const char *format, ...)
{
  va_list args;
  uint16_t *ret;

  va_start (args, format);
  ret = u16_vasnprintf (resultbuf, lengthp, format, args);
  va_end (args);
  return ret;
}

static void
test_vasnprintf ()
{
  test_function (my_asnprintf);
}

int
main (int argc, char *argv[])
{
  /* configure should already have checked that the locale is supported.  */
  if (setlocale (LC_ALL, "") == NULL)
    return 1;

  test_vasnprintf ();
  return 0;
}
