/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_)

Copyright 2008 SciberQuest Inc.
*/
#ifndef __pqSQTensorGlyph_h
#define __pqSQTensorGlyph_h

// std::cout debugging
#include <iostream>

// Qt Includes.
#include <QCheckBox>
#include <QWidget>
#include <QLabel>
#include <QtDebug>

// ParaView Includes.
#include <pqAutoGeneratedObjectPanel.h>
#include <vtkPVConfig.h>


/// Custom panel for TensorGlyph filter.
/// This panel is only provided to add capabilities to hide/gray out
/// GUI elements in case they do not apply and to link the checkbox
/// FixedThetaPhiRoundness to GammaRoundness/ThetaRoundness/PhiRoundness.
class pqSQTensorGlyph : public pqAutoGeneratedObjectPanel
{
  Q_OBJECT;
  typedef pqAutoGeneratedObjectPanel Superclass;

public:
  pqSQTensorGlyph(pqProxy *proxy, QWidget *p);


protected:
  QCheckBox *ColorGlyphsWidget;
  QCheckBox *LimitScalingByEigenvaluesWidget;

  QWidget* ColorModeWidget;
  QLabel*  ColorModeLabel;
  QWidget* MaxScaleFactorWidget;
  QLabel*  MaxScaleFactorLabel;

};

#endif
