// REFERENCE: Nemerle.Compiler

using Nemerle.Compiler;
using Nemerle.Collections;

namespace DesignPatterns
{
  [Nemerle.MacroUsage (Nemerle.MacroPhase.BeforeInheritance,
                       Nemerle.MacroTargets.Field)]
  macro Bridge (t : TypeBuilder, f : ParsedField, params forwards : array [PExpr])
  {
    foreach (definition in forwards)
      match (definition) {
        | <[ ($(from : name), $(to : name)) ]>  =>
          t.Define (<[ decl:
            public virtual $(from : name) () : void {
              this.$(f.ParsedName : name).$(to : name) ()
            }
          ]>)

        | <[ ($(from : name) (..$parms), $(to : name)) ]>  =>
          // expressions are not exactly parameters, but can be easily transformed
          def fparms = List.Map (parms, Parsetree.Fun_parm);
          
          t.Define (<[ decl:
            public virtual $(from : name) (..$fparms) : void {
              this.$(f.ParsedName : name).$(to : name) (..$parms)
            }
          ]>)
          
        | _ => Message.Error ("expected `(current_method, field_method)' pairs in parameters")
      }
    } 
  }
}
