using System;

namespace POP3Client
{
  public class MailHeader : MailParser
  {
    protected mutable returnPath  : string;
    protected mutable messageID   : string;
    protected mutable from        : Person;
    protected mutable to          : Person;
    protected mutable subject     : string;
    protected mutable date        : DateTime;
    protected mutable contentType : ContentType;
    protected mutable boundary    : string;


    public this (header : string)
    {
      base (header);
      
      returnPath  = GetHeaderParameterValue ("Return-Path");
      messageID   = GetHeaderParameterValue ("Message-id");
      from        = Person (GetHeaderParameterValue ("From"));
      to          = Person (GetHeaderParameterValue ("To"));
      subject     = GetHeaderParameterValue ("Subject");
      contentType = ContentType (GetHeaderParameter ("Content-Type"));

      try
      {
        date = DateTime.Parse (GetHeaderParameterValue ("Date").Split (",+-".ToCharArray ())[1]);
      }
      catch
      {
        | _  => date = DateTime ((0 :> long));
//            Console.WriteLine ("EEEEEEEEEEEEE");
      };

      if (contentType != null) boundary = "--" + contentType.GetExtraValue ("boundary")
      else boundary = null;
      
//      Console.WriteLine ("End Con");
    }


    public IsToday () : bool
    {
      if (date.Ticks == (0 :> long)) false
      else date.Date.Equals (DateTime.Now.Date);
    }
    
    
    public Sender : Person
    {
      get { from }
    }


    public Adreessee : Person
    {
      get { to }
    }
  }
}
