using System;
using System.Collections.Specialized;

namespace POP3Client
{
  public class HeaderParameter
  {
    mutable name   : string;
    mutable value  : string;
    mutable extras : StringDictionary;

    public this (line : string)
    {
      mutable splitted  = line.Split (";".ToCharArray ());
      mutable parameter = splitted[0].Split (":".ToCharArray (), 2);

      if (parameter.Length == 1) throw FormatException ()
      else {};
      
      name  = parameter[0];
      value = parameter[1].Trim ();

      if (splitted.Length > 1) extras = StringDictionary ()
      else {};
      
      for (mutable i = 1; i < splitted.Length; i = i + 1)
      {
        try
        {
          parameter = splitted[i].Trim ().Split ("=".ToCharArray ());
          
          if (parameter.Length == 1) extras.Add (parameter[0], null)
          else extras.Add (parameter[0], parameter[1].Trim ("\"".ToCharArray ()));
        }
        catch 
        {
          | _e => {}
        };
      };
    }

    public Name : string
    {
      get { name }
    }

    public Value : string
    {
      get { value }
    }

    public Additional : StringDictionary
    {
      get{ extras }
    }
  }
}
