using Nemerle.IO;
using Nemerle.Collections;

variant X  {
  | A
  | B
  | C
}

module M {
  f1 (x : X * X) : void {
    match (x) { // W: matching is not exhaustive
      | (_, X.A) => () // OK
      | (X.B, _) => () // OK
      | (X.A, X.B) => () // OK
      | (X.A, X.A) => () // W: this match clause is unused
      | (X.A, X.C) => () // OK
      | (X.C, X.C) => () // OK
    } 
  }
  
  f2 (x : X * X) : void {
    match (x) {
      | (_, X.A) => () // OK
      | (X.B, _) => () // OK
      | (X.A, X.B) => () // OK
      | (X.A, X.A) => () // W: this match clause is unused
      | (X.A, X.C) => () // OK
      | (X.C, X.C) => () // OK
      | (X.C, X.B) => () // OK
    } // OK
  }
  
  f3 (x : X * X) : void {
    match (x) {
      | _ => () // OK
      | (X.A, X.A) => () // W: this match clause is unused
    } // OK
  }

  f4 (x : X * X) : void {
    | (X.A,X.A) => () // OK
    | _ => () // OK
    | (X.B,X.B) => () // W: this match clause is unused
  } // OK

  f4 (x : X, y : X, z : X) : void { // W: matching is not exhaustive
    | (X.A,X.B,X.C) => () // OK
    | (X.B,X.C,X.A) => () // OK
  } 

  Main () : void { 
    def g (a : int, b : int) {
      | (1, 2) => printf ("jea\n")
      | _ => printf ("noa\n")
    };

    def c = (1,2);
    g (c);

    List.Iter ([(2,2), (2,2)],
               fun (x, y) { | (2,2) => printf ("jeaa\n"); | _ => printf ("noaa\n") });
  }
}

/*
BEGIN-OUTPUT
jea
jeaa
jeaa
END-OUTPUT
*/
