using Nemerle.Utility;

[System.Flags]
enum SomeFlags {
  | Flag1 = 0x01
  | Flag2 = 0x02
  | Flag3 = 0x04
  | FlagAll = 0xff
}

interface IFoo
{
  Foo : int { get; }
  Bar : string { get; set; }
}

class D : IFoo
{
  [Accessor]
  foo : int = 42;

  [Accessor (flags = WantSetter)]
  mutable bar : string = "qux";
}

class C
{
  [Accessor]
  some_field : int = 42;

  [Accessor (flags = WantSetter)]
  mutable some_other : bool;

  [Accessor (Xyz, flags = WantSetter | Internal)]
  mutable __some_other : string = "kopytko";

  [Accessor (flags = WantSetter | Internal)]
  static mutable static_field : string = "foo";


  [FlagAccessor (Flag1, Flag2, flags = WantSetter | Protected)]
  [FlagAccessor (Flag3)]
  mutable flags : SomeFlags;


  public static Main () : void
  {
    System.Console.WriteLine (StaticField);
    StaticField = "bar";
    System.Console.WriteLine (StaticField);

    def c = C ();

    System.Console.WriteLine (c.SomeField);
    System.Console.WriteLine (c.SomeOther);
    System.Console.WriteLine (c.Xyz);
    c.Xyz = "qux";
    c.SomeOther = true;
    System.Console.WriteLine (c.SomeField);
    System.Console.WriteLine (c.SomeOther);
    System.Console.WriteLine (c.Xyz);

    assert (typeof (C).GetMethod ("set_SomeField") == null);
    assert (typeof (C).GetMethod ("get_SomeField") != null);

    assert (!c.Flag1);
    assert (!c.Flag2);
    assert (!c.Flag3);
    c.flags = SomeFlags.FlagAll;
    assert (c.Flag1);
    assert (c.Flag2);
    assert (c.Flag3);
    c.Flag1 = false;
    assert (!c.Flag1);
    assert (typeof (C).GetMethod ("set_Flag3") == null);
  }

}

/*
BEGIN-OUTPUT
foo
bar
42
False
kopytko
42
True
qux
END-OUTPUT
*/
