using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

[Serializable]
public class Tuple [a,b] {
  public  mutable  field1 : a;
  public  mutable  field2 : b;

  public this (mutable  x : a,mutable  y :  b) {
    field1 = x;
    field2 = y;
  }
}


public class Test {
   public static Main() :  void  {

      //Creates a new TestSimpleObject object.
      mutable  obj =  TestSimpleObject();

      Console.WriteLine("Before serialization the object contains: ");
      obj.Print();

      //Opens a file and serializes the object into it in binary format.
      mutable  stream = File.Open("data.xml", FileMode.Create);
      mutable  formatter =  BinaryFormatter();

      //BinaryFormatter formatter = new BinaryFormatter();

      formatter.Serialize(stream, obj);
      stream.Close();
   
      //Empties obj.
      obj = null;
   
      //Opens file "data.xml" and deserializes the object from it.
      stream = File.Open("data.xml", FileMode.Open);
      formatter =  BinaryFormatter();

      //formatter = new BinaryFormatter();

      obj = (formatter.Deserialize(stream) :> TestSimpleObject);
      stream.Close();

      Console.WriteLine("");
      Console.WriteLine("After deserialization the object contains: ");
      obj.Print();
   }
}


// A test object that needs to be serialized.
[Serializable()]        
public class TestSimpleObject  {

    public  mutable   member6 : Tuple [string,int];
    
    public this() {
        member6 =  Tuple ("aa", 22);
    }


    public Print() :  void {
        Console.WriteLine("member6 = '{0}'", member6.GetType ().Name);
    }
}
/*
BEGIN-OUTPUT
Before serialization the object contains:
member6 = 'Tuple`2'

After deserialization the object contains:
member6 = 'Tuple`2'
END-OUTPUT
*/
