using Nemerle.Diagnostics;
delegate Fng (_ : int, _ : int) : int;
delegate Fg[X,Y,Z] (_ : X, _ : Y) : Z;
abstract class  Func {
  public abstract apply(_:int,_:int) : int;
}
class FuncFn : Func {
  public override apply (a:int,b:int):int { (a+b) % 8373 }
} 
abstract class  FuncNg {
  public abstract apply(_:object,_:object) : object;
}
class FuncNgFn : FuncNg {
  public override apply (a:object,b:object):object { (a:>int+b:>int) % 8373  }
} 
module NormalNemerleFun {
  Pass[T] (ini : T, fn : T * T -> T) : T
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (fn (acc, acc), n - 1)
    }
    loop (ini, 50000000)
  }

  PassNG (ini : int, fn : int * int -> int) : int
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (fn (acc, acc), n - 1)
    }
    loop (ini, 50000000)
  }

  PassFng (ini : int, fn : Fng) : int
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (fn (acc, acc), n - 1)
    }
    loop (ini, 50000000)
  }

  PassFg (ini : int, fn : Fg[int,int,int]) : int
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (fn (acc, acc), n - 1)
    }
    loop (ini, 50000000)
  }

  PassC (ini : int, fn : Func) : int
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (fn.apply (acc, acc), n - 1)
    }
    loop (ini, 50000000)
  }

  PassCB (ini : object, fn : FuncNg) : int
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (fn.apply (acc, acc), n - 1)
    }
    loop (ini, 50000000) :> int
  }

  public Run () : void
  {
    time System.Console.WriteLine (PassC (1, FuncFn()));
    time System.Console.WriteLine (Pass (1, fun (x, y) { (x + y) % 7363 }));
    time System.Console.WriteLine (PassNG (1, fun (x, y) { (x + y) % 7363 }));
    time System.Console.WriteLine (PassFng (1, fun (x, y) { (x + y) % 7363 }));
    time System.Console.WriteLine (PassFg (1, fun (x, y) { (x + y) % 7363 }));
    time System.Console.WriteLine (PassCB (1, FuncNgFn ()));
  }
}

NormalNemerleFun.Run ();
