unit MyxAppOptions;

interface

uses MyxOptions, AuxFuncs, TntForms;

type
  TMyxAppOptions = class(TMyxOptions)
  protected
    procedure SetFixedOptions; override;
    procedure SetDefaultOptions; override;
  end;

  function AppOptions: TMyxOptions;

implementation

var
  OptionsInstance: TMyxOptions;

// -----------------------------------------------------------------------------

function AppOptions: TMyxOptions;

begin
  if (OptionsInstance = nil) then
  begin
    // Make sure /app exists
    GlobalAppDict;

    OptionsInstance := TMyxAppOptions.Create(
      CommonOptions.OptionString['UserDataDir'] +
        TntApplication.Title + ' Options.xml',
      '/app/options');
  end;

  Result := OptionsInstance;
end;

// -----------------------------------------------------------------------------
// TMyxAppOptions
// -----------------------------------------------------------------------------

procedure TMyxAppOptions.SetFixedOptions;

begin
  //
end;

// -----------------------------------------------------------------------------

procedure TMyxAppOptions.SetDefaultOptions;

begin
  DefaultOptions.Add('DefaultModelBaseWidth=10000');
  DefaultOptions.Add('DefaultModelBaseHeight=7000');

  DefaultOptions.Add('PkColumnNameTemplate=id%tablename%');
  DefaultOptions.Add('FKNameTemplate=FK%table%');
  DefaultOptions.Add('FKColumnNameTemplate=FK%table%%column%');  

  DefaultOptions.Add('Rel1nSourceOptional=1');
  DefaultOptions.Add('Rel1nTargetOptional=0');
  DefaultOptions.Add('Rel11SourceOptional=1');
  DefaultOptions.Add('Rel11TargetOptional=0');
  DefaultOptions.Add('RelnmSourceOptional=1');
  DefaultOptions.Add('RelnmTargetOptional=1');

  DefaultOptions.Add('DockGrtShell=1');
  DefaultOptions.Add('DockGrtShellAutoAddSnippets=0');
  DefaultOptions.Add('DockEditors=1');

  DefaultOptions.Add('SideBarOneWidth=1');
  DefaultOptions.Add('SideBarWidthView=230');
  DefaultOptions.Add('SideBarWidthGrtShell=350');

  DefaultOptions.Add('EditorPanelHeight=280');

  DefaultOptions.Add('InitialZoom=0.75');

  DefaultOptions.Add('DefaultRbdms=Mysql');
  DefaultOptions.Add('DefaultRbdmsVersion=5.1.6');

  DefaultOptions.Add('FKDeleteRule=NO ACTION');
  DefaultOptions.Add('FKUpdateRule=NO ACTION');

  DefaultOptions.Add('AuxTableTemplate=%stable%_has_%dtable%');
end;

// -----------------------------------------------------------------------------

end.
