unit DatabaseSynchronisation;

interface

uses
  GnuGetText, Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs,  TntForms, ExtCtrls, StdCtrls, TntStdCtrls,
  ComCtrls, TntComCtrls, TntExtCtrls,
  myx_public_interface, myx_grt_public_interface,
  MyxBaseForm, MyxConnectionDialog,
  PngImage, PngTools, Grt, ImgList, AdvancedEdit,
  MigrationObjSelFilter, AuxFuncs, VirtualTrees, UniCodeEditor,
  UCEHighlighter, UCESQLHighlighter;

type
  TDatabaseSynchronisationForm = class(TMyxBaseForm)
    MainPageControl: TTntPageControl;
    ConnectionSheet: TTntTabSheet;
    ConnParamGBox: TTntGroupBox;
    JdbcDriverDescLbl: TTntLabel;
    DriverParamHeaderLbl: TTntLabel;
    SourceTargetDBConnImg: TTntImage;
    ParamSBox: TTntScrollBox;
    DBConnAdvancedSettingsGBox: TTntGroupBox;
    AdvParamSBox: TTntScrollBox;
    SchemataSheet: TTntTabSheet;
    FinalizeSheet: TTntTabSheet;
    BottomPnl: TTntPanel;
    NextBtn: TTntButton;
    BackBtn: TTntButton;
    CancelBtn: TTntButton;
    HeaderPanel: TTntPanel;
    TntShape1: TTntShape;
    PageTitleLbl: TTntLabel;
    PageDescLbl: TTntLabel;
    GetSchemataSheet: TTntTabSheet;
    TntGroupBox1: TTntGroupBox;
    TntBevel1: TTntBevel;
    TntLabel3: TTntLabel;
    TntLabel7: TTntLabel;
    ConnImg: TTntImage;
    TntLabel8: TTntLabel;
    SchemaListImg: TTntImage;
    TntLabel4: TTntLabel;
    ResultLbl: TTntLabel;
    ProgressLbl: TTntLabel;
    AdvancedBtn: TTntButton;
    MessageLogGBox: TTntGroupBox;
    GRTMessageMemo: TTntMemo;
    RdbmsDriverGBox: TTntGroupBox;
    TntBevel2: TTntBevel;
    AnimPnl: TTntPanel;
    AnimStillImg: TTntImage;
    BusyAnimate: TAnimate;
    Shape1: TTntShape;
    TntGroupBox5: TTntGroupBox;
    SchemaSelectionCountLbl: TTntLabel;
    SchemaListView: TTntListView;
    SchemaSearchEd: TAdvancedEditFrame;
    ShowSchemataAsListCBox: TTntCheckBox;
    SmallSchemaListViewImgList: TImageList;
    SchemaListViewImgList: TImageList;
    RevEngSheet: TTntTabSheet;
    TntGroupBox2: TTntGroupBox;
    TntLabel5: TTntLabel;
    TntLabel6: TTntLabel;
    RevEngImg: TTntImage;
    TntLabel9: TTntLabel;
    GetCatalogChangesImg: TTntImage;
    TntLabel10: TTntLabel;
    Result2Lbl: TTntLabel;
    Progress2Lbl: TTntLabel;
    RevEngMsgLogGBox: TTntGroupBox;
    GRTMessage2Memo: TTntMemo;
    TntGroupBox4: TTntGroupBox;
    TntLabel15: TTntLabel;
    TntLabel16: TTntLabel;
    TntLabel11: TTntLabel;
    TntImage2: TTntImage;
    TntImage4: TTntImage;
    TntLabel1: TTntLabel;
    SynchronizationImg: TTntImage;
    MigrationLbl: TTntLabel;
    MessageLogFinalizeGBox: TTntGroupBox;
    GRTMessage3Memo: TTntMemo;
    ResultFinalizeLbl: TTntLabel;
    Progress3Lbl: TTntLabel;
    SyncSheet: TTntTabSheet;
    ChangesTree: TVirtualStringTree;
    AlterSQLSheet: TTntTabSheet;
    AlterSQLEditBox: TUniCodeEdit;
    UCESQLHighlighter1: TUCESQLHighlighter;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    procedure NextBtnClick(Sender: TObject);
    procedure BackBtnClick(Sender: TObject);
    procedure AdvancedBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure SchemaSearchEdSearchEdChange(Sender: TObject);
    procedure ShowSchemataAsListCBoxClick(Sender: TObject);
    procedure SchemaListViewClick(Sender: TObject);
    procedure SchemaListViewSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ChangesTreeGetText(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure ChangesTreeClick(Sender: TObject);
    procedure ChangesTreeAfterCellPaint(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      CellRect: TRect);
  private
    FMyxConnDlgForm: TMyxConnectionDialogForm;

    FCancelOperation: Boolean;

    FConnection,
    FSchemaList,
    FCatalog,
    FChangesTree: Pointer;

    FBackBtnEnabled,
    FNextBtnEnabled: Boolean;

    FTaskUncheckedPNGImg,
    FTaskCheckedPNGImg,
    FTaskErrorPNGImg,
    FTaskDisabledPNGImg: TPngObject;

    FNormalHeight,
    FAdvancedHeight: Integer;

    FFilterFrames: TList;

    // Task management
    FFetchSchemaTask: IGrtTask;
    FReverseEngineerTask: IGrtTask;
    FGetCatalogChangesTask: IGrtTask;
    FGetSQLChangesTask: IGrtTask;
    FApplySQLChangesTask: IGrtTask;

    FSelectedSchemaList: Pointer;

    FTreeBtnOpenPNGImg,
    FTreeBtnClosedPNGImg,
    FGrtValueStructPNGImg: TPNGObject;


    function BuildChangesTree(Parent: PVirtualNode; GrtDictObject: Pointer): Boolean;
    procedure ShowSQL;
    function GetAlterSQLFromChangesTree(Node: Pointer): WideString;
    procedure ShowSQLExecutionStatus;
    function CollectAndShowErrorMessages(Node: PVirtualNode): Boolean;

  protected

    procedure UpdateAdvancedBtnState;
    procedure UpdateSchemaSelectionCountLbl;
    procedure UpdatePageHeader;

    procedure DoFetchSchemaNames;
    procedure DoDisplaySchemata;
    procedure DoRevEng;
    procedure DoBuildSyncSelection;
    procedure DoBuildAlterSQL;
    procedure DoFinalizeRevEng;

    procedure ProcessGrtOutput(Text: WideString);
    procedure ProcessGrtMessages(Messages: TMYX_GRT_MSGS);
    function ProcessStatusQuery: Integer;

    procedure RefreshSchemaListView(SearchStr: WideString = '');

    procedure DoProcessStart;
    procedure DoProcessEnd;

    function AdvancedSectionsVisible: Boolean;

    function PerformGrtInput(Description: WideString): WideString;

    procedure TaskFinished(Task: IGrtGenericTask);
    function TaskHandleError(Task: IGrtGenericTask): Boolean;
  public
  end;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.FormCreate(Sender: TObject);

var
  DBSync: Pointer;
  Col: TVirtualTreeColumn;
begin
  FSchemaList := nil;
  FCatalog := nil;

  FNormalHeight := 512 + 80;
  FAdvancedHeight := 686 + 80;

  LoadPNGImageFromResource('sakila', AnimStillImg, True);
  BusyAnimate.ResName:='dolphin_loop';

  LoadPNGImageFromResource('source_dbconn', SourceTargetDBConnImg, True);

  FTaskUncheckedPNGImg := LoadPNGImageFromResource('task_unchecked');
  FTaskCheckedPNGImg := LoadPNGImageFromResource('task_checked');
  FTaskErrorPNGImg := LoadPNGImageFromResource('task_error');
  FTaskDisabledPNGImg := LoadPNGImageFromResource('task_disabled');

  FCancelOperation := False;

  FFilterFrames := TList.Create;

  MainPageControl.ActivePage := ConnectionSheet;

  // Dock connection form
  FMyxConnDlgForm := TMyxConnectionDialogForm.Create(nil);

  FMyxConnDlgForm.ConnInfoPath := '/rdbmsMgmt';
  FMyxConnDlgForm.ConnTargetPath :='/workbench/connection';

  FMyxConnDlgForm.DisplayRdbmsSelection := True;
  FMyxConnDlgForm.DisplaySchemaSelection := False;
  FMyxConnDlgForm.DisplayDescriptions := True;

  FMyxConnDlgForm.ConnTypePnl.Parent := RdbmsDriverGBox;
  FMyxConnDlgForm.ConnTypePnl.Left := 28;
  FMyxConnDlgForm.ConnTypePnl.Width := RdbmsDriverGBox.Width - 40;

  FMyxConnDlgForm.StoredConnPnl.Parent := ParamSBox;
  FMyxConnDlgForm.StoredConnPnl.Top := 0;

  FMyxConnDlgForm.ParamsPnl.Parent := ParamSBox;
  FMyxConnDlgForm.ParamsPnl.Top := FMyxConnDlgForm.StoredConnPnl.Height;
  FMyxConnDlgForm.ParamsPnl.Width := ParamSBox.Width - 20;

  FMyxConnDlgForm.AdvParamPnl.Parent := AdvParamSBox;
  FMyxConnDlgForm.AdvParamPnl.Top := 0;
  FMyxConnDlgForm.AdvParamPnl.Width := AdvParamSBox.Width - 30;

  FMyxConnDlgForm.DriverNotInstalledPnl.Parent := ParamSBox;
  FMyxConnDlgForm.DriverNotInstalledPnl.Top := 0;

  FMyxConnDlgForm.OkButton := NextBtn;

  FMyxConnDlgForm.RefreshConnInfo;

  FMyxConnDlgForm.SelectedRdbms := 'Mysql';

  Height := FNormalHeight;

  // Create migration object and add it to the globals tree
  DBSync := Grt.ObjectNew('db.DatabaseSync',
    'DatabaseSync', '', '');
  Grt.Global['/databaseSync'] := DBSync;
  Grt.ValueRelease(DBSync);

  {Migration := Grt.ObjectNew('db.migration.Migration',
    'Migration', '', '');
  Grt.Global['/migration'] := Migration;
  Grt.ValueRelease(Migration);}

  ChangesTree.NodeDataSize := SizeOf(Pointer);
  Col := ChangesTree.Header.Columns.Add;
  Col.Text := 'Database Object';
  Col.Width := 200;
  Col := ChangesTree.Header.Columns.Add;
  Col.Text := 'Model Object';
  Col.Width := 200;
  Col := ChangesTree.Header.Columns.Add;
  Col.Text := 'Action';
  Col.Width := 100;

  FGrtValueStructPNGImg := LoadPNGImageFromResource('grt_value_struct');
  FTreeBtnOpenPNGImg := LoadPNGImageFromResource('tree_button_open');
  FTreeBtnClosedPNGImg := LoadPNGImageFromResource('tree_button_closed');
   
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.FormDestroy(Sender: TObject);

begin
  FTaskUncheckedPNGImg.Free;
  FTaskCheckedPNGImg.Free;
  FTaskErrorPNGImg.Free;
  FTaskDisabledPNGImg.Free;

  FFilterFrames.Free;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Grt.GlobalDel('/', 'databaseSync');
  Grt.ValueRelease(FCatalog);

  if (FSchemaList <> nil) then
    Grt.ValueRelease(FSchemaList);

  if (FCatalog <> nil) then
    Grt.ValueRelease(FCatalog);
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.NextBtnClick(Sender: TObject);

begin
  BackBtn.Enabled := True;

  if (MainPageControl.ActivePage = ConnectionSheet) then
    DoFetchSchemaNames
  else
    if (MainPageControl.ActivePage = GetSchemataSheet) then
      DoDisplaySchemata
    else
      if (MainPageControl.ActivePage = SchemataSheet) then
        DoRevEng
      else
        if (MainPageControl.ActivePage = RevEngSheet) then
          DoBuildSyncSelection
        else
          if (MainPageControl.ActivePage = SyncSheet) then
            DoBuildAlterSQL
          else
            if (MainPageControl.ActivePage = AlterSQLSheet) then
              DoFinalizeRevEng
          else
            if (MainPageControl.ActivePage = FinalizeSheet) then
              Close;

  UpdatePageHeader;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.BackBtnClick(Sender: TObject);

begin
  if (MainPageControl.ActivePageIndex > 0) then
    MainPageControl.ActivePageIndex :=
      MainPageControl.ActivePageIndex - 1;

  if (MainPageControl.ActivePageIndex = 0) then
    BackBtn.Enabled := False;

  NextBtn.Enabled := True;
  NextBtn.Caption := _('Next'); // could be changed to 'Finish'

  UpdateAdvancedBtnState;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.CancelBtnClick(Sender: TObject);

begin
  FCancelOperation := True;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.AdvancedBtnClick(Sender: TObject);

begin
  if (MainPageControl.ActivePage = ConnectionSheet) then
    DBConnAdvancedSettingsGBox.Visible :=
      Not(DBConnAdvancedSettingsGBox.Visible)
  else
    if (MainPageControl.ActivePage = GetSchemataSheet) then
      MessageLogGBox.Visible :=
        Not(MessageLogGBox.Visible)
    else
      if (MainPageControl.ActivePage = RevEngSheet) then
        RevEngMsgLogGBox.Visible :=
          Not(RevEngMsgLogGBox.Visible)
      else
        if (MainPageControl.ActivePage = FinalizeSheet) then
          MessageLogFinalizeGBox.Visible :=
            Not(MessageLogFinalizeGBox.Visible);

  UpdateAdvancedBtnState;
end;

// -----------------------------------------------------------------------------

function TDatabaseSynchronisationForm.AdvancedSectionsVisible: Boolean;

begin
  case MainPageControl.ActivePageIndex of
    0:
      Result := DBConnAdvancedSettingsGBox.Visible;
    1:
      Result := MessageLogGBox.Visible;
    3:
      Result := RevEngMsgLogGBox.Visible;
  else
    Result := False;
  end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.UpdateAdvancedBtnState;

begin
  AdvancedBtn.Enabled := (MainPageControl.ActivePage <> SchemataSheet);

  if (AdvancedSectionsVisible) then
  begin
    AdvancedBtn.Caption := _('<< Advanced');

    Height := FAdvancedHeight;

    DBConnAdvancedSettingsGBox.Height := Height - (686 - 161);
    DBConnAdvancedSettingsGBox.Anchors :=
      [akLeft, akTop, akRight, akBottom];
  end
  else
  begin
    AdvancedBtn.Caption := _('Advanced >>');

    Height := FNormalHeight;
  end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.UpdatePageHeader;

begin
  if (MainPageControl.ActivePage = ConnectionSheet) then
  begin
    PageTitleLbl.Caption := _('Source Connection');
    PageDescLbl.Caption := _('Please specify the source connection.');
  end
  else
    if (MainPageControl.ActivePage = GetSchemataSheet) then
    begin
      PageTitleLbl.Caption := _('Source Schemata');
      PageDescLbl.Caption := _('The list of available schemata is fetched.');
    end
    else
      if (MainPageControl.ActivePage = SchemataSheet) then
      begin
        PageTitleLbl.Caption := _('Schema Selection');
        PageDescLbl.Caption := _('Please select the schema(ta) to reverse engineer.');
      end
      else
        if (MainPageControl.ActivePage = RevEngSheet) then
        begin
          PageTitleLbl.Caption := _('Reverse Engineering');
          PageDescLbl.Caption := _('The selected schema(ta) are reverse engineered.');
        end
        else
          if (MainPageControl.ActivePage = SyncSheet) then
          begin
            PageTitleLbl.Caption := _('Synchronize');
            PageDescLbl.Caption := _('Specify the changes on the model and database side.');
          end
          else
            if (MainPageControl.ActivePage = FinalizeSheet) then
            begin
              PageTitleLbl.Caption := _('Finalization');
              PageDescLbl.Caption := _('Finalizing the synchronizing process.');
            end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ProcessGrtOutput(Text: WideString);

begin
  if (MainPageControl.ActivePage = GetSchemataSheet) then
    GRTMessageMemo.Lines.Add(Text)
  else
    if (MainPageControl.ActivePage = RevEngSheet) then
      GRTMessage2Memo.Lines.Add(Text)
    else
      if (MainPageControl.ActivePage = FinalizeSheet) then
      GRTMessage3Memo.Lines.Add(Text)
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ProcessGrtMessages(
  Messages: TMYX_GRT_MSGS);

begin
  // display last message in ResultLbl
  if (Messages.msgs.Count > 0) then
  begin
    if (MainPageControl.ActivePage = GetSchemataSheet) then
    begin
      ProgressLbl.Caption := Messages.msgs[Messages.msgs.Count - 1].msg;
      ProgressLbl.Update;

      GRTMessageMemo.Text := GRTMessageMemo.Text +
        FormatGrtMessagesAsString(Messages);
      GRTMessageMemo.Update;
    end
    else
      if (MainPageControl.ActivePage = RevEngSheet) then
      begin
        Progress2Lbl.Caption := Messages.msgs[Messages.msgs.Count - 1].msg;
        Progress2Lbl.Update;

        GRTMessage2Memo.Text := GRTMessage2Memo.Text +
          FormatGrtMessagesAsString(Messages);
        GRTMessage2Memo.Update;
      end
      else
        if (MainPageControl.ActivePage = FinalizeSheet) then
        begin
          Progress3Lbl.Caption := Messages.msgs[Messages.msgs.Count - 1].msg;
          Progress3Lbl.Update;

          GRTMessage3Memo.Text := GRTMessage3Memo.Text +
            FormatGrtMessagesAsString(Messages);
          GRTMessage3Memo.Update;
        end;
  end;
end;

// -----------------------------------------------------------------------------

function TDatabaseSynchronisationForm.ProcessStatusQuery: Integer;

begin
  Result := Ord(FCancelOperation);
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.SchemaSearchEdSearchEdChange(
  Sender: TObject);

begin
  SchemaSearchEd.SearchEdChange(Sender);

  RefreshSchemaListView(SchemaSearchEd.SearchEd.Text);
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ShowSchemataAsListCBoxClick(
  Sender: TObject);
begin
  if (ShowSchemataAsListCBox.Checked) then
    SchemaListView.ViewStyle:=vsList
  else
    SchemaListView.ViewStyle:=vsIcon;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.SchemaListViewClick(Sender: TObject);

begin
  UpdateSchemaSelectionCountLbl;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.UpdateSchemaSelectionCountLbl;

begin
  if (SchemaListView.SelCount=0) then
  begin
    SchemaSelectionCountLbl.Caption :=
      _('No schemata selected.');

    NextBtn.Enabled := False;
  end
  else
  begin
    if(SchemaListView.SelCount=1)then
      SchemaSelectionCountLbl.Caption :=
        _('1 schema selected.')
    else
      SchemaSelectionCountLbl.Caption :=
        Format(_('%d schemata selected.'), [SchemaListView.SelCount]);

    NextBtn.Enabled := True;
  end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.RefreshSchemaListView(SearchStr: WideString);

var
  I: integer;
  ListItem: TTntListItem;
  S: WideString;

begin
  SchemaListView.Clear;

  if (FSchemaList <> nil) then
  begin
    for I:=0 to Grt.ListCount(FSchemaList) - 1 do
    begin
      S := Grt.ListString[FSchemaList, I];

      if (SearchStr = '') or
        (myx_match_pattern(S, SearchStr + '*', 0, 1) = 1) then
      begin
        ListItem := SchemaListView.Items.Add;
        ListItem.Caption := S;
      end;
    end;
  end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.SchemaListViewSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);

begin
  UpdateSchemaSelectionCountLbl;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoProcessStart;

begin
  BusyAnimate.Show;
  BusyAnimate.Play(1, 74, -1);
  BusyAnimate.Active:=True;

  FBackBtnEnabled := BackBtn.Enabled;
  FNextBtnEnabled := NextBtn.Enabled;

  FCancelOperation := False;

  //WizardBottomFrame.DetailsBtn.Enabled := False;
  BackBtn.Enabled := False;
  NextBtn.Enabled := False;
  CancelBtn.Enabled := True;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoProcessEnd;

begin
  BusyAnimate.Hide;
  BusyAnimate.Stop;

  //WizardBottomFrame.DetailsBtn.Enabled := FDetailsBtnEnabled;
  BackBtn.Enabled := FBackBtnEnabled;
  NextBtn.Enabled := FNextBtnEnabled;
  CancelBtn.Enabled := False;

  FCancelOperation := False;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.FormResize(Sender: TObject);

begin
  if (AdvancedSectionsVisible) then
    FAdvancedHeight := Height
  else
    FNormalHeight := Height;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoFetchSchemaNames;

var
  RevEngModuleName: WideString;

begin
  FConnection := FMyxConnDlgForm.WriteConnectionToTarget;

  RevEngModuleName := Grt.DictString[Grt.DictItem[FConnection, 'modules'], 'ReverseEngineeringModule'];

  ConnImg.Picture.Assign(FTaskUncheckedPNGImg);
  SchemaListImg.Picture.Assign(FTaskUncheckedPNGImg);

  ResultLbl.Hide;
  GRTMessageMemo.Clear;
  ProgressLbl.Caption := '';
  ProgressLbl.Show;

  // Flip page
  MainPageControl.ActivePage := GetSchemataSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;

  Application.ProcessMessages;
  // if there already is a FSchemaList, release it
  if (FSchemaList <> nil) then
    Grt.ValueRelease(FSchemaList);

  FFetchSchemaTask := Grt.CreateStandardTask('Getting schemata list', RevEngModuleName, 'getSchemata',
    [Grt.GetGlobalAsParam('/workbench/connection')], ProcessGrtOutput, ProcessGrtMessages, False, True, -1, nil,
    ProcessStatusQuery, TaskFinished);
  Grt.AddTask(FFetchSchemaTask);
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoDisplaySchemata;

begin
  RefreshSchemaListView;

  NextBtn.Enabled := False;

  // Flip page
  MainPageControl.ActivePage := SchemataSheet;
  UpdateAdvancedBtnState;

  try
    if(SchemaListView.CanFocus)then
      SchemaListView.SetFocus;
  except
  end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoRevEng;

var
  RevEngModuleName: WideString;
  I: Integer;

begin
  RevEngModuleName := Grt.DictString[Grt.DictItem[FConnection, 'modules'], 'ReverseEngineeringModule'];

  RevEngImg.Picture.Assign(FTaskUncheckedPNGImg);
  GetCatalogChangesImg.Picture.Assign(FTaskUncheckedPNGImg);

  Result2Lbl.Hide;
  GRTMessageMemo.Clear;
  Progress2Lbl.Caption := '';
  Progress2Lbl.Show;

  // Flip page
  MainPageControl.ActivePage := RevEngSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;

  Application.ProcessMessages;

  FSelectedSchemaList := Grt.ListNew(GrtStringValue);
  for I := 0 to SchemaListView.Items.Count - 1 do
    if (SchemaListView.Items[I].Selected) then
      Grt.ListAdd(FSelectedSchemaList, Grt.ValueFromString(SchemaListView.Items[I].Caption), False);

  if (FCatalog <> nil) then
    Grt.ValueRelease(FCatalog);

  FReverseEngineerTask := Grt.CreateStandardTask(
    'Reverse engineering schema(ta)', RevEngModuleName, 'reverseEngineer',
    [Grt.GetGlobalAsParam('/workbench/connection'), FSelectedSchemaList],
    ProcessGrtOutput, ProcessGrtMessages, False,
    True, -1, nil, ProcessStatusQuery, TaskFinished);
  Grt.AddTask(FReverseEngineerTask);
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoBuildAlterSQL;

begin
  RevEngImg.Picture.Assign(FTaskUncheckedPNGImg);
  GetCatalogChangesImg.Picture.Assign(FTaskUncheckedPNGImg);

  Result2Lbl.Hide;
  GRTMessageMemo.Clear;
  Progress2Lbl.Caption := '';
  Progress2Lbl.Show;

  // Flip page
  MainPageControl.ActivePage := AlterSQLSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;

  Application.ProcessMessages;

  FGetSQLChangesTask := Grt.CreateStandardTask(
    'Building alter SQL', 'TransformationMysql', 'getSqlChanges',
    [FChangesTree],
    ProcessGrtOutput, ProcessGrtMessages, False,
    True, -1, nil, ProcessStatusQuery, TaskFinished);

  Grt.AddTask(FGetSQLChangesTask);
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.DoFinalizeRevEng;

begin
  SynchronizationImg.Picture.Assign(FTaskUncheckedPNGImg);

  ResultFinalizeLbl.Caption := '';
  ResultFinalizeLbl.Visible := True;

  // Flip page
  MainPageControl.ActivePage := FinalizeSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;
  //ResultFinalizeLbl.Caption := _('Removing ignored object from catalog');

  Application.ProcessMessages;

  FApplySQLChangesTask := Grt.CreateStandardTask(
    'Applying alter SQL', 'TransformationMysql', 'applySqlChanges',
    [FChangesTree, FConnection],
    ProcessGrtOutput, ProcessGrtMessages, False,
    True, -1, nil, ProcessStatusQuery, TaskFinished);

  Grt.AddTask(FApplySQLChangesTask);
end;

// -----------------------------------------------------------------------------

function TDatabaseSynchronisationForm.PerformGrtInput(Description: WideString): WideString;

var
  InputText: WideString;

begin
  InputText := '';

  ShowModalEditDialog(_('Input'),
    Description, myx_mtEdit,
    _('Ok'), True, '', InputText);

  Result := InputText;
end;

//----------------------------------------------------------------------------------------------------------------------

function TDatabaseSynchronisationForm.GetAlterSQLFromChangesTree(Node: Pointer): WideString;
var
 i: Integer;
 sql, ownsql: WideString;
 dbObj, child, children: Pointer;

begin
  sql := '';

  dbObj := Grt.DictRef[Node, 'dbObject'];
  if(dbObj = nil) then
    dbObj := Grt.DictRef[Node, 'modelObject'];

  if(dbObj <> nil) then
  begin
    ownsql := Grt.DictString[dbObj, 'sql'];
    if(ownsql <> '')then
      sql := sql + ownsql + #13 + #10;

    children := Grt.DictItem[Node, 'children'];

    if(children <> nil) then
      for i := 0 to Grt.ListCount(children) - 1 do
      begin
        child := Grt.ListItem[children, i];
        if(child <> nil)then
          sql := sql + GetAlterSQLFromChangesTree(child);
      end;
  end;

  Result := sql;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ShowSQL;
begin
  if(FChangesTree <> nil)then
    AlterSQLEditBox.Text := GetAlterSQLFromChangesTree(FChangesTree);
end;

//----------------------------------------------------------------------------------------------------------------------

function TDatabaseSynchronisationForm.CollectAndShowErrorMessages(Node: PVirtualNode): Boolean;
var
  Log, LogList, ListItem, children: Pointer;
  res: Boolean;
  i, c: Integer;
  s: WideString;
begin
  res := false;

  children := Grt.DictItem[Node, 'children'];
  c := Grt.ListCount(children) - 1;
  for i := 0 to c do
  begin
    res := CollectAndShowErrorMessages(Grt.ListItem[children, i]) or res;
  end;

  Log := Grt.DictItem[Node, 'syncLog'];
  if(Log <> nil) then
  begin
    LogList := Grt.DictItem[Log, 'entries'];
    if((LogList <> nil) and (Grt.ListCount(LogList) > 0)) then
    begin
      res := true;
      c := Grt.ListCount(LogList) - 1;
      for i := 0 to c do
      begin
        ListItem := Grt.ListItem[LogList, i];
        s := Grt.DictString[ListItem, 'name'];
        GRTMessage3Memo.Lines.Add(s);
        if(MessageLogFinalizeGBox.Visible = false)then
          MessageLogFinalizeGBox.Visible := true;
      end;
    end;
  end;
  Result := res;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ShowSQLExecutionStatus;
begin
  if(CollectAndShowErrorMessages(FChangesTree) = false) then
  begin
    SynchronizationImg.Picture.Assign(FTaskCheckedPNGImg);
    ResultFinalizeLbl.Caption := _('Synchronization completed successfully.');
  end
  else
  begin
    SynchronizationImg.Picture.Assign(FTaskErrorPNGImg);
    ResultFinalizeLbl.Caption := _('There were errors during synchronization.');
  end;

  NextBtn.Caption := _('Finish');
  BackBtn.Enabled := False;
  CancelBtn.Enabled := False;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.TaskFinished(Task: IGrtGenericTask);

// Called when an asynchronous task has been finished.

begin
  if Task = FFetchSchemaTask then
  begin
    if not TaskHandleError(Task) then
    begin
      FSchemaList := FFetchSchemaTask.Result;
      ConnImg.Picture.Assign(FTaskCheckedPNGImg);
      SchemaListImg.Picture.Assign(FTaskCheckedPNGImg);
    end;
    ResultLbl.Hide;
    FFetchSchemaTask := nil;
    DoProcessEnd;
  end
  else
    if Task = FReverseEngineerTask then
    begin
      if not TaskHandleError(Task) then
      begin
        FCatalog := FReverseEngineerTask.Result;
        Grt.Global['/databaseSync/dbCatalog'] := FCatalog;
        RevEngImg.Picture.Assign(FTaskCheckedPNGImg);

        FGetCatalogChangesTask := Grt.CreateStandardTask(
          'Get catalog changes', 'TransformationMysql', 'getCatalogsChanges',
          [Grt.GetGlobalAsParam('/workbench/catalog'),
            Grt.GetGlobalAsParam('/databaseSync/dbCatalog')],
          ProcessGrtOutput, ProcessGrtMessages, False,
          True, -1, nil, ProcessStatusQuery, TaskFinished);

        Grt.AddTask(FGetCatalogChangesTask);
      end
        else
          DoProcessEnd;

      Grt.ValueRelease(FSelectedSchemaList);
      FSelectedSchemaList := nil;
      Progress2Lbl.Hide;

      FReverseEngineerTask := nil;
    end
    else
      if Task = FGetCatalogChangesTask then
      begin
        // Just show some feedback about the finished task.
        if not TaskHandleError(Task) then
        begin
          FChangesTree := FGetCatalogChangesTask.Result;
          GetCatalogChangesImg.Picture.Assign(FTaskCheckedPNGImg);
        end;
        FGetCatalogChangesTask := nil;
        DoProcessEnd;
      end
      else
        if Task = FGetSQLChangesTask then
        begin
          ShowSQL;
          DoProcessEnd;
        end
        else
          if Task = FApplySQLChangesTask then
          begin
            ShowSQLExecutionStatus;
            DoProcessEnd;
          end
          else
        {if Task = FArrangeTask then
        begin
          if not TaskHandleError(Task) then
          begin
            PlaceObjectsImg.Picture.Assign(FTaskCheckedPNGImg);
            PlaceObjectsLbl.Caption := _('Reverse engineering completed successfully.');
            NextBtn.Caption := _('Finish');
            BackBtn.Enabled := False;
            CancelBtn.Enabled := False;
          end
          else
          begin
            NextBtn.Enabled := False;
            BackBtn.Enabled := True;
            CancelBtn.Enabled := True;
          end;
          DoProcessEnd;
        end
        else}
          TaskHandleError(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

function TDatabaseSynchronisationForm.TaskHandleError(Task: IGrtGenericTask): Boolean;

// Checks if the task has returned an error. If so the error message is shown, the error images are set and
// True is returned. Otherwise False is the result.

var
  StandardTask: IGrtTask;
  Memo: TTntMemo;
  
begin
  Result := False;

  if (Task.ErrorCode <> MYX_GRT_NO_ERROR) or (Task.ErrorString <> '') then
  begin
    Result := True;

    if (MainPageControl.ActivePage = GetSchemataSheet) then
      Memo := GRTMessageMemo
    else
      if (MainPageControl.ActivePage = RevEngSheet) then
        Memo := GRTMessage2Memo
      else
        if (MainPageControl.ActivePage = FinalizeSheet) then
          Memo := GRTMessage3Memo
        else
          Memo := nil;

    if Assigned(Memo) then
    begin
      if Supports(Task, IGrtTask, StandardTask) then
        Memo.Lines.Add(Format(
          _('A problem occured while executing task: %s. '#1310'The error occured in %s.%s and is: %s (code: %d).'),
          [StandardTask.Description, StandardTask.ModuleName, StandardTask.FunctionName, Task.ErrorString, Ord(Task.ErrorCode)]))
      else
        Memo.Lines.Add(Format(
          _('A problem occured while executing a shell task. '#1310'The error is: %s (code: %d).'),
          [Task.ErrorString, Ord(Task.ErrorCode)]));
    end;
    
    ConnImg.Picture.Assign(FTaskErrorPNGImg);
    SchemaListImg.Picture.Assign(FTaskErrorPNGImg);
    NextBtn.Enabled := False;
    BackBtn.Enabled := True;
    CancelBtn.Enabled := True;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

function TDatabaseSynchronisationForm.BuildChangesTree(
  Parent: PVirtualNode; GrtDictObject: Pointer): Boolean;
var
  ChangeFlag: Boolean;
  ChildList: Pointer;
  i, ListSize: Integer;
  Node: PVirtualNode;

begin

  Node := ChangesTree.AddChild(Parent, GrtDictObject);

  ChildList := Grt.DictItem[GrtDictObject, 'children'];
  ChangeFlag := false;
  ListSize := Grt.ListCount(ChildList);

  for i := 0 to ListSize-1 do
  begin
    if(BuildChangesTree(Node, Grt.ListItem[ChildList, i])) then
      ChangeFlag := true;
  end;

  ChangeFlag := ChangeFlag or (Grt.DictInt[GrtDictObject, 'changed'] <> 0);
  ChangesTree.IsVisible[Node] := ChangeFlag;
  Result := ChangeFlag;
end;

procedure TDatabaseSynchronisationForm.DoBuildSyncSelection;
begin
  ChangesTree.Clear;
  BuildChangesTree(nil, FChangesTree);

  // Flip page
  MainPageControl.ActivePage := SyncSheet;
  UpdateAdvancedBtnState;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ChangesTreeGetText(
  Sender: TBaseVirtualTree; Node: PVirtualNode; Column: TColumnIndex;
  TextType: TVSTTextType; var CellText: WideString);
var
  PThis, P1: Pointer;
begin
  PThis := Pointer(Sender.GetNodeData(Node)^);

  if(Column = 0)then
  begin
    P1 := Grt.DictRef[PThis, 'dbObject'];
    CellText := Grt.DictString[P1, 'name'];
  end
  else if(Column = 1)then
  begin
    P1 := Grt.DictRef[PThis, 'modelObject'];
    CellText := Grt.DictString[P1, 'name'];
  end
  else
  begin
    if(Grt.DictInt[PThis, 'changed'] = 0) then
      CellText := 'Unchanged (N/A)'
    else if(Grt.DictInt[PThis, 'alterDirection'] = 0) then
      CellText := 'Apply to DB'
    else
      CellText := 'Apply to model';
  end;
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ChangesTreeClick(Sender: TObject);

var
  Col: TColumnIndex;
  Node: PVirtualNode;
  PThis: Pointer;

  begin
  Col := ChangesTree.Header.Columns.ClickIndex;
  Node := ChangesTree.FocusedNode;

  if((Node <> nil) and (Col = 2))then
  begin
    PThis := Pointer(ChangesTree.GetNodeData(Node)^);

    if(Grt.DictInt[PThis, 'alterDirection'] = 0)then
      Grt.DictInt[PThis, 'alterDirection'] := 1
    else
      Grt.DictInt[PThis, 'alterDirection'] := 0;
  end;  
end;

// -----------------------------------------------------------------------------

procedure TDatabaseSynchronisationForm.ChangesTreeAfterCellPaint(
  Sender: TBaseVirtualTree; TargetCanvas: TCanvas; Node: PVirtualNode;
  Column: TColumnIndex; CellRect: TRect);

var
  TxtRect: TRect;
  x,
  IconIndex: Integer;
  Icon: TPNGObject;
  PImageData: PChar;
  DataLength: Integer;
  PStruct, PThis, PObj: Pointer;
  StructName: WideString;

begin
  if (Column=0) then
  begin
    PThis := Pointer(ChangesTree.GetNodeData(Node)^);

    PObj := Grt.DictRef[PThis, 'dbObject'];
    if(PObj = nil)then
      PObj := Grt.DictRef[PThis, 'modelObject'];

    StructName := Grt.DictStructName[PObj]; 

    TxtRect:=Sender.GetDisplayRect(Node, Column, True);

    x:=TxtRect.Left-Sender.OffsetX;

    // Draw > / v
    if (Node.ChildCount>0) or (vsHasChildren in Node.States) then
    begin
      if(Sender.Expanded[Node])then
        FTreeBtnOpenPNGImg.Draw(TargetCanvas,
          Rect(x-16-12, CellRect.Top+4, x-16+4, CellRect.Top+16+4))
      else
        FTreeBtnClosedPNGImg.Draw(TargetCanvas,
          Rect(x-16-12, CellRect.Top+4, x-16+4, CellRect.Top+16+4))
    end;

    // Draw Icons
        begin
          IconIndex := Grt.StructIconsList.IndexOf(StructName);

          // check if there is a cached icon for the struct already
          if (IconIndex > -1) then
          begin
            // if the struct was cached, use its icon, if there is any
            Icon := TPNGObject(Grt.StructIconsList.Objects[IconIndex]);

            // if there is no special icon for the struct, use the default one
            if (Icon = nil) then
              Icon := FGrtValueStructPNGImg;
          end
          else
          begin
            PStruct := myx_grt_struct_get(Grt.NativeGrt, StructName);

            if (PStruct <> nil) then
            begin
              PImageData := _myx_grt_struct_get_icon(Grt.NativeGrt,
                PChar(ExtractFilePath(Application.ExeName)+'images\structs\'),
                PStruct, MYX_IT_SMALL, @DataLength);

              Icon := LoadPNGImageFromPChar(PImageData, DataLength);

              Grt.StructIconsList.AddObject(StructName, Icon);
            end
            else
              Icon := FGrtValueStructPNGImg;
          end;

        end;

    if (Icon <> nil) then
      Icon.Draw(TargetCanvas,
        Rect(x-16, CellRect.Top+1, x, CellRect.Top+1+16));
  end;
end;

end.
