import os.path, sys, subprocess, shutil

def setup(args, plugins):
    script_dir = os.path.abspath(os.path.dirname(__file__))
    build_dir = os.path.join(script_dir, 'build')
    installed = (os.path.basename(script_dir) != 'elisa-core')
    if installed:
        # Run extracted from the tarball to install
        plugins_dir = os.path.normpath(os.path.join(script_dir, 'elisa', 'plugins'))
        if os.path.exists(build_dir):
            shutil.rmtree(build_dir)
    else:
        # Run from the development branch to create the tarball
        plugins_dir = os.path.normpath(os.path.join(script_dir, '..', 'elisa-plugins', 'elisa', 'plugins'))

    for plugin in plugins:
        if 'install' in args and installed and os.path.exists(build_dir):
            shutil.rmtree(build_dir)
        script = os.path.join(plugins_dir, plugin, 'setup.py')
        subprocess.call([sys.executable, script] + args)
